@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessToken Time unit for the value in `access_token_validity` and defaults to `hours`.
 * @property idToken Time unit for the value in `id_token_validity`, and it defaults to `hours`.
 * @property refreshToken Time unit for the value in `refresh_token_validity` and defaults to `days`.
 */
public data class ManagedUserPoolClientTokenValidityUnits(
    public val accessToken: String? = null,
    public val idToken: String? = null,
    public val refreshToken: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.ManagedUserPoolClientTokenValidityUnits): ManagedUserPoolClientTokenValidityUnits = ManagedUserPoolClientTokenValidityUnits(
            accessToken = javaType.accessToken().map({ args0 -> args0 }).orElse(null),
            idToken = javaType.idToken().map({ args0 -> args0 }).orElse(null),
            refreshToken = javaType.refreshToken().map({ args0 -> args0 }).orElse(null),
        )
    }
}
