@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property highAction Action to take for a high risk. See action block below.
 * @property lowAction Action to take for a low risk. See action block below.
 * @property mediumAction Action to take for a medium risk. See action block below.
 */
public data class RiskConfigurationAccountTakeoverRiskConfigurationActions(
    public val highAction: RiskConfigurationAccountTakeoverRiskConfigurationActionsHighAction? = null,
    public val lowAction: RiskConfigurationAccountTakeoverRiskConfigurationActionsLowAction? = null,
    public val mediumAction: RiskConfigurationAccountTakeoverRiskConfigurationActionsMediumAction? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.RiskConfigurationAccountTakeoverRiskConfigurationActions): RiskConfigurationAccountTakeoverRiskConfigurationActions =
            RiskConfigurationAccountTakeoverRiskConfigurationActions(
                highAction = javaType.highAction().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cognito.kotlin.outputs.RiskConfigurationAccountTakeoverRiskConfigurationActionsHighAction.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                lowAction = javaType.lowAction().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cognito.kotlin.outputs.RiskConfigurationAccountTakeoverRiskConfigurationActionsLowAction.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                mediumAction = javaType.mediumAction().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cognito.kotlin.outputs.RiskConfigurationAccountTakeoverRiskConfigurationActionsMediumAction.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
