@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property actions The compromised credentials risk configuration actions. See details below.
 * @property eventFilters Perform the action for these events. The default is to perform all events if no event filter is specified. Valid values are `SIGN_IN`, `PASSWORD_CHANGE`, and `SIGN_UP`.
 */
public data class RiskConfigurationCompromisedCredentialsRiskConfiguration(
    public val actions: RiskConfigurationCompromisedCredentialsRiskConfigurationActions,
    public val eventFilters: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.RiskConfigurationCompromisedCredentialsRiskConfiguration): RiskConfigurationCompromisedCredentialsRiskConfiguration =
            RiskConfigurationCompromisedCredentialsRiskConfiguration(
                actions = javaType.actions().let({ args0 ->
                    com.pulumi.aws.cognito.kotlin.outputs.RiskConfigurationCompromisedCredentialsRiskConfigurationActions.Companion.toKotlin(args0)
                }),
                eventFilters = javaType.eventFilters().map({ args0 -> args0 }),
            )
    }
}
