@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property blockedIpRangeLists Overrides the risk decision to always block the pre-authentication requests.
 * The IP range is in CIDR notation, a compact representation of an IP address and its routing prefix.
 * Can contain a maximum of 200 items.
 * @property skippedIpRangeLists Risk detection isn't performed on the IP addresses in this range list.
 * The IP range is in CIDR notation.
 * Can contain a maximum of 200 items.
 */
public data class RiskConfigurationRiskExceptionConfiguration(
    public val blockedIpRangeLists: List<String>? = null,
    public val skippedIpRangeLists: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.RiskConfigurationRiskExceptionConfiguration): RiskConfigurationRiskExceptionConfiguration = RiskConfigurationRiskExceptionConfiguration(
            blockedIpRangeLists = javaType.blockedIpRangeLists().map({ args0 -> args0 }),
            skippedIpRangeLists = javaType.skippedIpRangeLists().map({ args0 -> args0 }),
        )
    }
}
