@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name Recovery method for a user. Can be of the following: `verified_email`, `verified_phone_number`, and `admin_only`.
 * @property priority Positive integer specifying priority of a method with 1 being the highest priority.
 */
public data class UserPoolAccountRecoverySettingRecoveryMechanism(
    public val name: String,
    public val priority: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.UserPoolAccountRecoverySettingRecoveryMechanism): UserPoolAccountRecoverySettingRecoveryMechanism =
            UserPoolAccountRecoverySettingRecoveryMechanism(
                name = javaType.name(),
                priority = javaType.priority(),
            )
    }
}
