@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property emailMessage Message template for email messages. Must contain `{username}` and `{####}` placeholders, for username and temporary password, respectively.
 * @property emailSubject Subject line for email messages.
 * @property smsMessage Message template for SMS messages. Must contain `{username}` and `{####}` placeholders, for username and temporary password, respectively.
 */
public data class UserPoolAdminCreateUserConfigInviteMessageTemplate(
    public val emailMessage: String? = null,
    public val emailSubject: String? = null,
    public val smsMessage: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.UserPoolAdminCreateUserConfigInviteMessageTemplate): UserPoolAdminCreateUserConfigInviteMessageTemplate =
            UserPoolAdminCreateUserConfigInviteMessageTemplate(
                emailMessage = javaType.emailMessage().map({ args0 -> args0 }).orElse(null),
                emailSubject = javaType.emailSubject().map({ args0 -> args0 }).orElse(null),
                smsMessage = javaType.smsMessage().map({ args0 -> args0 }).orElse(null),
            )
    }
}
