@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessToken Time unit in for the value in `access_token_validity`, defaults to `hours`.
 * @property idToken Time unit in for the value in `id_token_validity`, defaults to `hours`.
 * @property refreshToken Time unit in for the value in `refresh_token_validity`, defaults to `days`.
 */
public data class UserPoolClientTokenValidityUnits(
    public val accessToken: String? = null,
    public val idToken: String? = null,
    public val refreshToken: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.UserPoolClientTokenValidityUnits): UserPoolClientTokenValidityUnits = UserPoolClientTokenValidityUnits(
            accessToken = javaType.accessToken().map({ args0 -> args0 }).orElse(null),
            idToken = javaType.idToken().map({ args0 -> args0 }).orElse(null),
            refreshToken = javaType.refreshToken().map({ args0 -> args0 }).orElse(null),
        )
    }
}
