@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property challengeRequiredOnNewDevice Whether a challenge is required on a new device. Only applicable to a new device.
 * @property deviceOnlyRememberedOnUserPrompt Whether a device is only remembered on user prompt. `false` equates to "Always" remember, `true` is "User Opt In," and not using a `device_configuration` block is "No."
 */
public data class UserPoolDeviceConfiguration(
    public val challengeRequiredOnNewDevice: Boolean? = null,
    public val deviceOnlyRememberedOnUserPrompt: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.UserPoolDeviceConfiguration): UserPoolDeviceConfiguration = UserPoolDeviceConfiguration(
            challengeRequiredOnNewDevice = javaType.challengeRequiredOnNewDevice().map({ args0 ->
                args0
            }).orElse(null),
            deviceOnlyRememberedOnUserPrompt = javaType.deviceOnlyRememberedOnUserPrompt().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
