@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createAuthChallenge ARN of the lambda creating an authentication challenge.
 * @property customEmailSender A custom email sender AWS Lambda trigger. See custom_email_sender Below.
 * @property customMessage Custom Message AWS Lambda trigger.
 * @property customSmsSender A custom SMS sender AWS Lambda trigger. See custom_sms_sender Below.
 * @property defineAuthChallenge Defines the authentication challenge.
 * @property kmsKeyId The Amazon Resource Name of Key Management Service Customer master keys. Amazon Cognito uses the key to encrypt codes and temporary passwords sent to CustomEmailSender and CustomSMSSender.
 * @property postAuthentication Post-authentication AWS Lambda trigger.
 * @property postConfirmation Post-confirmation AWS Lambda trigger.
 * @property preAuthentication Pre-authentication AWS Lambda trigger.
 * @property preSignUp Pre-registration AWS Lambda trigger.
 * @property preTokenGeneration Allow to customize identity token claims before token generation. Set this parameter for legacy purposes; for new instances of pre token generation triggers, set the lambda_arn of `pre_token_generation_config`.
 * @property preTokenGenerationConfig Allow to customize access tokens. See pre_token_configuration_type
 * @property userMigration User migration Lambda config type.
 * @property verifyAuthChallengeResponse Verifies the authentication challenge response.
 */
public data class UserPoolLambdaConfig(
    public val createAuthChallenge: String? = null,
    public val customEmailSender: UserPoolLambdaConfigCustomEmailSender? = null,
    public val customMessage: String? = null,
    public val customSmsSender: UserPoolLambdaConfigCustomSmsSender? = null,
    public val defineAuthChallenge: String? = null,
    public val kmsKeyId: String? = null,
    public val postAuthentication: String? = null,
    public val postConfirmation: String? = null,
    public val preAuthentication: String? = null,
    public val preSignUp: String? = null,
    public val preTokenGeneration: String? = null,
    public val preTokenGenerationConfig: UserPoolLambdaConfigPreTokenGenerationConfig? = null,
    public val userMigration: String? = null,
    public val verifyAuthChallengeResponse: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.UserPoolLambdaConfig): UserPoolLambdaConfig = UserPoolLambdaConfig(
            createAuthChallenge = javaType.createAuthChallenge().map({ args0 -> args0 }).orElse(null),
            customEmailSender = javaType.customEmailSender().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cognito.kotlin.outputs.UserPoolLambdaConfigCustomEmailSender.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customMessage = javaType.customMessage().map({ args0 -> args0 }).orElse(null),
            customSmsSender = javaType.customSmsSender().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cognito.kotlin.outputs.UserPoolLambdaConfigCustomSmsSender.Companion.toKotlin(args0)
                })
            }).orElse(null),
            defineAuthChallenge = javaType.defineAuthChallenge().map({ args0 -> args0 }).orElse(null),
            kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
            postAuthentication = javaType.postAuthentication().map({ args0 -> args0 }).orElse(null),
            postConfirmation = javaType.postConfirmation().map({ args0 -> args0 }).orElse(null),
            preAuthentication = javaType.preAuthentication().map({ args0 -> args0 }).orElse(null),
            preSignUp = javaType.preSignUp().map({ args0 -> args0 }).orElse(null),
            preTokenGeneration = javaType.preTokenGeneration().map({ args0 -> args0 }).orElse(null),
            preTokenGenerationConfig = javaType.preTokenGenerationConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cognito.kotlin.outputs.UserPoolLambdaConfigPreTokenGenerationConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            userMigration = javaType.userMigration().map({ args0 -> args0 }).orElse(null),
            verifyAuthChallengeResponse = javaType.verifyAuthChallengeResponse().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
