@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property lambdaArn The Lambda Amazon Resource Name of the Lambda function that Amazon Cognito triggers to send email notifications to users.
 * @property lambdaVersion The Lambda version represents the signature of the "request" attribute in the "event" information Amazon Cognito passes to your custom email Lambda function. The only supported value is `V1_0`.
 */
public data class UserPoolLambdaConfigCustomEmailSender(
    public val lambdaArn: String,
    public val lambdaVersion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.UserPoolLambdaConfigCustomEmailSender): UserPoolLambdaConfigCustomEmailSender = UserPoolLambdaConfigCustomEmailSender(
            lambdaArn = javaType.lambdaArn(),
            lambdaVersion = javaType.lambdaVersion(),
        )
    }
}
