@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property minimumLength Minimum length of the password policy that you have set.
 * @property requireLowercase Whether you have required users to use at least one lowercase letter in their password.
 * @property requireNumbers Whether you have required users to use at least one number in their password.
 * @property requireSymbols Whether you have required users to use at least one symbol in their password.
 * @property requireUppercase Whether you have required users to use at least one uppercase letter in their password.
 * @property temporaryPasswordValidityDays In the password policy you have set, refers to the number of days a temporary password is valid. If the user does not sign-in during this time, their password will need to be reset by an administrator.
 */
public data class UserPoolPasswordPolicy(
    public val minimumLength: Int? = null,
    public val requireLowercase: Boolean? = null,
    public val requireNumbers: Boolean? = null,
    public val requireSymbols: Boolean? = null,
    public val requireUppercase: Boolean? = null,
    public val temporaryPasswordValidityDays: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.UserPoolPasswordPolicy): UserPoolPasswordPolicy = UserPoolPasswordPolicy(
            minimumLength = javaType.minimumLength().map({ args0 -> args0 }).orElse(null),
            requireLowercase = javaType.requireLowercase().map({ args0 -> args0 }).orElse(null),
            requireNumbers = javaType.requireNumbers().map({ args0 -> args0 }).orElse(null),
            requireSymbols = javaType.requireSymbols().map({ args0 -> args0 }).orElse(null),
            requireUppercase = javaType.requireUppercase().map({ args0 -> args0 }).orElse(null),
            temporaryPasswordValidityDays = javaType.temporaryPasswordValidityDays().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
