@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property attributeDataType Attribute data type. Must be one of `Boolean`, `Number`, `String`, `DateTime`.
 * @property developerOnlyAttribute Whether the attribute type is developer only.
 * @property mutable Whether the attribute can be changed once it has been created.
 * @property name Name of the attribute.
 * @property numberAttributeConstraints Configuration block for the constraints for an attribute of the number type. Detailed below.
 * @property required Whether a user pool attribute is required. If the attribute is required and the user does not provide a value, registration or sign-in will fail.
 * @property stringAttributeConstraints Constraints for an attribute of the string type. Detailed below.
 */
public data class UserPoolSchema(
    public val attributeDataType: String,
    public val developerOnlyAttribute: Boolean? = null,
    public val mutable: Boolean? = null,
    public val name: String,
    public val numberAttributeConstraints: UserPoolSchemaNumberAttributeConstraints? = null,
    public val required: Boolean? = null,
    public val stringAttributeConstraints: UserPoolSchemaStringAttributeConstraints? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.UserPoolSchema): UserPoolSchema =
            UserPoolSchema(
                attributeDataType = javaType.attributeDataType(),
                developerOnlyAttribute = javaType.developerOnlyAttribute().map({ args0 -> args0 }).orElse(null),
                mutable = javaType.mutable().map({ args0 -> args0 }).orElse(null),
                name = javaType.name(),
                numberAttributeConstraints = javaType.numberAttributeConstraints().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cognito.kotlin.outputs.UserPoolSchemaNumberAttributeConstraints.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                required = javaType.required().map({ args0 -> args0 }).orElse(null),
                stringAttributeConstraints = javaType.stringAttributeConstraints().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cognito.kotlin.outputs.UserPoolSchemaStringAttributeConstraints.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
