@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property maxValue Maximum value of an attribute that is of the number data type.
 * @property minValue Minimum value of an attribute that is of the number data type.
 */
public data class UserPoolSchemaNumberAttributeConstraints(
    public val maxValue: String? = null,
    public val minValue: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.UserPoolSchemaNumberAttributeConstraints): UserPoolSchemaNumberAttributeConstraints = UserPoolSchemaNumberAttributeConstraints(
            maxValue = javaType.maxValue().map({ args0 -> args0 }).orElse(null),
            minValue = javaType.minValue().map({ args0 -> args0 }).orElse(null),
        )
    }
}
