@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property maxLength Maximum length of an attribute value of the string type.
 * @property minLength Minimum length of an attribute value of the string type.
 */
public data class UserPoolSchemaStringAttributeConstraints(
    public val maxLength: String? = null,
    public val minLength: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.UserPoolSchemaStringAttributeConstraints): UserPoolSchemaStringAttributeConstraints = UserPoolSchemaStringAttributeConstraints(
            maxLength = javaType.maxLength().map({ args0 -> args0 }).orElse(null),
            minLength = javaType.minLength().map({ args0 -> args0 }).orElse(null),
        )
    }
}
