@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property defaultEmailOption Default email option. Must be either `CONFIRM_WITH_CODE` or `CONFIRM_WITH_LINK`. Defaults to `CONFIRM_WITH_CODE`.
 * @property emailMessage Email message template. Must contain the `{####}` placeholder. Conflicts with `email_verification_message` argument.
 * @property emailMessageByLink Email message template for sending a confirmation link to the user, it must contain the `{##Click Here##}` placeholder.
 * @property emailSubject Subject line for the email message template. Conflicts with `email_verification_subject` argument.
 * @property emailSubjectByLink Subject line for the email message template for sending a confirmation link to the user.
 * @property smsMessage SMS message template. Must contain the `{####}` placeholder. Conflicts with `sms_verification_message` argument.
 */
public data class UserPoolVerificationMessageTemplate(
    public val defaultEmailOption: String? = null,
    public val emailMessage: String? = null,
    public val emailMessageByLink: String? = null,
    public val emailSubject: String? = null,
    public val emailSubjectByLink: String? = null,
    public val smsMessage: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.UserPoolVerificationMessageTemplate): UserPoolVerificationMessageTemplate = UserPoolVerificationMessageTemplate(
            defaultEmailOption = javaType.defaultEmailOption().map({ args0 -> args0 }).orElse(null),
            emailMessage = javaType.emailMessage().map({ args0 -> args0 }).orElse(null),
            emailMessageByLink = javaType.emailMessageByLink().map({ args0 -> args0 }).orElse(null),
            emailSubject = javaType.emailSubject().map({ args0 -> args0 }).orElse(null),
            emailSubjectByLink = javaType.emailSubjectByLink().map({ args0 -> args0 }).orElse(null),
            smsMessage = javaType.smsMessage().map({ args0 -> args0 }).orElse(null),
        )
    }
}
