@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.comprehend.kotlin

import com.pulumi.aws.comprehend.kotlin.outputs.DocumentClassifierInputDataConfig
import com.pulumi.aws.comprehend.kotlin.outputs.DocumentClassifierOutputDataConfig
import com.pulumi.aws.comprehend.kotlin.outputs.DocumentClassifierVpcConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.comprehend.kotlin.outputs.DocumentClassifierInputDataConfig.Companion.toKotlin as documentClassifierInputDataConfigToKotlin
import com.pulumi.aws.comprehend.kotlin.outputs.DocumentClassifierOutputDataConfig.Companion.toKotlin as documentClassifierOutputDataConfigToKotlin
import com.pulumi.aws.comprehend.kotlin.outputs.DocumentClassifierVpcConfig.Companion.toKotlin as documentClassifierVpcConfigToKotlin

/**
 * Builder for [DocumentClassifier].
 */
@PulumiTagMarker
public class DocumentClassifierResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DocumentClassifierArgs = DocumentClassifierArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DocumentClassifierArgsBuilder.() -> Unit) {
        val builder = DocumentClassifierArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DocumentClassifier {
        val builtJavaResource = com.pulumi.aws.comprehend.DocumentClassifier(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DocumentClassifier(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Comprehend Document Classifier.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const documents = new aws.s3.BucketObjectv2("documents", {});
 * const example = new aws.comprehend.DocumentClassifier("example", {
 *     name: "example",
 *     dataAccessRoleArn: exampleAwsIamRole.arn,
 *     languageCode: "en",
 *     inputDataConfig: {
 *         s3Uri: pulumi.interpolate`s3://${test.bucket}/${documents.id}`,
 *     },
 * }, {
 *     dependsOn: [exampleAwsIamRolePolicy],
 * });
 * const entities = new aws.s3.BucketObjectv2("entities", {});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * documents = aws.s3.BucketObjectv2("documents")
 * example = aws.comprehend.DocumentClassifier("example",
 *     name="example",
 *     data_access_role_arn=example_aws_iam_role["arn"],
 *     language_code="en",
 *     input_data_config={
 *         "s3_uri": documents.id.apply(lambda id: f"s3://{test['bucket']}/{id}"),
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[example_aws_iam_role_policy]))
 * entities = aws.s3.BucketObjectv2("entities")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var documents = new Aws.S3.BucketObjectv2("documents");
 *     var example = new Aws.Comprehend.DocumentClassifier("example", new()
 *     {
 *         Name = "example",
 *         DataAccessRoleArn = exampleAwsIamRole.Arn,
 *         LanguageCode = "en",
 *         InputDataConfig = new Aws.Comprehend.Inputs.DocumentClassifierInputDataConfigArgs
 *         {
 *             S3Uri = documents.Id.Apply(id => $"s3://{test.Bucket}/{id}"),
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsIamRolePolicy,
 *         },
 *     });
 *     var entities = new Aws.S3.BucketObjectv2("entities");
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/comprehend"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		documents, err := s3.NewBucketObjectv2(ctx, "documents", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = comprehend.NewDocumentClassifier(ctx, "example", &comprehend.DocumentClassifierArgs{
 * 			Name:              pulumi.String("example"),
 * 			DataAccessRoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * 			LanguageCode:      pulumi.String("en"),
 * 			InputDataConfig: &comprehend.DocumentClassifierInputDataConfigArgs{
 * 				S3Uri: documents.ID().ApplyT(func(id string) (string, error) {
 * 					return fmt.Sprintf("s3://%v/%v", test.Bucket, id), nil
 * 				}).(pulumi.StringOutput),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsIamRolePolicy,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketObjectv2(ctx, "entities", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.comprehend.DocumentClassifier;
 * import com.pulumi.aws.comprehend.DocumentClassifierArgs;
 * import com.pulumi.aws.comprehend.inputs.DocumentClassifierInputDataConfigArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var documents = new BucketObjectv2("documents");
 *         var example = new DocumentClassifier("example", DocumentClassifierArgs.builder()
 *             .name("example")
 *             .dataAccessRoleArn(exampleAwsIamRole.arn())
 *             .languageCode("en")
 *             .inputDataConfig(DocumentClassifierInputDataConfigArgs.builder()
 *                 .s3Uri(documents.id().applyValue(id -> String.format("s3://%s/%s", test.bucket(),id)))
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAwsIamRolePolicy)
 *                 .build());
 *         var entities = new BucketObjectv2("entities");
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:comprehend:DocumentClassifier
 *     properties:
 *       name: example
 *       dataAccessRoleArn: ${exampleAwsIamRole.arn}
 *       languageCode: en
 *       inputDataConfig:
 *         s3Uri: s3://${test.bucket}/${documents.id}
 *     options:
 *       dependson:
 *         - ${exampleAwsIamRolePolicy}
 *   documents:
 *     type: aws:s3:BucketObjectv2
 *   entities:
 *     type: aws:s3:BucketObjectv2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Comprehend Document Classifier using the ARN. For example:
 * ```sh
 * $ pulumi import aws:comprehend/documentClassifier:DocumentClassifier example arn:aws:comprehend:us-west-2:123456789012:document_classifier/example
 * ```
 */
public class DocumentClassifier internal constructor(
    override val javaResource: com.pulumi.aws.comprehend.DocumentClassifier,
) : KotlinCustomResource(javaResource, DocumentClassifierMapper) {
    /**
     * ARN of the Document Classifier version.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ARN for an IAM Role which allows Comprehend to read the training and testing data.
     */
    public val dataAccessRoleArn: Output<String>
        get() = javaResource.dataAccessRoleArn().applyValue({ args0 -> args0 })

    /**
     * Configuration for the training and testing data.
     * See the `input_data_config` Configuration Block section below.
     */
    public val inputDataConfig: Output<DocumentClassifierInputDataConfig>
        get() = javaResource.inputDataConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                documentClassifierInputDataConfigToKotlin(args0)
            })
        })

    /**
     * Two-letter language code for the language.
     * One of `en`, `es`, `fr`, `it`, `de`, or `pt`.
     */
    public val languageCode: Output<String>
        get() = javaResource.languageCode().applyValue({ args0 -> args0 })

    /**
     * The document classification mode.
     * One of `MULTI_CLASS` or `MULTI_LABEL`.
     * `MULTI_CLASS` is also known as "Single Label" in the AWS Console.
     */
    public val mode: Output<String>?
        get() = javaResource.mode().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * KMS Key used to encrypt trained Document Classifiers.
     * Can be a KMS Key ID or a KMS Key ARN.
     */
    public val modelKmsKeyId: Output<String>?
        get() = javaResource.modelKmsKeyId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name for the Document Classifier.
     * Has a maximum length of 63 characters.
     * Can contain upper- and lower-case letters, numbers, and hypen (`-`).
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Configuration for the output results of training.
     * See the `output_data_config` Configuration Block section below.
     */
    public val outputDataConfig: Output<DocumentClassifierOutputDataConfig>
        get() = javaResource.outputDataConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                documentClassifierOutputDataConfigToKotlin(args0)
            })
        })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` Configuration Block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Name for the version of the Document Classifier.
     * Each version must have a unique name within the Document Classifier.
     * If omitted, the provider will assign a random, unique version name.
     * If explicitly set to `""`, no version name will be set.
     * Has a maximum length of 63 characters.
     * Can contain upper- and lower-case letters, numbers, and hypen (`-`).
     * Conflicts with `version_name_prefix`.
     */
    public val versionName: Output<String>
        get() = javaResource.versionName().applyValue({ args0 -> args0 })

    /**
     * Creates a unique version name beginning with the specified prefix.
     * Has a maximum length of 37 characters.
     * Can contain upper- and lower-case letters, numbers, and hypen (`-`).
     * Conflicts with `version_name`.
     */
    public val versionNamePrefix: Output<String>
        get() = javaResource.versionNamePrefix().applyValue({ args0 -> args0 })

    /**
     * KMS Key used to encrypt storage volumes during job processing.
     * Can be a KMS Key ID or a KMS Key ARN.
     */
    public val volumeKmsKeyId: Output<String>?
        get() = javaResource.volumeKmsKeyId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration parameters for VPC to contain Document Classifier resources.
     * See the `vpc_config` Configuration Block section below.
     */
    public val vpcConfig: Output<DocumentClassifierVpcConfig>?
        get() = javaResource.vpcConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    documentClassifierVpcConfigToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object DocumentClassifierMapper : ResourceMapper<DocumentClassifier> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.comprehend.DocumentClassifier::class == javaResource::class

    override fun map(javaResource: Resource): DocumentClassifier = DocumentClassifier(
        javaResource as
            com.pulumi.aws.comprehend.DocumentClassifier,
    )
}

/**
 * @see [DocumentClassifier].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DocumentClassifier].
 */
public suspend fun documentClassifier(
    name: String,
    block: suspend DocumentClassifierResourceBuilder.() -> Unit,
): DocumentClassifier {
    val builder = DocumentClassifierResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DocumentClassifier].
 * @param name The _unique_ name of the resulting resource.
 */
public fun documentClassifier(name: String): DocumentClassifier {
    val builder = DocumentClassifierResourceBuilder()
    builder.name(name)
    return builder.build()
}
