@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.comprehend.kotlin

import com.pulumi.aws.comprehend.DocumentClassifierArgs.builder
import com.pulumi.aws.comprehend.kotlin.inputs.DocumentClassifierInputDataConfigArgs
import com.pulumi.aws.comprehend.kotlin.inputs.DocumentClassifierInputDataConfigArgsBuilder
import com.pulumi.aws.comprehend.kotlin.inputs.DocumentClassifierOutputDataConfigArgs
import com.pulumi.aws.comprehend.kotlin.inputs.DocumentClassifierOutputDataConfigArgsBuilder
import com.pulumi.aws.comprehend.kotlin.inputs.DocumentClassifierVpcConfigArgs
import com.pulumi.aws.comprehend.kotlin.inputs.DocumentClassifierVpcConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Comprehend Document Classifier.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const documents = new aws.s3.BucketObjectv2("documents", {});
 * const example = new aws.comprehend.DocumentClassifier("example", {
 *     name: "example",
 *     dataAccessRoleArn: exampleAwsIamRole.arn,
 *     languageCode: "en",
 *     inputDataConfig: {
 *         s3Uri: pulumi.interpolate`s3://${test.bucket}/${documents.id}`,
 *     },
 * }, {
 *     dependsOn: [exampleAwsIamRolePolicy],
 * });
 * const entities = new aws.s3.BucketObjectv2("entities", {});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * documents = aws.s3.BucketObjectv2("documents")
 * example = aws.comprehend.DocumentClassifier("example",
 *     name="example",
 *     data_access_role_arn=example_aws_iam_role["arn"],
 *     language_code="en",
 *     input_data_config={
 *         "s3_uri": documents.id.apply(lambda id: f"s3://{test['bucket']}/{id}"),
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[example_aws_iam_role_policy]))
 * entities = aws.s3.BucketObjectv2("entities")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var documents = new Aws.S3.BucketObjectv2("documents");
 *     var example = new Aws.Comprehend.DocumentClassifier("example", new()
 *     {
 *         Name = "example",
 *         DataAccessRoleArn = exampleAwsIamRole.Arn,
 *         LanguageCode = "en",
 *         InputDataConfig = new Aws.Comprehend.Inputs.DocumentClassifierInputDataConfigArgs
 *         {
 *             S3Uri = documents.Id.Apply(id => $"s3://{test.Bucket}/{id}"),
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsIamRolePolicy,
 *         },
 *     });
 *     var entities = new Aws.S3.BucketObjectv2("entities");
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/comprehend"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		documents, err := s3.NewBucketObjectv2(ctx, "documents", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = comprehend.NewDocumentClassifier(ctx, "example", &comprehend.DocumentClassifierArgs{
 * 			Name:              pulumi.String("example"),
 * 			DataAccessRoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * 			LanguageCode:      pulumi.String("en"),
 * 			InputDataConfig: &comprehend.DocumentClassifierInputDataConfigArgs{
 * 				S3Uri: documents.ID().ApplyT(func(id string) (string, error) {
 * 					return fmt.Sprintf("s3://%v/%v", test.Bucket, id), nil
 * 				}).(pulumi.StringOutput),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsIamRolePolicy,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketObjectv2(ctx, "entities", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.comprehend.DocumentClassifier;
 * import com.pulumi.aws.comprehend.DocumentClassifierArgs;
 * import com.pulumi.aws.comprehend.inputs.DocumentClassifierInputDataConfigArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var documents = new BucketObjectv2("documents");
 *         var example = new DocumentClassifier("example", DocumentClassifierArgs.builder()
 *             .name("example")
 *             .dataAccessRoleArn(exampleAwsIamRole.arn())
 *             .languageCode("en")
 *             .inputDataConfig(DocumentClassifierInputDataConfigArgs.builder()
 *                 .s3Uri(documents.id().applyValue(id -> String.format("s3://%s/%s", test.bucket(),id)))
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAwsIamRolePolicy)
 *                 .build());
 *         var entities = new BucketObjectv2("entities");
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:comprehend:DocumentClassifier
 *     properties:
 *       name: example
 *       dataAccessRoleArn: ${exampleAwsIamRole.arn}
 *       languageCode: en
 *       inputDataConfig:
 *         s3Uri: s3://${test.bucket}/${documents.id}
 *     options:
 *       dependson:
 *         - ${exampleAwsIamRolePolicy}
 *   documents:
 *     type: aws:s3:BucketObjectv2
 *   entities:
 *     type: aws:s3:BucketObjectv2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Comprehend Document Classifier using the ARN. For example:
 * ```sh
 * $ pulumi import aws:comprehend/documentClassifier:DocumentClassifier example arn:aws:comprehend:us-west-2:123456789012:document_classifier/example
 * ```
 * @property dataAccessRoleArn The ARN for an IAM Role which allows Comprehend to read the training and testing data.
 * @property inputDataConfig Configuration for the training and testing data.
 * See the `input_data_config` Configuration Block section below.
 * @property languageCode Two-letter language code for the language.
 * One of `en`, `es`, `fr`, `it`, `de`, or `pt`.
 * @property mode The document classification mode.
 * One of `MULTI_CLASS` or `MULTI_LABEL`.
 * `MULTI_CLASS` is also known as "Single Label" in the AWS Console.
 * @property modelKmsKeyId KMS Key used to encrypt trained Document Classifiers.
 * Can be a KMS Key ID or a KMS Key ARN.
 * @property name Name for the Document Classifier.
 * Has a maximum length of 63 characters.
 * Can contain upper- and lower-case letters, numbers, and hypen (`-`).
 * The following arguments are optional:
 * @property outputDataConfig Configuration for the output results of training.
 * See the `output_data_config` Configuration Block section below.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` Configuration Block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property versionName Name for the version of the Document Classifier.
 * Each version must have a unique name within the Document Classifier.
 * If omitted, the provider will assign a random, unique version name.
 * If explicitly set to `""`, no version name will be set.
 * Has a maximum length of 63 characters.
 * Can contain upper- and lower-case letters, numbers, and hypen (`-`).
 * Conflicts with `version_name_prefix`.
 * @property versionNamePrefix Creates a unique version name beginning with the specified prefix.
 * Has a maximum length of 37 characters.
 * Can contain upper- and lower-case letters, numbers, and hypen (`-`).
 * Conflicts with `version_name`.
 * @property volumeKmsKeyId KMS Key used to encrypt storage volumes during job processing.
 * Can be a KMS Key ID or a KMS Key ARN.
 * @property vpcConfig Configuration parameters for VPC to contain Document Classifier resources.
 * See the `vpc_config` Configuration Block section below.
 */
public data class DocumentClassifierArgs(
    public val dataAccessRoleArn: Output<String>? = null,
    public val inputDataConfig: Output<DocumentClassifierInputDataConfigArgs>? = null,
    public val languageCode: Output<String>? = null,
    public val mode: Output<String>? = null,
    public val modelKmsKeyId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val outputDataConfig: Output<DocumentClassifierOutputDataConfigArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val versionName: Output<String>? = null,
    public val versionNamePrefix: Output<String>? = null,
    public val volumeKmsKeyId: Output<String>? = null,
    public val vpcConfig: Output<DocumentClassifierVpcConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.comprehend.DocumentClassifierArgs> {
    override fun toJava(): com.pulumi.aws.comprehend.DocumentClassifierArgs =
        com.pulumi.aws.comprehend.DocumentClassifierArgs.builder()
            .dataAccessRoleArn(dataAccessRoleArn?.applyValue({ args0 -> args0 }))
            .inputDataConfig(inputDataConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .languageCode(languageCode?.applyValue({ args0 -> args0 }))
            .mode(mode?.applyValue({ args0 -> args0 }))
            .modelKmsKeyId(modelKmsKeyId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .outputDataConfig(outputDataConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .versionName(versionName?.applyValue({ args0 -> args0 }))
            .versionNamePrefix(versionNamePrefix?.applyValue({ args0 -> args0 }))
            .volumeKmsKeyId(volumeKmsKeyId?.applyValue({ args0 -> args0 }))
            .vpcConfig(vpcConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DocumentClassifierArgs].
 */
@PulumiTagMarker
public class DocumentClassifierArgsBuilder internal constructor() {
    private var dataAccessRoleArn: Output<String>? = null

    private var inputDataConfig: Output<DocumentClassifierInputDataConfigArgs>? = null

    private var languageCode: Output<String>? = null

    private var mode: Output<String>? = null

    private var modelKmsKeyId: Output<String>? = null

    private var name: Output<String>? = null

    private var outputDataConfig: Output<DocumentClassifierOutputDataConfigArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var versionName: Output<String>? = null

    private var versionNamePrefix: Output<String>? = null

    private var volumeKmsKeyId: Output<String>? = null

    private var vpcConfig: Output<DocumentClassifierVpcConfigArgs>? = null

    /**
     * @param value The ARN for an IAM Role which allows Comprehend to read the training and testing data.
     */
    @JvmName("nvwjdtohimhyuvow")
    public suspend fun dataAccessRoleArn(`value`: Output<String>) {
        this.dataAccessRoleArn = value
    }

    /**
     * @param value Configuration for the training and testing data.
     * See the `input_data_config` Configuration Block section below.
     */
    @JvmName("wnchmsrbcqwuaphj")
    public suspend fun inputDataConfig(`value`: Output<DocumentClassifierInputDataConfigArgs>) {
        this.inputDataConfig = value
    }

    /**
     * @param value Two-letter language code for the language.
     * One of `en`, `es`, `fr`, `it`, `de`, or `pt`.
     */
    @JvmName("bsbiflfihokhiaog")
    public suspend fun languageCode(`value`: Output<String>) {
        this.languageCode = value
    }

    /**
     * @param value The document classification mode.
     * One of `MULTI_CLASS` or `MULTI_LABEL`.
     * `MULTI_CLASS` is also known as "Single Label" in the AWS Console.
     */
    @JvmName("kwriuwebskiohlre")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value KMS Key used to encrypt trained Document Classifiers.
     * Can be a KMS Key ID or a KMS Key ARN.
     */
    @JvmName("xyrakyapqxyskkvk")
    public suspend fun modelKmsKeyId(`value`: Output<String>) {
        this.modelKmsKeyId = value
    }

    /**
     * @param value Name for the Document Classifier.
     * Has a maximum length of 63 characters.
     * Can contain upper- and lower-case letters, numbers, and hypen (`-`).
     * The following arguments are optional:
     */
    @JvmName("isxyoklpcfukipiv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration for the output results of training.
     * See the `output_data_config` Configuration Block section below.
     */
    @JvmName("lqqiybnnifeinsee")
    public suspend fun outputDataConfig(`value`: Output<DocumentClassifierOutputDataConfigArgs>) {
        this.outputDataConfig = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` Configuration Block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ctuipwybahyxyvtx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name for the version of the Document Classifier.
     * Each version must have a unique name within the Document Classifier.
     * If omitted, the provider will assign a random, unique version name.
     * If explicitly set to `""`, no version name will be set.
     * Has a maximum length of 63 characters.
     * Can contain upper- and lower-case letters, numbers, and hypen (`-`).
     * Conflicts with `version_name_prefix`.
     */
    @JvmName("vpcyfgpiqlfshbel")
    public suspend fun versionName(`value`: Output<String>) {
        this.versionName = value
    }

    /**
     * @param value Creates a unique version name beginning with the specified prefix.
     * Has a maximum length of 37 characters.
     * Can contain upper- and lower-case letters, numbers, and hypen (`-`).
     * Conflicts with `version_name`.
     */
    @JvmName("vjcpphjhtmtxuxbn")
    public suspend fun versionNamePrefix(`value`: Output<String>) {
        this.versionNamePrefix = value
    }

    /**
     * @param value KMS Key used to encrypt storage volumes during job processing.
     * Can be a KMS Key ID or a KMS Key ARN.
     */
    @JvmName("pyxxlsdurdihbcuu")
    public suspend fun volumeKmsKeyId(`value`: Output<String>) {
        this.volumeKmsKeyId = value
    }

    /**
     * @param value Configuration parameters for VPC to contain Document Classifier resources.
     * See the `vpc_config` Configuration Block section below.
     */
    @JvmName("ameblajjecajpiqg")
    public suspend fun vpcConfig(`value`: Output<DocumentClassifierVpcConfigArgs>) {
        this.vpcConfig = value
    }

    /**
     * @param value The ARN for an IAM Role which allows Comprehend to read the training and testing data.
     */
    @JvmName("ehdfvohxflgcwesu")
    public suspend fun dataAccessRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataAccessRoleArn = mapped
    }

    /**
     * @param value Configuration for the training and testing data.
     * See the `input_data_config` Configuration Block section below.
     */
    @JvmName("vginulnswlufuhbx")
    public suspend fun inputDataConfig(`value`: DocumentClassifierInputDataConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputDataConfig = mapped
    }

    /**
     * @param argument Configuration for the training and testing data.
     * See the `input_data_config` Configuration Block section below.
     */
    @JvmName("ysooqrqplppsaaev")
    public suspend fun inputDataConfig(argument: suspend DocumentClassifierInputDataConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DocumentClassifierInputDataConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.inputDataConfig = mapped
    }

    /**
     * @param value Two-letter language code for the language.
     * One of `en`, `es`, `fr`, `it`, `de`, or `pt`.
     */
    @JvmName("bjqotobxyhorwkxu")
    public suspend fun languageCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.languageCode = mapped
    }

    /**
     * @param value The document classification mode.
     * One of `MULTI_CLASS` or `MULTI_LABEL`.
     * `MULTI_CLASS` is also known as "Single Label" in the AWS Console.
     */
    @JvmName("ussgomxhxvxpttpr")
    public suspend fun mode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value KMS Key used to encrypt trained Document Classifiers.
     * Can be a KMS Key ID or a KMS Key ARN.
     */
    @JvmName("euvyybwmhgohneyn")
    public suspend fun modelKmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelKmsKeyId = mapped
    }

    /**
     * @param value Name for the Document Classifier.
     * Has a maximum length of 63 characters.
     * Can contain upper- and lower-case letters, numbers, and hypen (`-`).
     * The following arguments are optional:
     */
    @JvmName("incfentoutmaenqg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration for the output results of training.
     * See the `output_data_config` Configuration Block section below.
     */
    @JvmName("ydivlldukllbulyf")
    public suspend fun outputDataConfig(`value`: DocumentClassifierOutputDataConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputDataConfig = mapped
    }

    /**
     * @param argument Configuration for the output results of training.
     * See the `output_data_config` Configuration Block section below.
     */
    @JvmName("omgkhynybjaxwpao")
    public suspend fun outputDataConfig(argument: suspend DocumentClassifierOutputDataConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DocumentClassifierOutputDataConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.outputDataConfig = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` Configuration Block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wpjmbyaihipatnaq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` Configuration Block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dhldckbcjricokuh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Name for the version of the Document Classifier.
     * Each version must have a unique name within the Document Classifier.
     * If omitted, the provider will assign a random, unique version name.
     * If explicitly set to `""`, no version name will be set.
     * Has a maximum length of 63 characters.
     * Can contain upper- and lower-case letters, numbers, and hypen (`-`).
     * Conflicts with `version_name_prefix`.
     */
    @JvmName("ruesqlsjohfixttb")
    public suspend fun versionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionName = mapped
    }

    /**
     * @param value Creates a unique version name beginning with the specified prefix.
     * Has a maximum length of 37 characters.
     * Can contain upper- and lower-case letters, numbers, and hypen (`-`).
     * Conflicts with `version_name`.
     */
    @JvmName("kahpifbdkmjrnnel")
    public suspend fun versionNamePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionNamePrefix = mapped
    }

    /**
     * @param value KMS Key used to encrypt storage volumes during job processing.
     * Can be a KMS Key ID or a KMS Key ARN.
     */
    @JvmName("mmskynievlndjxwr")
    public suspend fun volumeKmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeKmsKeyId = mapped
    }

    /**
     * @param value Configuration parameters for VPC to contain Document Classifier resources.
     * See the `vpc_config` Configuration Block section below.
     */
    @JvmName("mnhexsgtiuiqbewh")
    public suspend fun vpcConfig(`value`: DocumentClassifierVpcConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfig = mapped
    }

    /**
     * @param argument Configuration parameters for VPC to contain Document Classifier resources.
     * See the `vpc_config` Configuration Block section below.
     */
    @JvmName("tvonotcktpqoktpc")
    public suspend fun vpcConfig(argument: suspend DocumentClassifierVpcConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DocumentClassifierVpcConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpcConfig = mapped
    }

    internal fun build(): DocumentClassifierArgs = DocumentClassifierArgs(
        dataAccessRoleArn = dataAccessRoleArn,
        inputDataConfig = inputDataConfig,
        languageCode = languageCode,
        mode = mode,
        modelKmsKeyId = modelKmsKeyId,
        name = name,
        outputDataConfig = outputDataConfig,
        tags = tags,
        versionName = versionName,
        versionNamePrefix = versionNamePrefix,
        volumeKmsKeyId = volumeKmsKeyId,
        vpcConfig = vpcConfig,
    )
}
