@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.comprehend.kotlin

import com.pulumi.aws.comprehend.EntityRecognizerArgs.builder
import com.pulumi.aws.comprehend.kotlin.inputs.EntityRecognizerInputDataConfigArgs
import com.pulumi.aws.comprehend.kotlin.inputs.EntityRecognizerInputDataConfigArgsBuilder
import com.pulumi.aws.comprehend.kotlin.inputs.EntityRecognizerVpcConfigArgs
import com.pulumi.aws.comprehend.kotlin.inputs.EntityRecognizerVpcConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Comprehend Entity Recognizer.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const documents = new aws.s3.BucketObjectv2("documents", {});
 * const entities = new aws.s3.BucketObjectv2("entities", {});
 * const example = new aws.comprehend.EntityRecognizer("example", {
 *     name: "example",
 *     dataAccessRoleArn: exampleAwsIamRole.arn,
 *     languageCode: "en",
 *     inputDataConfig: {
 *         entityTypes: [
 *             {
 *                 type: "ENTITY_1",
 *             },
 *             {
 *                 type: "ENTITY_2",
 *             },
 *         ],
 *         documents: {
 *             s3Uri: pulumi.interpolate`s3://${documentsAwsS3Bucket.bucket}/${documents.id}`,
 *         },
 *         entityList: {
 *             s3Uri: pulumi.interpolate`s3://${entitiesAwsS3Bucket.bucket}/${entities.id}`,
 *         },
 *     },
 * }, {
 *     dependsOn: [exampleAwsIamRolePolicy],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * documents = aws.s3.BucketObjectv2("documents")
 * entities = aws.s3.BucketObjectv2("entities")
 * example = aws.comprehend.EntityRecognizer("example",
 *     name="example",
 *     data_access_role_arn=example_aws_iam_role["arn"],
 *     language_code="en",
 *     input_data_config={
 *         "entity_types": [
 *             {
 *                 "type": "ENTITY_1",
 *             },
 *             {
 *                 "type": "ENTITY_2",
 *             },
 *         ],
 *         "documents": {
 *             "s3_uri": documents.id.apply(lambda id: f"s3://{documents_aws_s3_bucket['bucket']}/{id}"),
 *         },
 *         "entity_list": {
 *             "s3_uri": entities.id.apply(lambda id: f"s3://{entities_aws_s3_bucket['bucket']}/{id}"),
 *         },
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[example_aws_iam_role_policy]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var documents = new Aws.S3.BucketObjectv2("documents");
 *     var entities = new Aws.S3.BucketObjectv2("entities");
 *     var example = new Aws.Comprehend.EntityRecognizer("example", new()
 *     {
 *         Name = "example",
 *         DataAccessRoleArn = exampleAwsIamRole.Arn,
 *         LanguageCode = "en",
 *         InputDataConfig = new Aws.Comprehend.Inputs.EntityRecognizerInputDataConfigArgs
 *         {
 *             EntityTypes = new[]
 *             {
 *                 new Aws.Comprehend.Inputs.EntityRecognizerInputDataConfigEntityTypeArgs
 *                 {
 *                     Type = "ENTITY_1",
 *                 },
 *                 new Aws.Comprehend.Inputs.EntityRecognizerInputDataConfigEntityTypeArgs
 *                 {
 *                     Type = "ENTITY_2",
 *                 },
 *             },
 *             Documents = new Aws.Comprehend.Inputs.EntityRecognizerInputDataConfigDocumentsArgs
 *             {
 *                 S3Uri = documents.Id.Apply(id => $"s3://{documentsAwsS3Bucket.Bucket}/{id}"),
 *             },
 *             EntityList = new Aws.Comprehend.Inputs.EntityRecognizerInputDataConfigEntityListArgs
 *             {
 *                 S3Uri = entities.Id.Apply(id => $"s3://{entitiesAwsS3Bucket.Bucket}/{id}"),
 *             },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             exampleAwsIamRolePolicy,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/comprehend"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		documents, err := s3.NewBucketObjectv2(ctx, "documents", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		entities, err := s3.NewBucketObjectv2(ctx, "entities", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = comprehend.NewEntityRecognizer(ctx, "example", &comprehend.EntityRecognizerArgs{
 * 			Name:              pulumi.String("example"),
 * 			DataAccessRoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * 			LanguageCode:      pulumi.String("en"),
 * 			InputDataConfig: &comprehend.EntityRecognizerInputDataConfigArgs{
 * 				EntityTypes: comprehend.EntityRecognizerInputDataConfigEntityTypeArray{
 * 					&comprehend.EntityRecognizerInputDataConfigEntityTypeArgs{
 * 						Type: pulumi.String("ENTITY_1"),
 * 					},
 * 					&comprehend.EntityRecognizerInputDataConfigEntityTypeArgs{
 * 						Type: pulumi.String("ENTITY_2"),
 * 					},
 * 				},
 * 				Documents: &comprehend.EntityRecognizerInputDataConfigDocumentsArgs{
 * 					S3Uri: documents.ID().ApplyT(func(id string) (string, error) {
 * 						return fmt.Sprintf("s3://%v/%v", documentsAwsS3Bucket.Bucket, id), nil
 * 					}).(pulumi.StringOutput),
 * 				},
 * 				EntityList: &comprehend.EntityRecognizerInputDataConfigEntityListArgs{
 * 					S3Uri: entities.ID().ApplyT(func(id string) (string, error) {
 * 						return fmt.Sprintf("s3://%v/%v", entitiesAwsS3Bucket.Bucket, id), nil
 * 					}).(pulumi.StringOutput),
 * 				},
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			exampleAwsIamRolePolicy,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.comprehend.EntityRecognizer;
 * import com.pulumi.aws.comprehend.EntityRecognizerArgs;
 * import com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigArgs;
 * import com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigDocumentsArgs;
 * import com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigEntityListArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var documents = new BucketObjectv2("documents");
 *         var entities = new BucketObjectv2("entities");
 *         var example = new EntityRecognizer("example", EntityRecognizerArgs.builder()
 *             .name("example")
 *             .dataAccessRoleArn(exampleAwsIamRole.arn())
 *             .languageCode("en")
 *             .inputDataConfig(EntityRecognizerInputDataConfigArgs.builder()
 *                 .entityTypes(
 *                     EntityRecognizerInputDataConfigEntityTypeArgs.builder()
 *                         .type("ENTITY_1")
 *                         .build(),
 *                     EntityRecognizerInputDataConfigEntityTypeArgs.builder()
 *                         .type("ENTITY_2")
 *                         .build())
 *                 .documents(EntityRecognizerInputDataConfigDocumentsArgs.builder()
 *                     .s3Uri(documents.id().applyValue(id -> String.format("s3://%s/%s", documentsAwsS3Bucket.bucket(),id)))
 *                     .build())
 *                 .entityList(EntityRecognizerInputDataConfigEntityListArgs.builder()
 *                     .s3Uri(entities.id().applyValue(id -> String.format("s3://%s/%s", entitiesAwsS3Bucket.bucket(),id)))
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAwsIamRolePolicy)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:comprehend:EntityRecognizer
 *     properties:
 *       name: example
 *       dataAccessRoleArn: ${exampleAwsIamRole.arn}
 *       languageCode: en
 *       inputDataConfig:
 *         entityTypes:
 *           - type: ENTITY_1
 *           - type: ENTITY_2
 *         documents:
 *           s3Uri: s3://${documentsAwsS3Bucket.bucket}/${documents.id}
 *         entityList:
 *           s3Uri: s3://${entitiesAwsS3Bucket.bucket}/${entities.id}
 *     options:
 *       dependson:
 *         - ${exampleAwsIamRolePolicy}
 *   documents:
 *     type: aws:s3:BucketObjectv2
 *   entities:
 *     type: aws:s3:BucketObjectv2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Comprehend Entity Recognizer using the ARN. For example:
 * ```sh
 * $ pulumi import aws:comprehend/entityRecognizer:EntityRecognizer example arn:aws:comprehend:us-west-2:123456789012:entity-recognizer/example
 * ```
 * @property dataAccessRoleArn The ARN for an IAM Role which allows Comprehend to read the training and testing data.
 * @property inputDataConfig Configuration for the training and testing data.
 * See the `input_data_config` Configuration Block section below.
 * @property languageCode Two-letter language code for the language.
 * One of `en`, `es`, `fr`, `it`, `de`, or `pt`.
 * @property modelKmsKeyId The ID or ARN of a KMS Key used to encrypt trained Entity Recognizers.
 * @property name Name for the Entity Recognizer.
 * Has a maximum length of 63 characters.
 * Can contain upper- and lower-case letters, numbers, and hypen (`-`).
 * The following arguments are optional:
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` Configuration Block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property versionName Name for the version of the Entity Recognizer.
 * Each version must have a unique name within the Entity Recognizer.
 * If omitted, the provider will assign a random, unique version name.
 * If explicitly set to `""`, no version name will be set.
 * Has a maximum length of 63 characters.
 * Can contain upper- and lower-case letters, numbers, and hypen (`-`).
 * Conflicts with `version_name_prefix`.
 * @property versionNamePrefix Creates a unique version name beginning with the specified prefix.
 * Has a maximum length of 37 characters.
 * Can contain upper- and lower-case letters, numbers, and hypen (`-`).
 * Conflicts with `version_name`.
 * @property volumeKmsKeyId ID or ARN of a KMS Key used to encrypt storage volumes during job processing.
 * @property vpcConfig Configuration parameters for VPC to contain Entity Recognizer resources.
 * See the `vpc_config` Configuration Block section below.
 */
public data class EntityRecognizerArgs(
    public val dataAccessRoleArn: Output<String>? = null,
    public val inputDataConfig: Output<EntityRecognizerInputDataConfigArgs>? = null,
    public val languageCode: Output<String>? = null,
    public val modelKmsKeyId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val versionName: Output<String>? = null,
    public val versionNamePrefix: Output<String>? = null,
    public val volumeKmsKeyId: Output<String>? = null,
    public val vpcConfig: Output<EntityRecognizerVpcConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.comprehend.EntityRecognizerArgs> {
    override fun toJava(): com.pulumi.aws.comprehend.EntityRecognizerArgs =
        com.pulumi.aws.comprehend.EntityRecognizerArgs.builder()
            .dataAccessRoleArn(dataAccessRoleArn?.applyValue({ args0 -> args0 }))
            .inputDataConfig(inputDataConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .languageCode(languageCode?.applyValue({ args0 -> args0 }))
            .modelKmsKeyId(modelKmsKeyId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .versionName(versionName?.applyValue({ args0 -> args0 }))
            .versionNamePrefix(versionNamePrefix?.applyValue({ args0 -> args0 }))
            .volumeKmsKeyId(volumeKmsKeyId?.applyValue({ args0 -> args0 }))
            .vpcConfig(vpcConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [EntityRecognizerArgs].
 */
@PulumiTagMarker
public class EntityRecognizerArgsBuilder internal constructor() {
    private var dataAccessRoleArn: Output<String>? = null

    private var inputDataConfig: Output<EntityRecognizerInputDataConfigArgs>? = null

    private var languageCode: Output<String>? = null

    private var modelKmsKeyId: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var versionName: Output<String>? = null

    private var versionNamePrefix: Output<String>? = null

    private var volumeKmsKeyId: Output<String>? = null

    private var vpcConfig: Output<EntityRecognizerVpcConfigArgs>? = null

    /**
     * @param value The ARN for an IAM Role which allows Comprehend to read the training and testing data.
     */
    @JvmName("wtepcivrbshfwvpf")
    public suspend fun dataAccessRoleArn(`value`: Output<String>) {
        this.dataAccessRoleArn = value
    }

    /**
     * @param value Configuration for the training and testing data.
     * See the `input_data_config` Configuration Block section below.
     */
    @JvmName("qyudbpymndcssjtj")
    public suspend fun inputDataConfig(`value`: Output<EntityRecognizerInputDataConfigArgs>) {
        this.inputDataConfig = value
    }

    /**
     * @param value Two-letter language code for the language.
     * One of `en`, `es`, `fr`, `it`, `de`, or `pt`.
     */
    @JvmName("hirctqtspwljtuov")
    public suspend fun languageCode(`value`: Output<String>) {
        this.languageCode = value
    }

    /**
     * @param value The ID or ARN of a KMS Key used to encrypt trained Entity Recognizers.
     */
    @JvmName("lssrgtnytrdpdfnj")
    public suspend fun modelKmsKeyId(`value`: Output<String>) {
        this.modelKmsKeyId = value
    }

    /**
     * @param value Name for the Entity Recognizer.
     * Has a maximum length of 63 characters.
     * Can contain upper- and lower-case letters, numbers, and hypen (`-`).
     * The following arguments are optional:
     */
    @JvmName("wfaojxdaeiivkuri")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` Configuration Block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("njtccsmpyothyfsf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name for the version of the Entity Recognizer.
     * Each version must have a unique name within the Entity Recognizer.
     * If omitted, the provider will assign a random, unique version name.
     * If explicitly set to `""`, no version name will be set.
     * Has a maximum length of 63 characters.
     * Can contain upper- and lower-case letters, numbers, and hypen (`-`).
     * Conflicts with `version_name_prefix`.
     */
    @JvmName("mmvtfuitplowloty")
    public suspend fun versionName(`value`: Output<String>) {
        this.versionName = value
    }

    /**
     * @param value Creates a unique version name beginning with the specified prefix.
     * Has a maximum length of 37 characters.
     * Can contain upper- and lower-case letters, numbers, and hypen (`-`).
     * Conflicts with `version_name`.
     */
    @JvmName("wssfbsvbcmvoggks")
    public suspend fun versionNamePrefix(`value`: Output<String>) {
        this.versionNamePrefix = value
    }

    /**
     * @param value ID or ARN of a KMS Key used to encrypt storage volumes during job processing.
     */
    @JvmName("pkjmtftrtputgopv")
    public suspend fun volumeKmsKeyId(`value`: Output<String>) {
        this.volumeKmsKeyId = value
    }

    /**
     * @param value Configuration parameters for VPC to contain Entity Recognizer resources.
     * See the `vpc_config` Configuration Block section below.
     */
    @JvmName("qxkdnujysjiwmani")
    public suspend fun vpcConfig(`value`: Output<EntityRecognizerVpcConfigArgs>) {
        this.vpcConfig = value
    }

    /**
     * @param value The ARN for an IAM Role which allows Comprehend to read the training and testing data.
     */
    @JvmName("awsdmcjekmwhdixt")
    public suspend fun dataAccessRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataAccessRoleArn = mapped
    }

    /**
     * @param value Configuration for the training and testing data.
     * See the `input_data_config` Configuration Block section below.
     */
    @JvmName("dugryxvapvvyethe")
    public suspend fun inputDataConfig(`value`: EntityRecognizerInputDataConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputDataConfig = mapped
    }

    /**
     * @param argument Configuration for the training and testing data.
     * See the `input_data_config` Configuration Block section below.
     */
    @JvmName("nypwovdklgleuccs")
    public suspend fun inputDataConfig(argument: suspend EntityRecognizerInputDataConfigArgsBuilder.() -> Unit) {
        val toBeMapped = EntityRecognizerInputDataConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.inputDataConfig = mapped
    }

    /**
     * @param value Two-letter language code for the language.
     * One of `en`, `es`, `fr`, `it`, `de`, or `pt`.
     */
    @JvmName("xvtcgfxvbxtuotoe")
    public suspend fun languageCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.languageCode = mapped
    }

    /**
     * @param value The ID or ARN of a KMS Key used to encrypt trained Entity Recognizers.
     */
    @JvmName("nwplxofaictrvktd")
    public suspend fun modelKmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelKmsKeyId = mapped
    }

    /**
     * @param value Name for the Entity Recognizer.
     * Has a maximum length of 63 characters.
     * Can contain upper- and lower-case letters, numbers, and hypen (`-`).
     * The following arguments are optional:
     */
    @JvmName("ufcqxqytffthqyth")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` Configuration Block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vrvjtlectabkpjkj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` Configuration Block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ivfwbwnfctqtefjr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Name for the version of the Entity Recognizer.
     * Each version must have a unique name within the Entity Recognizer.
     * If omitted, the provider will assign a random, unique version name.
     * If explicitly set to `""`, no version name will be set.
     * Has a maximum length of 63 characters.
     * Can contain upper- and lower-case letters, numbers, and hypen (`-`).
     * Conflicts with `version_name_prefix`.
     */
    @JvmName("oqxyobnrqqxruvui")
    public suspend fun versionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionName = mapped
    }

    /**
     * @param value Creates a unique version name beginning with the specified prefix.
     * Has a maximum length of 37 characters.
     * Can contain upper- and lower-case letters, numbers, and hypen (`-`).
     * Conflicts with `version_name`.
     */
    @JvmName("dxmjwhiosxymgrko")
    public suspend fun versionNamePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionNamePrefix = mapped
    }

    /**
     * @param value ID or ARN of a KMS Key used to encrypt storage volumes during job processing.
     */
    @JvmName("ywuxqvbduiksoecg")
    public suspend fun volumeKmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeKmsKeyId = mapped
    }

    /**
     * @param value Configuration parameters for VPC to contain Entity Recognizer resources.
     * See the `vpc_config` Configuration Block section below.
     */
    @JvmName("pabhqcfveswwpuyn")
    public suspend fun vpcConfig(`value`: EntityRecognizerVpcConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfig = mapped
    }

    /**
     * @param argument Configuration parameters for VPC to contain Entity Recognizer resources.
     * See the `vpc_config` Configuration Block section below.
     */
    @JvmName("kbevfhdvqcplcttp")
    public suspend fun vpcConfig(argument: suspend EntityRecognizerVpcConfigArgsBuilder.() -> Unit) {
        val toBeMapped = EntityRecognizerVpcConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpcConfig = mapped
    }

    internal fun build(): EntityRecognizerArgs = EntityRecognizerArgs(
        dataAccessRoleArn = dataAccessRoleArn,
        inputDataConfig = inputDataConfig,
        languageCode = languageCode,
        modelKmsKeyId = modelKmsKeyId,
        name = name,
        tags = tags,
        versionName = versionName,
        versionNamePrefix = versionNamePrefix,
        volumeKmsKeyId = volumeKmsKeyId,
        vpcConfig = vpcConfig,
    )
}
