@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.comprehend.kotlin.inputs

import com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property annotations Specifies location of the document annotation data.
 * See the `annotations` Configuration Block section below.
 * One of `annotations` or `entity_list` is required.
 * @property augmentedManifests List of training datasets produced by Amazon SageMaker Ground Truth.
 * Used if `data_format` is `AUGMENTED_MANIFEST`.
 * See the `augmented_manifests` Configuration Block section below.
 * @property dataFormat The format for the training data.
 * One of `COMPREHEND_CSV` or `AUGMENTED_MANIFEST`.
 * @property documents Specifies a collection of training documents.
 * Used if `data_format` is `COMPREHEND_CSV`.
 * See the `documents` Configuration Block section below.
 * @property entityList Specifies location of the entity list data.
 * See the `entity_list` Configuration Block section below.
 * One of `entity_list` or `annotations` is required.
 * @property entityTypes Set of entity types to be recognized.
 * Has a maximum of 25 items.
 * See the `entity_types` Configuration Block section below.
 */
public data class EntityRecognizerInputDataConfigArgs(
    public val annotations: Output<EntityRecognizerInputDataConfigAnnotationsArgs>? = null,
    public val augmentedManifests: Output<List<EntityRecognizerInputDataConfigAugmentedManifestArgs>>? =
        null,
    public val dataFormat: Output<String>? = null,
    public val documents: Output<EntityRecognizerInputDataConfigDocumentsArgs>? = null,
    public val entityList: Output<EntityRecognizerInputDataConfigEntityListArgs>? = null,
    public val entityTypes: Output<List<EntityRecognizerInputDataConfigEntityTypeArgs>>,
) : ConvertibleToJava<com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigArgs> {
    override fun toJava(): com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigArgs =
        com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .augmentedManifests(
                augmentedManifests?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .dataFormat(dataFormat?.applyValue({ args0 -> args0 }))
            .documents(documents?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .entityList(entityList?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .entityTypes(
                entityTypes.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [EntityRecognizerInputDataConfigArgs].
 */
@PulumiTagMarker
public class EntityRecognizerInputDataConfigArgsBuilder internal constructor() {
    private var annotations: Output<EntityRecognizerInputDataConfigAnnotationsArgs>? = null

    private var augmentedManifests:
        Output<List<EntityRecognizerInputDataConfigAugmentedManifestArgs>>? = null

    private var dataFormat: Output<String>? = null

    private var documents: Output<EntityRecognizerInputDataConfigDocumentsArgs>? = null

    private var entityList: Output<EntityRecognizerInputDataConfigEntityListArgs>? = null

    private var entityTypes: Output<List<EntityRecognizerInputDataConfigEntityTypeArgs>>? = null

    /**
     * @param value Specifies location of the document annotation data.
     * See the `annotations` Configuration Block section below.
     * One of `annotations` or `entity_list` is required.
     */
    @JvmName("voriamerwcsfbxko")
    public suspend fun annotations(`value`: Output<EntityRecognizerInputDataConfigAnnotationsArgs>) {
        this.annotations = value
    }

    /**
     * @param value List of training datasets produced by Amazon SageMaker Ground Truth.
     * Used if `data_format` is `AUGMENTED_MANIFEST`.
     * See the `augmented_manifests` Configuration Block section below.
     */
    @JvmName("etcnwiuryeigwpge")
    public suspend fun augmentedManifests(`value`: Output<List<EntityRecognizerInputDataConfigAugmentedManifestArgs>>) {
        this.augmentedManifests = value
    }

    @JvmName("xaojexcyftjvoahb")
    public suspend fun augmentedManifests(vararg values: Output<EntityRecognizerInputDataConfigAugmentedManifestArgs>) {
        this.augmentedManifests = Output.all(values.asList())
    }

    /**
     * @param values List of training datasets produced by Amazon SageMaker Ground Truth.
     * Used if `data_format` is `AUGMENTED_MANIFEST`.
     * See the `augmented_manifests` Configuration Block section below.
     */
    @JvmName("dugxfaprforilcll")
    public suspend fun augmentedManifests(values: List<Output<EntityRecognizerInputDataConfigAugmentedManifestArgs>>) {
        this.augmentedManifests = Output.all(values)
    }

    /**
     * @param value The format for the training data.
     * One of `COMPREHEND_CSV` or `AUGMENTED_MANIFEST`.
     */
    @JvmName("tyqbqsgohaiqrpap")
    public suspend fun dataFormat(`value`: Output<String>) {
        this.dataFormat = value
    }

    /**
     * @param value Specifies a collection of training documents.
     * Used if `data_format` is `COMPREHEND_CSV`.
     * See the `documents` Configuration Block section below.
     */
    @JvmName("eqghslpbsphjbiwy")
    public suspend fun documents(`value`: Output<EntityRecognizerInputDataConfigDocumentsArgs>) {
        this.documents = value
    }

    /**
     * @param value Specifies location of the entity list data.
     * See the `entity_list` Configuration Block section below.
     * One of `entity_list` or `annotations` is required.
     */
    @JvmName("boqqpnqblsyauhxy")
    public suspend fun entityList(`value`: Output<EntityRecognizerInputDataConfigEntityListArgs>) {
        this.entityList = value
    }

    /**
     * @param value Set of entity types to be recognized.
     * Has a maximum of 25 items.
     * See the `entity_types` Configuration Block section below.
     */
    @JvmName("ygtoxuuirelxwwct")
    public suspend fun entityTypes(`value`: Output<List<EntityRecognizerInputDataConfigEntityTypeArgs>>) {
        this.entityTypes = value
    }

    @JvmName("sagyynemlnlsarth")
    public suspend fun entityTypes(vararg values: Output<EntityRecognizerInputDataConfigEntityTypeArgs>) {
        this.entityTypes = Output.all(values.asList())
    }

    /**
     * @param values Set of entity types to be recognized.
     * Has a maximum of 25 items.
     * See the `entity_types` Configuration Block section below.
     */
    @JvmName("yoflakdcavdxebai")
    public suspend fun entityTypes(values: List<Output<EntityRecognizerInputDataConfigEntityTypeArgs>>) {
        this.entityTypes = Output.all(values)
    }

    /**
     * @param value Specifies location of the document annotation data.
     * See the `annotations` Configuration Block section below.
     * One of `annotations` or `entity_list` is required.
     */
    @JvmName("bqtqhkbgocenfjho")
    public suspend fun annotations(`value`: EntityRecognizerInputDataConfigAnnotationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param argument Specifies location of the document annotation data.
     * See the `annotations` Configuration Block section below.
     * One of `annotations` or `entity_list` is required.
     */
    @JvmName("xbwcxrarrfbcbelc")
    public suspend fun annotations(argument: suspend EntityRecognizerInputDataConfigAnnotationsArgsBuilder.() -> Unit) {
        val toBeMapped = EntityRecognizerInputDataConfigAnnotationsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.annotations = mapped
    }

    /**
     * @param value List of training datasets produced by Amazon SageMaker Ground Truth.
     * Used if `data_format` is `AUGMENTED_MANIFEST`.
     * See the `augmented_manifests` Configuration Block section below.
     */
    @JvmName("ijmqppbgoqvspnxo")
    public suspend fun augmentedManifests(`value`: List<EntityRecognizerInputDataConfigAugmentedManifestArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.augmentedManifests = mapped
    }

    /**
     * @param argument List of training datasets produced by Amazon SageMaker Ground Truth.
     * Used if `data_format` is `AUGMENTED_MANIFEST`.
     * See the `augmented_manifests` Configuration Block section below.
     */
    @JvmName("cfsgdnxknvpxuhrc")
    public suspend fun augmentedManifests(argument: List<suspend EntityRecognizerInputDataConfigAugmentedManifestArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EntityRecognizerInputDataConfigAugmentedManifestArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.augmentedManifests = mapped
    }

    /**
     * @param argument List of training datasets produced by Amazon SageMaker Ground Truth.
     * Used if `data_format` is `AUGMENTED_MANIFEST`.
     * See the `augmented_manifests` Configuration Block section below.
     */
    @JvmName("gtbasihrglknfcev")
    public suspend fun augmentedManifests(vararg argument: suspend EntityRecognizerInputDataConfigAugmentedManifestArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EntityRecognizerInputDataConfigAugmentedManifestArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.augmentedManifests = mapped
    }

    /**
     * @param argument List of training datasets produced by Amazon SageMaker Ground Truth.
     * Used if `data_format` is `AUGMENTED_MANIFEST`.
     * See the `augmented_manifests` Configuration Block section below.
     */
    @JvmName("swfrqkodgxeovocd")
    public suspend fun augmentedManifests(argument: suspend EntityRecognizerInputDataConfigAugmentedManifestArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                EntityRecognizerInputDataConfigAugmentedManifestArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.augmentedManifests = mapped
    }

    /**
     * @param values List of training datasets produced by Amazon SageMaker Ground Truth.
     * Used if `data_format` is `AUGMENTED_MANIFEST`.
     * See the `augmented_manifests` Configuration Block section below.
     */
    @JvmName("mcfisrbksemaxqlq")
    public suspend fun augmentedManifests(vararg values: EntityRecognizerInputDataConfigAugmentedManifestArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.augmentedManifests = mapped
    }

    /**
     * @param value The format for the training data.
     * One of `COMPREHEND_CSV` or `AUGMENTED_MANIFEST`.
     */
    @JvmName("kavhjaoujyytrepy")
    public suspend fun dataFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value Specifies a collection of training documents.
     * Used if `data_format` is `COMPREHEND_CSV`.
     * See the `documents` Configuration Block section below.
     */
    @JvmName("pgcrhvrxouffwivb")
    public suspend fun documents(`value`: EntityRecognizerInputDataConfigDocumentsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documents = mapped
    }

    /**
     * @param argument Specifies a collection of training documents.
     * Used if `data_format` is `COMPREHEND_CSV`.
     * See the `documents` Configuration Block section below.
     */
    @JvmName("bplkkxoqsewfyyfx")
    public suspend fun documents(argument: suspend EntityRecognizerInputDataConfigDocumentsArgsBuilder.() -> Unit) {
        val toBeMapped = EntityRecognizerInputDataConfigDocumentsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.documents = mapped
    }

    /**
     * @param value Specifies location of the entity list data.
     * See the `entity_list` Configuration Block section below.
     * One of `entity_list` or `annotations` is required.
     */
    @JvmName("skgdqdyifqinbyji")
    public suspend fun entityList(`value`: EntityRecognizerInputDataConfigEntityListArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entityList = mapped
    }

    /**
     * @param argument Specifies location of the entity list data.
     * See the `entity_list` Configuration Block section below.
     * One of `entity_list` or `annotations` is required.
     */
    @JvmName("oykoibpemupoyyon")
    public suspend fun entityList(argument: suspend EntityRecognizerInputDataConfigEntityListArgsBuilder.() -> Unit) {
        val toBeMapped = EntityRecognizerInputDataConfigEntityListArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.entityList = mapped
    }

    /**
     * @param value Set of entity types to be recognized.
     * Has a maximum of 25 items.
     * See the `entity_types` Configuration Block section below.
     */
    @JvmName("jqkrccuffwdropcg")
    public suspend fun entityTypes(`value`: List<EntityRecognizerInputDataConfigEntityTypeArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entityTypes = mapped
    }

    /**
     * @param argument Set of entity types to be recognized.
     * Has a maximum of 25 items.
     * See the `entity_types` Configuration Block section below.
     */
    @JvmName("lvadvitpasreudfy")
    public suspend fun entityTypes(argument: List<suspend EntityRecognizerInputDataConfigEntityTypeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EntityRecognizerInputDataConfigEntityTypeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.entityTypes = mapped
    }

    /**
     * @param argument Set of entity types to be recognized.
     * Has a maximum of 25 items.
     * See the `entity_types` Configuration Block section below.
     */
    @JvmName("toehserapkniemac")
    public suspend fun entityTypes(vararg argument: suspend EntityRecognizerInputDataConfigEntityTypeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EntityRecognizerInputDataConfigEntityTypeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.entityTypes = mapped
    }

    /**
     * @param argument Set of entity types to be recognized.
     * Has a maximum of 25 items.
     * See the `entity_types` Configuration Block section below.
     */
    @JvmName("jjarrbnlmpkuiils")
    public suspend fun entityTypes(argument: suspend EntityRecognizerInputDataConfigEntityTypeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EntityRecognizerInputDataConfigEntityTypeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.entityTypes = mapped
    }

    /**
     * @param values Set of entity types to be recognized.
     * Has a maximum of 25 items.
     * See the `entity_types` Configuration Block section below.
     */
    @JvmName("ysnsuwaucsbcmhvm")
    public suspend fun entityTypes(vararg values: EntityRecognizerInputDataConfigEntityTypeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entityTypes = mapped
    }

    internal fun build(): EntityRecognizerInputDataConfigArgs = EntityRecognizerInputDataConfigArgs(
        annotations = annotations,
        augmentedManifests = augmentedManifests,
        dataFormat = dataFormat,
        documents = documents,
        entityList = entityList,
        entityTypes = entityTypes ?: throw PulumiNullFieldException("entityTypes"),
    )
}
