@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.comprehend.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property augmentedManifests List of training datasets produced by Amazon SageMaker Ground Truth.
 * Used if `data_format` is `AUGMENTED_MANIFEST`.
 * See the `augmented_manifests` Configuration Block section below.
 * @property dataFormat The format for the training data.
 * One of `COMPREHEND_CSV` or `AUGMENTED_MANIFEST`.
 * @property labelDelimiter Delimiter between labels when training a multi-label classifier.
 * Valid values are `|`, `~`, `!`, `@`, `#`, `$`, `%`, `^`, `*`, `-`, `_`, `+`, `=`, `\`, `:`, `;`, `>`, `?`, `/`, `<space>`, and `<tab>`.
 * Default is `|`.
 * @property s3Uri Location of training documents.
 * Used if `data_format` is `COMPREHEND_CSV`.
 * @property testS3Uri
 */
public data class DocumentClassifierInputDataConfig(
    public val augmentedManifests: List<DocumentClassifierInputDataConfigAugmentedManifest>? = null,
    public val dataFormat: String? = null,
    public val labelDelimiter: String? = null,
    public val s3Uri: String? = null,
    public val testS3Uri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.comprehend.outputs.DocumentClassifierInputDataConfig): DocumentClassifierInputDataConfig = DocumentClassifierInputDataConfig(
            augmentedManifests = javaType.augmentedManifests().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.comprehend.kotlin.outputs.DocumentClassifierInputDataConfigAugmentedManifest.Companion.toKotlin(args0)
                })
            }),
            dataFormat = javaType.dataFormat().map({ args0 -> args0 }).orElse(null),
            labelDelimiter = javaType.labelDelimiter().map({ args0 -> args0 }).orElse(null),
            s3Uri = javaType.s3Uri().map({ args0 -> args0 }).orElse(null),
            testS3Uri = javaType.testS3Uri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
