@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.comprehend.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kmsKeyId KMS Key used to encrypt the output documents.
 * Can be a KMS Key ID, a KMS Key ARN, a KMS Alias name, or a KMS Alias ARN.
 * @property outputS3Uri Full path for the output documents.
 * @property s3Uri Destination path for the output documents.
 * The full path to the output file will be returned in `output_s3_uri`.
 */
public data class DocumentClassifierOutputDataConfig(
    public val kmsKeyId: String? = null,
    public val outputS3Uri: String? = null,
    public val s3Uri: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.comprehend.outputs.DocumentClassifierOutputDataConfig): DocumentClassifierOutputDataConfig = DocumentClassifierOutputDataConfig(
            kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
            outputS3Uri = javaType.outputS3Uri().map({ args0 -> args0 }).orElse(null),
            s3Uri = javaType.s3Uri(),
        )
    }
}
