@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.comprehend.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property annotationDataS3Uri Location of annotation files.
 * @property attributeNames The JSON attribute that contains the annotations for the training documents.
 * @property documentType Type of augmented manifest.
 * One of `PLAIN_TEXT_DOCUMENT` or `SEMI_STRUCTURED_DOCUMENT`.
 * @property s3Uri Location of augmented manifest file.
 * @property sourceDocumentsS3Uri Location of source PDF files.
 * @property split Purpose of data in augmented manifest.
 * One of `TRAIN` or `TEST`.
 */
public data class EntityRecognizerInputDataConfigAugmentedManifest(
    public val annotationDataS3Uri: String? = null,
    public val attributeNames: List<String>,
    public val documentType: String? = null,
    public val s3Uri: String,
    public val sourceDocumentsS3Uri: String? = null,
    public val split: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.comprehend.outputs.EntityRecognizerInputDataConfigAugmentedManifest): EntityRecognizerInputDataConfigAugmentedManifest =
            EntityRecognizerInputDataConfigAugmentedManifest(
                annotationDataS3Uri = javaType.annotationDataS3Uri().map({ args0 -> args0 }).orElse(null),
                attributeNames = javaType.attributeNames().map({ args0 -> args0 }),
                documentType = javaType.documentType().map({ args0 -> args0 }).orElse(null),
                s3Uri = javaType.s3Uri(),
                sourceDocumentsS3Uri = javaType.sourceDocumentsS3Uri().map({ args0 -> args0 }).orElse(null),
                split = javaType.split().map({ args0 -> args0 }).orElse(null),
            )
    }
}
