@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.ConnectFunctions.getBotAssociationPlain
import com.pulumi.aws.connect.ConnectFunctions.getContactFlowModulePlain
import com.pulumi.aws.connect.ConnectFunctions.getContactFlowPlain
import com.pulumi.aws.connect.ConnectFunctions.getHoursOfOperationPlain
import com.pulumi.aws.connect.ConnectFunctions.getInstancePlain
import com.pulumi.aws.connect.ConnectFunctions.getInstanceStorageConfigPlain
import com.pulumi.aws.connect.ConnectFunctions.getLambdaFunctionAssociationPlain
import com.pulumi.aws.connect.ConnectFunctions.getPromptPlain
import com.pulumi.aws.connect.ConnectFunctions.getQueuePlain
import com.pulumi.aws.connect.ConnectFunctions.getQuickConnectPlain
import com.pulumi.aws.connect.ConnectFunctions.getRoutingProfilePlain
import com.pulumi.aws.connect.ConnectFunctions.getSecurityProfilePlain
import com.pulumi.aws.connect.ConnectFunctions.getUserHierarchyGroupPlain
import com.pulumi.aws.connect.ConnectFunctions.getUserHierarchyStructurePlain
import com.pulumi.aws.connect.ConnectFunctions.getUserPlain
import com.pulumi.aws.connect.ConnectFunctions.getVocabularyPlain
import com.pulumi.aws.connect.kotlin.inputs.GetBotAssociationLexBot
import com.pulumi.aws.connect.kotlin.inputs.GetBotAssociationPlainArgs
import com.pulumi.aws.connect.kotlin.inputs.GetBotAssociationPlainArgsBuilder
import com.pulumi.aws.connect.kotlin.inputs.GetContactFlowModulePlainArgs
import com.pulumi.aws.connect.kotlin.inputs.GetContactFlowModulePlainArgsBuilder
import com.pulumi.aws.connect.kotlin.inputs.GetContactFlowPlainArgs
import com.pulumi.aws.connect.kotlin.inputs.GetContactFlowPlainArgsBuilder
import com.pulumi.aws.connect.kotlin.inputs.GetHoursOfOperationPlainArgs
import com.pulumi.aws.connect.kotlin.inputs.GetHoursOfOperationPlainArgsBuilder
import com.pulumi.aws.connect.kotlin.inputs.GetInstancePlainArgs
import com.pulumi.aws.connect.kotlin.inputs.GetInstancePlainArgsBuilder
import com.pulumi.aws.connect.kotlin.inputs.GetInstanceStorageConfigPlainArgs
import com.pulumi.aws.connect.kotlin.inputs.GetInstanceStorageConfigPlainArgsBuilder
import com.pulumi.aws.connect.kotlin.inputs.GetLambdaFunctionAssociationPlainArgs
import com.pulumi.aws.connect.kotlin.inputs.GetLambdaFunctionAssociationPlainArgsBuilder
import com.pulumi.aws.connect.kotlin.inputs.GetPromptPlainArgs
import com.pulumi.aws.connect.kotlin.inputs.GetPromptPlainArgsBuilder
import com.pulumi.aws.connect.kotlin.inputs.GetQueuePlainArgs
import com.pulumi.aws.connect.kotlin.inputs.GetQueuePlainArgsBuilder
import com.pulumi.aws.connect.kotlin.inputs.GetQuickConnectPlainArgs
import com.pulumi.aws.connect.kotlin.inputs.GetQuickConnectPlainArgsBuilder
import com.pulumi.aws.connect.kotlin.inputs.GetRoutingProfilePlainArgs
import com.pulumi.aws.connect.kotlin.inputs.GetRoutingProfilePlainArgsBuilder
import com.pulumi.aws.connect.kotlin.inputs.GetSecurityProfilePlainArgs
import com.pulumi.aws.connect.kotlin.inputs.GetSecurityProfilePlainArgsBuilder
import com.pulumi.aws.connect.kotlin.inputs.GetUserHierarchyGroupPlainArgs
import com.pulumi.aws.connect.kotlin.inputs.GetUserHierarchyGroupPlainArgsBuilder
import com.pulumi.aws.connect.kotlin.inputs.GetUserHierarchyStructurePlainArgs
import com.pulumi.aws.connect.kotlin.inputs.GetUserHierarchyStructurePlainArgsBuilder
import com.pulumi.aws.connect.kotlin.inputs.GetUserPlainArgs
import com.pulumi.aws.connect.kotlin.inputs.GetUserPlainArgsBuilder
import com.pulumi.aws.connect.kotlin.inputs.GetVocabularyPlainArgs
import com.pulumi.aws.connect.kotlin.inputs.GetVocabularyPlainArgsBuilder
import com.pulumi.aws.connect.kotlin.outputs.GetBotAssociationResult
import com.pulumi.aws.connect.kotlin.outputs.GetContactFlowModuleResult
import com.pulumi.aws.connect.kotlin.outputs.GetContactFlowResult
import com.pulumi.aws.connect.kotlin.outputs.GetHoursOfOperationResult
import com.pulumi.aws.connect.kotlin.outputs.GetInstanceResult
import com.pulumi.aws.connect.kotlin.outputs.GetInstanceStorageConfigResult
import com.pulumi.aws.connect.kotlin.outputs.GetLambdaFunctionAssociationResult
import com.pulumi.aws.connect.kotlin.outputs.GetPromptResult
import com.pulumi.aws.connect.kotlin.outputs.GetQueueResult
import com.pulumi.aws.connect.kotlin.outputs.GetQuickConnectResult
import com.pulumi.aws.connect.kotlin.outputs.GetRoutingProfileResult
import com.pulumi.aws.connect.kotlin.outputs.GetSecurityProfileResult
import com.pulumi.aws.connect.kotlin.outputs.GetUserHierarchyGroupResult
import com.pulumi.aws.connect.kotlin.outputs.GetUserHierarchyStructureResult
import com.pulumi.aws.connect.kotlin.outputs.GetUserResult
import com.pulumi.aws.connect.kotlin.outputs.GetVocabularyResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.connect.kotlin.outputs.GetBotAssociationResult.Companion.toKotlin as getBotAssociationResultToKotlin
import com.pulumi.aws.connect.kotlin.outputs.GetContactFlowModuleResult.Companion.toKotlin as getContactFlowModuleResultToKotlin
import com.pulumi.aws.connect.kotlin.outputs.GetContactFlowResult.Companion.toKotlin as getContactFlowResultToKotlin
import com.pulumi.aws.connect.kotlin.outputs.GetHoursOfOperationResult.Companion.toKotlin as getHoursOfOperationResultToKotlin
import com.pulumi.aws.connect.kotlin.outputs.GetInstanceResult.Companion.toKotlin as getInstanceResultToKotlin
import com.pulumi.aws.connect.kotlin.outputs.GetInstanceStorageConfigResult.Companion.toKotlin as getInstanceStorageConfigResultToKotlin
import com.pulumi.aws.connect.kotlin.outputs.GetLambdaFunctionAssociationResult.Companion.toKotlin as getLambdaFunctionAssociationResultToKotlin
import com.pulumi.aws.connect.kotlin.outputs.GetPromptResult.Companion.toKotlin as getPromptResultToKotlin
import com.pulumi.aws.connect.kotlin.outputs.GetQueueResult.Companion.toKotlin as getQueueResultToKotlin
import com.pulumi.aws.connect.kotlin.outputs.GetQuickConnectResult.Companion.toKotlin as getQuickConnectResultToKotlin
import com.pulumi.aws.connect.kotlin.outputs.GetRoutingProfileResult.Companion.toKotlin as getRoutingProfileResultToKotlin
import com.pulumi.aws.connect.kotlin.outputs.GetSecurityProfileResult.Companion.toKotlin as getSecurityProfileResultToKotlin
import com.pulumi.aws.connect.kotlin.outputs.GetUserHierarchyGroupResult.Companion.toKotlin as getUserHierarchyGroupResultToKotlin
import com.pulumi.aws.connect.kotlin.outputs.GetUserHierarchyStructureResult.Companion.toKotlin as getUserHierarchyStructureResultToKotlin
import com.pulumi.aws.connect.kotlin.outputs.GetUserResult.Companion.toKotlin as getUserResultToKotlin
import com.pulumi.aws.connect.kotlin.outputs.GetVocabularyResult.Companion.toKotlin as getVocabularyResultToKotlin

public object ConnectFunctions {
    /**
     * Provides details about a specific Lex (V1) Bot associated with an Amazon Connect instance.
     * ## Example Usage
     * ### By name
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.connect.getBotAssociation({
     *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     lexBot: {
     *         name: "Test",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.connect.get_bot_association(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     lex_bot={
     *         "name": "Test",
     *     })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Connect.GetBotAssociation.Invoke(new()
     *     {
     *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *         LexBot = new Aws.Connect.Inputs.GetBotAssociationLexBotInputArgs
     *         {
     *             Name = "Test",
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := connect.LookupBotAssociation(ctx, &connect.LookupBotAssociationArgs{
     * 			InstanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     * 			LexBot: connect.GetBotAssociationLexBot{
     * 				Name: "Test",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.connect.ConnectFunctions;
     * import com.pulumi.aws.connect.inputs.GetBotAssociationArgs;
     * import com.pulumi.aws.connect.inputs.GetBotAssociationLexBotArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ConnectFunctions.getBotAssociation(GetBotAssociationArgs.builder()
     *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
     *             .lexBot(GetBotAssociationLexBotArgs.builder()
     *                 .name("Test")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:connect:getBotAssociation
     *       Arguments:
     *         instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
     *         lexBot:
     *           name: Test
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBotAssociation.
     * @return A collection of values returned by getBotAssociation.
     */
    public suspend fun getBotAssociation(argument: GetBotAssociationPlainArgs): GetBotAssociationResult =
        getBotAssociationResultToKotlin(getBotAssociationPlain(argument.toJava()).await())

    /**
     * @see [getBotAssociation].
     * @param instanceId Identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * @param lexBot Configuration information of an Amazon Lex (V1) bot. Detailed below.
     * @return A collection of values returned by getBotAssociation.
     */
    public suspend fun getBotAssociation(instanceId: String, lexBot: GetBotAssociationLexBot): GetBotAssociationResult {
        val argument = GetBotAssociationPlainArgs(
            instanceId = instanceId,
            lexBot = lexBot,
        )
        return getBotAssociationResultToKotlin(getBotAssociationPlain(argument.toJava()).await())
    }

    /**
     * @see [getBotAssociation].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;connect&#46;kotlin&#46;inputs&#46;GetBotAssociationPlainArgs].
     * @return A collection of values returned by getBotAssociation.
     */
    public suspend fun getBotAssociation(argument: suspend GetBotAssociationPlainArgsBuilder.() -> Unit): GetBotAssociationResult {
        val builder = GetBotAssociationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBotAssociationResultToKotlin(getBotAssociationPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific Amazon Connect Contact Flow.
     * ## Example Usage
     * By name
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.connect.getContactFlow({
     *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     name: "Test",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.connect.get_contact_flow(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     name="Test")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Connect.GetContactFlow.Invoke(new()
     *     {
     *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *         Name = "Test",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := connect.LookupContactFlow(ctx, &connect.LookupContactFlowArgs{
     * 			InstanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     * 			Name:       pulumi.StringRef("Test"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.connect.ConnectFunctions;
     * import com.pulumi.aws.connect.inputs.GetContactFlowArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = ConnectFunctions.getContactFlow(GetContactFlowArgs.builder()
     *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
     *             .name("Test")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:connect:getContactFlow
     *       Arguments:
     *         instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
     *         name: Test
     * ```
     * <!--End PulumiCodeChooser -->
     * By contact_flow_id
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.connect.getContactFlow({
     *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     contactFlowId: "cccccccc-bbbb-cccc-dddd-111111111111",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.connect.get_contact_flow(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     contact_flow_id="cccccccc-bbbb-cccc-dddd-111111111111")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Connect.GetContactFlow.Invoke(new()
     *     {
     *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *         ContactFlowId = "cccccccc-bbbb-cccc-dddd-111111111111",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := connect.LookupContactFlow(ctx, &connect.LookupContactFlowArgs{
     * 			InstanceId:    "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     * 			ContactFlowId: pulumi.StringRef("cccccccc-bbbb-cccc-dddd-111111111111"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.connect.ConnectFunctions;
     * import com.pulumi.aws.connect.inputs.GetContactFlowArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = ConnectFunctions.getContactFlow(GetContactFlowArgs.builder()
     *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
     *             .contactFlowId("cccccccc-bbbb-cccc-dddd-111111111111")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:connect:getContactFlow
     *       Arguments:
     *         instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
     *         contactFlowId: cccccccc-bbbb-cccc-dddd-111111111111
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getContactFlow.
     * @return A collection of values returned by getContactFlow.
     */
    public suspend fun getContactFlow(argument: GetContactFlowPlainArgs): GetContactFlowResult =
        getContactFlowResultToKotlin(getContactFlowPlain(argument.toJava()).await())

    /**
     * @see [getContactFlow].
     * @param contactFlowId Returns information on a specific Contact Flow by contact flow id
     * @param instanceId Reference to the hosting Amazon Connect Instance
     * @param name Returns information on a specific Contact Flow by name
     * @param tags Tags to assign to the Contact Flow.
     * @param type Type of Contact Flow.
     * @return A collection of values returned by getContactFlow.
     */
    public suspend fun getContactFlow(
        contactFlowId: String? = null,
        instanceId: String,
        name: String? = null,
        tags: Map<String, String>? = null,
        type: String? = null,
    ): GetContactFlowResult {
        val argument = GetContactFlowPlainArgs(
            contactFlowId = contactFlowId,
            instanceId = instanceId,
            name = name,
            tags = tags,
            type = type,
        )
        return getContactFlowResultToKotlin(getContactFlowPlain(argument.toJava()).await())
    }

    /**
     * @see [getContactFlow].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;connect&#46;kotlin&#46;inputs&#46;GetContactFlowPlainArgs].
     * @return A collection of values returned by getContactFlow.
     */
    public suspend fun getContactFlow(argument: suspend GetContactFlowPlainArgsBuilder.() -> Unit): GetContactFlowResult {
        val builder = GetContactFlowPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getContactFlowResultToKotlin(getContactFlowPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific Amazon Connect Contact Flow Module.
     * ## Example Usage
     * By `name`
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.connect.getContactFlowModule({
     *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     name: "example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.connect.get_contact_flow_module(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     name="example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Connect.GetContactFlowModule.Invoke(new()
     *     {
     *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *         Name = "example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := connect.LookupContactFlowModule(ctx, &connect.LookupContactFlowModuleArgs{
     * 			InstanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     * 			Name:       pulumi.StringRef("example"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.connect.ConnectFunctions;
     * import com.pulumi.aws.connect.inputs.GetContactFlowModuleArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ConnectFunctions.getContactFlowModule(GetContactFlowModuleArgs.builder()
     *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
     *             .name("example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:connect:getContactFlowModule
     *       Arguments:
     *         instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
     *         name: example
     * ```
     * <!--End PulumiCodeChooser -->
     * By `contact_flow_module_id`
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.connect.getContactFlowModule({
     *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     contactFlowModuleId: "cccccccc-bbbb-cccc-dddd-111111111111",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.connect.get_contact_flow_module(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     contact_flow_module_id="cccccccc-bbbb-cccc-dddd-111111111111")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Connect.GetContactFlowModule.Invoke(new()
     *     {
     *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *         ContactFlowModuleId = "cccccccc-bbbb-cccc-dddd-111111111111",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := connect.LookupContactFlowModule(ctx, &connect.LookupContactFlowModuleArgs{
     * 			InstanceId:          "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     * 			ContactFlowModuleId: pulumi.StringRef("cccccccc-bbbb-cccc-dddd-111111111111"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.connect.ConnectFunctions;
     * import com.pulumi.aws.connect.inputs.GetContactFlowModuleArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ConnectFunctions.getContactFlowModule(GetContactFlowModuleArgs.builder()
     *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
     *             .contactFlowModuleId("cccccccc-bbbb-cccc-dddd-111111111111")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:connect:getContactFlowModule
     *       Arguments:
     *         instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
     *         contactFlowModuleId: cccccccc-bbbb-cccc-dddd-111111111111
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getContactFlowModule.
     * @return A collection of values returned by getContactFlowModule.
     */
    public suspend fun getContactFlowModule(argument: GetContactFlowModulePlainArgs): GetContactFlowModuleResult =
        getContactFlowModuleResultToKotlin(getContactFlowModulePlain(argument.toJava()).await())

    /**
     * @see [getContactFlowModule].
     * @param contactFlowModuleId Returns information on a specific Contact Flow Module by contact flow module id
     * @param instanceId Reference to the hosting Amazon Connect Instance
     * @param name Returns information on a specific Contact Flow Module by name
     * @param tags Map of tags to assign to the Contact Flow Module.
     * @return A collection of values returned by getContactFlowModule.
     */
    public suspend fun getContactFlowModule(
        contactFlowModuleId: String? = null,
        instanceId: String,
        name: String? = null,
        tags: Map<String, String>? = null,
    ): GetContactFlowModuleResult {
        val argument = GetContactFlowModulePlainArgs(
            contactFlowModuleId = contactFlowModuleId,
            instanceId = instanceId,
            name = name,
            tags = tags,
        )
        return getContactFlowModuleResultToKotlin(getContactFlowModulePlain(argument.toJava()).await())
    }

    /**
     * @see [getContactFlowModule].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;connect&#46;kotlin&#46;inputs&#46;GetContactFlowModulePlainArgs].
     * @return A collection of values returned by getContactFlowModule.
     */
    public suspend fun getContactFlowModule(argument: suspend GetContactFlowModulePlainArgsBuilder.() -> Unit): GetContactFlowModuleResult {
        val builder = GetContactFlowModulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getContactFlowModuleResultToKotlin(getContactFlowModulePlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific Amazon Connect Hours of Operation.
     * ## Example Usage
     * By `name`
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.connect.getHoursOfOperation({
     *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     name: "Test",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.connect.get_hours_of_operation(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     name="Test")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Connect.GetHoursOfOperation.Invoke(new()
     *     {
     *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *         Name = "Test",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := connect.LookupHoursOfOperation(ctx, &connect.LookupHoursOfOperationArgs{
     * 			InstanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     * 			Name:       pulumi.StringRef("Test"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.connect.ConnectFunctions;
     * import com.pulumi.aws.connect.inputs.GetHoursOfOperationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = ConnectFunctions.getHoursOfOperation(GetHoursOfOperationArgs.builder()
     *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
     *             .name("Test")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:connect:getHoursOfOperation
     *       Arguments:
     *         instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
     *         name: Test
     * ```
     * <!--End PulumiCodeChooser -->
     * By `hours_of_operation_id`
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.connect.getHoursOfOperation({
     *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     hoursOfOperationId: "cccccccc-bbbb-cccc-dddd-111111111111",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.connect.get_hours_of_operation(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     hours_of_operation_id="cccccccc-bbbb-cccc-dddd-111111111111")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Connect.GetHoursOfOperation.Invoke(new()
     *     {
     *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *         HoursOfOperationId = "cccccccc-bbbb-cccc-dddd-111111111111",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := connect.LookupHoursOfOperation(ctx, &connect.LookupHoursOfOperationArgs{
     * 			InstanceId:         "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     * 			HoursOfOperationId: pulumi.StringRef("cccccccc-bbbb-cccc-dddd-111111111111"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.connect.ConnectFunctions;
     * import com.pulumi.aws.connect.inputs.GetHoursOfOperationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = ConnectFunctions.getHoursOfOperation(GetHoursOfOperationArgs.builder()
     *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
     *             .hoursOfOperationId("cccccccc-bbbb-cccc-dddd-111111111111")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:connect:getHoursOfOperation
     *       Arguments:
     *         instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
     *         hoursOfOperationId: cccccccc-bbbb-cccc-dddd-111111111111
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getHoursOfOperation.
     * @return A collection of values returned by getHoursOfOperation.
     */
    public suspend fun getHoursOfOperation(argument: GetHoursOfOperationPlainArgs): GetHoursOfOperationResult =
        getHoursOfOperationResultToKotlin(getHoursOfOperationPlain(argument.toJava()).await())

    /**
     * @see [getHoursOfOperation].
     * @param hoursOfOperationId Returns information on a specific Hours of Operation by hours of operation id
     * @param instanceId Reference to the hosting Amazon Connect Instance
     * @param name Returns information on a specific Hours of Operation by name
     * @param tags Map of tags to assign to the Hours of Operation.
     * @return A collection of values returned by getHoursOfOperation.
     */
    public suspend fun getHoursOfOperation(
        hoursOfOperationId: String? = null,
        instanceId: String,
        name: String? = null,
        tags: Map<String, String>? = null,
    ): GetHoursOfOperationResult {
        val argument = GetHoursOfOperationPlainArgs(
            hoursOfOperationId = hoursOfOperationId,
            instanceId = instanceId,
            name = name,
            tags = tags,
        )
        return getHoursOfOperationResultToKotlin(getHoursOfOperationPlain(argument.toJava()).await())
    }

    /**
     * @see [getHoursOfOperation].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;connect&#46;kotlin&#46;inputs&#46;GetHoursOfOperationPlainArgs].
     * @return A collection of values returned by getHoursOfOperation.
     */
    public suspend fun getHoursOfOperation(argument: suspend GetHoursOfOperationPlainArgsBuilder.() -> Unit): GetHoursOfOperationResult {
        val builder = GetHoursOfOperationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHoursOfOperationResultToKotlin(getHoursOfOperationPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific Amazon Connect Instance.
     * ## Example Usage
     * By instance_alias
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const foo = aws.connect.getInstance({
     *     instanceAlias: "foo",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * foo = aws.connect.get_instance(instance_alias="foo")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var foo = Aws.Connect.GetInstance.Invoke(new()
     *     {
     *         InstanceAlias = "foo",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := connect.LookupInstance(ctx, &connect.LookupInstanceArgs{
     * 			InstanceAlias: pulumi.StringRef("foo"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.connect.ConnectFunctions;
     * import com.pulumi.aws.connect.inputs.GetInstanceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var foo = ConnectFunctions.getInstance(GetInstanceArgs.builder()
     *             .instanceAlias("foo")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   foo:
     *     fn::invoke:
     *       Function: aws:connect:getInstance
     *       Arguments:
     *         instanceAlias: foo
     * ```
     * <!--End PulumiCodeChooser -->
     * By instance_id
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const foo = aws.connect.getInstance({
     *     instanceId: "97afc98d-101a-ba98-ab97-ae114fc115ec",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * foo = aws.connect.get_instance(instance_id="97afc98d-101a-ba98-ab97-ae114fc115ec")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var foo = Aws.Connect.GetInstance.Invoke(new()
     *     {
     *         InstanceId = "97afc98d-101a-ba98-ab97-ae114fc115ec",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := connect.LookupInstance(ctx, &connect.LookupInstanceArgs{
     * 			InstanceId: pulumi.StringRef("97afc98d-101a-ba98-ab97-ae114fc115ec"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.connect.ConnectFunctions;
     * import com.pulumi.aws.connect.inputs.GetInstanceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var foo = ConnectFunctions.getInstance(GetInstanceArgs.builder()
     *             .instanceId("97afc98d-101a-ba98-ab97-ae114fc115ec")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   foo:
     *     fn::invoke:
     *       Function: aws:connect:getInstance
     *       Arguments:
     *         instanceId: 97afc98d-101a-ba98-ab97-ae114fc115ec
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstance.
     * @return A collection of values returned by getInstance.
     */
    public suspend fun getInstance(argument: GetInstancePlainArgs): GetInstanceResult =
        getInstanceResultToKotlin(getInstancePlain(argument.toJava()).await())

    /**
     * @see [getInstance].
     * @param instanceAlias Returns information on a specific connect instance by alias
     * @param instanceId Returns information on a specific connect instance by id
     * @return A collection of values returned by getInstance.
     */
    public suspend fun getInstance(instanceAlias: String? = null, instanceId: String? = null): GetInstanceResult {
        val argument = GetInstancePlainArgs(
            instanceAlias = instanceAlias,
            instanceId = instanceId,
        )
        return getInstanceResultToKotlin(getInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getInstance].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;connect&#46;kotlin&#46;inputs&#46;GetInstancePlainArgs].
     * @return A collection of values returned by getInstance.
     */
    public suspend fun getInstance(argument: suspend GetInstancePlainArgsBuilder.() -> Unit): GetInstanceResult {
        val builder = GetInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceResultToKotlin(getInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific Amazon Connect Instance Storage Config.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.connect.getInstanceStorageConfig({
     *     associationId: "1234567890123456789012345678901234567890123456789012345678901234",
     *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     resourceType: "CONTACT_TRACE_RECORDS",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.connect.get_instance_storage_config(association_id="1234567890123456789012345678901234567890123456789012345678901234",
     *     instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     resource_type="CONTACT_TRACE_RECORDS")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Connect.GetInstanceStorageConfig.Invoke(new()
     *     {
     *         AssociationId = "1234567890123456789012345678901234567890123456789012345678901234",
     *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *         ResourceType = "CONTACT_TRACE_RECORDS",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := connect.LookupInstanceStorageConfig(ctx, &connect.LookupInstanceStorageConfigArgs{
     * 			AssociationId: "1234567890123456789012345678901234567890123456789012345678901234",
     * 			InstanceId:    "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     * 			ResourceType:  "CONTACT_TRACE_RECORDS",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.connect.ConnectFunctions;
     * import com.pulumi.aws.connect.inputs.GetInstanceStorageConfigArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ConnectFunctions.getInstanceStorageConfig(GetInstanceStorageConfigArgs.builder()
     *             .associationId("1234567890123456789012345678901234567890123456789012345678901234")
     *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
     *             .resourceType("CONTACT_TRACE_RECORDS")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:connect:getInstanceStorageConfig
     *       Arguments:
     *         associationId: 1234567890123456789012345678901234567890123456789012345678901234
     *         instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
     *         resourceType: CONTACT_TRACE_RECORDS
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstanceStorageConfig.
     * @return A collection of values returned by getInstanceStorageConfig.
     */
    public suspend fun getInstanceStorageConfig(argument: GetInstanceStorageConfigPlainArgs): GetInstanceStorageConfigResult =
        getInstanceStorageConfigResultToKotlin(getInstanceStorageConfigPlain(argument.toJava()).await())

    /**
     * @see [getInstanceStorageConfig].
     * @param associationId The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.
     * @param instanceId Reference to the hosting Amazon Connect Instance
     * @param resourceType A valid resource type. Valid Values: `AGENT_EVENTS` | `ATTACHMENTS` | `CALL_RECORDINGS` | `CHAT_TRANSCRIPTS` | `CONTACT_EVALUATIONS` | `CONTACT_TRACE_RECORDS` | `MEDIA_STREAMS` | `REAL_TIME_CONTACT_ANALYSIS_SEGMENTS` | `SCHEDULED_REPORTS` |  `SCREEN_RECORDINGS`.
     * @return A collection of values returned by getInstanceStorageConfig.
     */
    public suspend fun getInstanceStorageConfig(
        associationId: String,
        instanceId: String,
        resourceType: String,
    ): GetInstanceStorageConfigResult {
        val argument = GetInstanceStorageConfigPlainArgs(
            associationId = associationId,
            instanceId = instanceId,
            resourceType = resourceType,
        )
        return getInstanceStorageConfigResultToKotlin(getInstanceStorageConfigPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceStorageConfig].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;connect&#46;kotlin&#46;inputs&#46;GetInstanceStorageConfigPlainArgs].
     * @return A collection of values returned by getInstanceStorageConfig.
     */
    public suspend fun getInstanceStorageConfig(argument: suspend GetInstanceStorageConfigPlainArgsBuilder.() -> Unit): GetInstanceStorageConfigResult {
        val builder = GetInstanceStorageConfigPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceStorageConfigResultToKotlin(getInstanceStorageConfigPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific Connect Lambda Function Association.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.connect.getLambdaFunctionAssociation({
     *     functionArn: "arn:aws:lambda:us-west-2:123456789123:function:abcdefg",
     *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.connect.get_lambda_function_association(function_arn="arn:aws:lambda:us-west-2:123456789123:function:abcdefg",
     *     instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Connect.GetLambdaFunctionAssociation.Invoke(new()
     *     {
     *         FunctionArn = "arn:aws:lambda:us-west-2:123456789123:function:abcdefg",
     *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := connect.LookupLambdaFunctionAssociation(ctx, &connect.LookupLambdaFunctionAssociationArgs{
     * 			FunctionArn: "arn:aws:lambda:us-west-2:123456789123:function:abcdefg",
     * 			InstanceId:  "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.connect.ConnectFunctions;
     * import com.pulumi.aws.connect.inputs.GetLambdaFunctionAssociationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ConnectFunctions.getLambdaFunctionAssociation(GetLambdaFunctionAssociationArgs.builder()
     *             .functionArn("arn:aws:lambda:us-west-2:123456789123:function:abcdefg")
     *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:connect:getLambdaFunctionAssociation
     *       Arguments:
     *         functionArn: arn:aws:lambda:us-west-2:123456789123:function:abcdefg
     *         instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLambdaFunctionAssociation.
     * @return A collection of values returned by getLambdaFunctionAssociation.
     */
    public suspend fun getLambdaFunctionAssociation(argument: GetLambdaFunctionAssociationPlainArgs): GetLambdaFunctionAssociationResult =
        getLambdaFunctionAssociationResultToKotlin(getLambdaFunctionAssociationPlain(argument.toJava()).await())

    /**
     * @see [getLambdaFunctionAssociation].
     * @param functionArn ARN of the Lambda Function, omitting any version or alias qualifier.
     * @param instanceId Identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * @return A collection of values returned by getLambdaFunctionAssociation.
     */
    public suspend fun getLambdaFunctionAssociation(functionArn: String, instanceId: String): GetLambdaFunctionAssociationResult {
        val argument = GetLambdaFunctionAssociationPlainArgs(
            functionArn = functionArn,
            instanceId = instanceId,
        )
        return getLambdaFunctionAssociationResultToKotlin(getLambdaFunctionAssociationPlain(argument.toJava()).await())
    }

    /**
     * @see [getLambdaFunctionAssociation].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;connect&#46;kotlin&#46;inputs&#46;GetLambdaFunctionAssociationPlainArgs].
     * @return A collection of values returned by getLambdaFunctionAssociation.
     */
    public suspend fun getLambdaFunctionAssociation(argument: suspend GetLambdaFunctionAssociationPlainArgsBuilder.() -> Unit): GetLambdaFunctionAssociationResult {
        val builder = GetLambdaFunctionAssociationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLambdaFunctionAssociationResultToKotlin(getLambdaFunctionAssociationPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific Amazon Connect Prompt.
     * ## Example Usage
     * By `name`
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.connect.getPrompt({
     *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     name: "Beep.wav",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.connect.get_prompt(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     name="Beep.wav")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Connect.GetPrompt.Invoke(new()
     *     {
     *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *         Name = "Beep.wav",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := connect.GetPrompt(ctx, &connect.GetPromptArgs{
     * 			InstanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     * 			Name:       "Beep.wav",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.connect.ConnectFunctions;
     * import com.pulumi.aws.connect.inputs.GetPromptArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ConnectFunctions.getPrompt(GetPromptArgs.builder()
     *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
     *             .name("Beep.wav")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:connect:getPrompt
     *       Arguments:
     *         instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
     *         name: Beep.wav
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPrompt.
     * @return A collection of values returned by getPrompt.
     */
    public suspend fun getPrompt(argument: GetPromptPlainArgs): GetPromptResult =
        getPromptResultToKotlin(getPromptPlain(argument.toJava()).await())

    /**
     * @see [getPrompt].
     * @param instanceId Reference to the hosting Amazon Connect Instance
     * @param name Returns information on a specific Prompt by name
     * @return A collection of values returned by getPrompt.
     */
    public suspend fun getPrompt(instanceId: String, name: String): GetPromptResult {
        val argument = GetPromptPlainArgs(
            instanceId = instanceId,
            name = name,
        )
        return getPromptResultToKotlin(getPromptPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrompt].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;connect&#46;kotlin&#46;inputs&#46;GetPromptPlainArgs].
     * @return A collection of values returned by getPrompt.
     */
    public suspend fun getPrompt(argument: suspend GetPromptPlainArgsBuilder.() -> Unit): GetPromptResult {
        val builder = GetPromptPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPromptResultToKotlin(getPromptPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific Amazon Connect Queue.
     * ## Example Usage
     * By `name`
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.connect.getQueue({
     *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     name: "Example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.connect.get_queue(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     name="Example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Connect.GetQueue.Invoke(new()
     *     {
     *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *         Name = "Example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := connect.LookupQueue(ctx, &connect.LookupQueueArgs{
     * 			InstanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     * 			Name:       pulumi.StringRef("Example"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.connect.ConnectFunctions;
     * import com.pulumi.aws.connect.inputs.GetQueueArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ConnectFunctions.getQueue(GetQueueArgs.builder()
     *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
     *             .name("Example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:connect:getQueue
     *       Arguments:
     *         instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
     *         name: Example
     * ```
     * <!--End PulumiCodeChooser -->
     * By `queue_id`
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.connect.getQueue({
     *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     queueId: "cccccccc-bbbb-cccc-dddd-111111111111",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.connect.get_queue(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     queue_id="cccccccc-bbbb-cccc-dddd-111111111111")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Connect.GetQueue.Invoke(new()
     *     {
     *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *         QueueId = "cccccccc-bbbb-cccc-dddd-111111111111",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := connect.LookupQueue(ctx, &connect.LookupQueueArgs{
     * 			InstanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     * 			QueueId:    pulumi.StringRef("cccccccc-bbbb-cccc-dddd-111111111111"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.connect.ConnectFunctions;
     * import com.pulumi.aws.connect.inputs.GetQueueArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ConnectFunctions.getQueue(GetQueueArgs.builder()
     *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
     *             .queueId("cccccccc-bbbb-cccc-dddd-111111111111")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:connect:getQueue
     *       Arguments:
     *         instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
     *         queueId: cccccccc-bbbb-cccc-dddd-111111111111
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getQueue.
     * @return A collection of values returned by getQueue.
     */
    public suspend fun getQueue(argument: GetQueuePlainArgs): GetQueueResult =
        getQueueResultToKotlin(getQueuePlain(argument.toJava()).await())

    /**
     * @see [getQueue].
     * @param instanceId Reference to the hosting Amazon Connect Instance
     * @param name Returns information on a specific Queue by name
     * @param queueId Returns information on a specific Queue by Queue id
     * @param tags Map of tags assigned to the Queue.
     * @return A collection of values returned by getQueue.
     */
    public suspend fun getQueue(
        instanceId: String,
        name: String? = null,
        queueId: String? = null,
        tags: Map<String, String>? = null,
    ): GetQueueResult {
        val argument = GetQueuePlainArgs(
            instanceId = instanceId,
            name = name,
            queueId = queueId,
            tags = tags,
        )
        return getQueueResultToKotlin(getQueuePlain(argument.toJava()).await())
    }

    /**
     * @see [getQueue].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;connect&#46;kotlin&#46;inputs&#46;GetQueuePlainArgs].
     * @return A collection of values returned by getQueue.
     */
    public suspend fun getQueue(argument: suspend GetQueuePlainArgsBuilder.() -> Unit): GetQueueResult {
        val builder = GetQueuePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getQueueResultToKotlin(getQueuePlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific Amazon Connect Quick Connect.
     * ## Example Usage
     * By `name`
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.connect.getQuickConnect({
     *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     name: "Example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.connect.get_quick_connect(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     name="Example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Connect.GetQuickConnect.Invoke(new()
     *     {
     *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *         Name = "Example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := connect.LookupQuickConnect(ctx, &connect.LookupQuickConnectArgs{
     * 			InstanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     * 			Name:       pulumi.StringRef("Example"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.connect.ConnectFunctions;
     * import com.pulumi.aws.connect.inputs.GetQuickConnectArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ConnectFunctions.getQuickConnect(GetQuickConnectArgs.builder()
     *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
     *             .name("Example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:connect:getQuickConnect
     *       Arguments:
     *         instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
     *         name: Example
     * ```
     * <!--End PulumiCodeChooser -->
     * By `quick_connect_id`
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.connect.getQuickConnect({
     *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     quickConnectId: "cccccccc-bbbb-cccc-dddd-111111111111",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.connect.get_quick_connect(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     quick_connect_id="cccccccc-bbbb-cccc-dddd-111111111111")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Connect.GetQuickConnect.Invoke(new()
     *     {
     *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *         QuickConnectId = "cccccccc-bbbb-cccc-dddd-111111111111",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := connect.LookupQuickConnect(ctx, &connect.LookupQuickConnectArgs{
     * 			InstanceId:     "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     * 			QuickConnectId: pulumi.StringRef("cccccccc-bbbb-cccc-dddd-111111111111"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.connect.ConnectFunctions;
     * import com.pulumi.aws.connect.inputs.GetQuickConnectArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ConnectFunctions.getQuickConnect(GetQuickConnectArgs.builder()
     *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
     *             .quickConnectId("cccccccc-bbbb-cccc-dddd-111111111111")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:connect:getQuickConnect
     *       Arguments:
     *         instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
     *         quickConnectId: cccccccc-bbbb-cccc-dddd-111111111111
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getQuickConnect.
     * @return A collection of values returned by getQuickConnect.
     */
    public suspend fun getQuickConnect(argument: GetQuickConnectPlainArgs): GetQuickConnectResult =
        getQuickConnectResultToKotlin(getQuickConnectPlain(argument.toJava()).await())

    /**
     * @see [getQuickConnect].
     * @param instanceId Reference to the hosting Amazon Connect Instance
     * @param name Returns information on a specific Quick Connect by name
     * @param quickConnectId Returns information on a specific Quick Connect by Quick Connect id
     * @param tags Map of tags to assign to the Quick Connect.
     * @return A collection of values returned by getQuickConnect.
     */
    public suspend fun getQuickConnect(
        instanceId: String,
        name: String? = null,
        quickConnectId: String? = null,
        tags: Map<String, String>? = null,
    ): GetQuickConnectResult {
        val argument = GetQuickConnectPlainArgs(
            instanceId = instanceId,
            name = name,
            quickConnectId = quickConnectId,
            tags = tags,
        )
        return getQuickConnectResultToKotlin(getQuickConnectPlain(argument.toJava()).await())
    }

    /**
     * @see [getQuickConnect].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;connect&#46;kotlin&#46;inputs&#46;GetQuickConnectPlainArgs].
     * @return A collection of values returned by getQuickConnect.
     */
    public suspend fun getQuickConnect(argument: suspend GetQuickConnectPlainArgsBuilder.() -> Unit): GetQuickConnectResult {
        val builder = GetQuickConnectPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getQuickConnectResultToKotlin(getQuickConnectPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific Amazon Connect Routing Profile.
     * ## Example Usage
     * By `name`
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.connect.getRoutingProfile({
     *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     name: "Example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.connect.get_routing_profile(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     name="Example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Connect.GetRoutingProfile.Invoke(new()
     *     {
     *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *         Name = "Example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := connect.LookupRoutingProfile(ctx, &connect.LookupRoutingProfileArgs{
     * 			InstanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     * 			Name:       pulumi.StringRef("Example"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.connect.ConnectFunctions;
     * import com.pulumi.aws.connect.inputs.GetRoutingProfileArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ConnectFunctions.getRoutingProfile(GetRoutingProfileArgs.builder()
     *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
     *             .name("Example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:connect:getRoutingProfile
     *       Arguments:
     *         instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
     *         name: Example
     * ```
     * <!--End PulumiCodeChooser -->
     * By `routing_profile_id`
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.connect.getRoutingProfile({
     *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     routingProfileId: "cccccccc-bbbb-cccc-dddd-111111111111",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.connect.get_routing_profile(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     routing_profile_id="cccccccc-bbbb-cccc-dddd-111111111111")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Connect.GetRoutingProfile.Invoke(new()
     *     {
     *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *         RoutingProfileId = "cccccccc-bbbb-cccc-dddd-111111111111",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := connect.LookupRoutingProfile(ctx, &connect.LookupRoutingProfileArgs{
     * 			InstanceId:       "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     * 			RoutingProfileId: pulumi.StringRef("cccccccc-bbbb-cccc-dddd-111111111111"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.connect.ConnectFunctions;
     * import com.pulumi.aws.connect.inputs.GetRoutingProfileArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ConnectFunctions.getRoutingProfile(GetRoutingProfileArgs.builder()
     *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
     *             .routingProfileId("cccccccc-bbbb-cccc-dddd-111111111111")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:connect:getRoutingProfile
     *       Arguments:
     *         instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
     *         routingProfileId: cccccccc-bbbb-cccc-dddd-111111111111
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRoutingProfile.
     * @return A collection of values returned by getRoutingProfile.
     */
    public suspend fun getRoutingProfile(argument: GetRoutingProfilePlainArgs): GetRoutingProfileResult =
        getRoutingProfileResultToKotlin(getRoutingProfilePlain(argument.toJava()).await())

    /**
     * @see [getRoutingProfile].
     * @param instanceId Reference to the hosting Amazon Connect Instance
     * @param name Returns information on a specific Routing Profile by name
     * @param routingProfileId Returns information on a specific Routing Profile by Routing Profile id
     * @param tags Map of tags to assign to the Routing Profile.
     * @return A collection of values returned by getRoutingProfile.
     */
    public suspend fun getRoutingProfile(
        instanceId: String,
        name: String? = null,
        routingProfileId: String? = null,
        tags: Map<String, String>? = null,
    ): GetRoutingProfileResult {
        val argument = GetRoutingProfilePlainArgs(
            instanceId = instanceId,
            name = name,
            routingProfileId = routingProfileId,
            tags = tags,
        )
        return getRoutingProfileResultToKotlin(getRoutingProfilePlain(argument.toJava()).await())
    }

    /**
     * @see [getRoutingProfile].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;connect&#46;kotlin&#46;inputs&#46;GetRoutingProfilePlainArgs].
     * @return A collection of values returned by getRoutingProfile.
     */
    public suspend fun getRoutingProfile(argument: suspend GetRoutingProfilePlainArgsBuilder.() -> Unit): GetRoutingProfileResult {
        val builder = GetRoutingProfilePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRoutingProfileResultToKotlin(getRoutingProfilePlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific Amazon Connect Security Profile.
     * ## Example Usage
     * By `name`
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.connect.getSecurityProfile({
     *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     name: "Example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.connect.get_security_profile(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     name="Example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Connect.GetSecurityProfile.Invoke(new()
     *     {
     *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *         Name = "Example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := connect.LookupSecurityProfile(ctx, &connect.LookupSecurityProfileArgs{
     * 			InstanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     * 			Name:       pulumi.StringRef("Example"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.connect.ConnectFunctions;
     * import com.pulumi.aws.connect.inputs.GetSecurityProfileArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ConnectFunctions.getSecurityProfile(GetSecurityProfileArgs.builder()
     *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
     *             .name("Example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:connect:getSecurityProfile
     *       Arguments:
     *         instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
     *         name: Example
     * ```
     * <!--End PulumiCodeChooser -->
     * By `security_profile_id`
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.connect.getSecurityProfile({
     *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     securityProfileId: "cccccccc-bbbb-cccc-dddd-111111111111",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.connect.get_security_profile(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     security_profile_id="cccccccc-bbbb-cccc-dddd-111111111111")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Connect.GetSecurityProfile.Invoke(new()
     *     {
     *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *         SecurityProfileId = "cccccccc-bbbb-cccc-dddd-111111111111",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := connect.LookupSecurityProfile(ctx, &connect.LookupSecurityProfileArgs{
     * 			InstanceId:        "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     * 			SecurityProfileId: pulumi.StringRef("cccccccc-bbbb-cccc-dddd-111111111111"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.connect.ConnectFunctions;
     * import com.pulumi.aws.connect.inputs.GetSecurityProfileArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ConnectFunctions.getSecurityProfile(GetSecurityProfileArgs.builder()
     *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
     *             .securityProfileId("cccccccc-bbbb-cccc-dddd-111111111111")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:connect:getSecurityProfile
     *       Arguments:
     *         instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
     *         securityProfileId: cccccccc-bbbb-cccc-dddd-111111111111
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSecurityProfile.
     * @return A collection of values returned by getSecurityProfile.
     */
    public suspend fun getSecurityProfile(argument: GetSecurityProfilePlainArgs): GetSecurityProfileResult =
        getSecurityProfileResultToKotlin(getSecurityProfilePlain(argument.toJava()).await())

    /**
     * @see [getSecurityProfile].
     * @param instanceId Reference to the hosting Amazon Connect Instance
     * @param name Returns information on a specific Security Profile by name
     * @param securityProfileId Returns information on a specific Security Profile by Security Profile id
     * @param tags Map of tags to assign to the Security Profile.
     * @return A collection of values returned by getSecurityProfile.
     */
    public suspend fun getSecurityProfile(
        instanceId: String,
        name: String? = null,
        securityProfileId: String? = null,
        tags: Map<String, String>? = null,
    ): GetSecurityProfileResult {
        val argument = GetSecurityProfilePlainArgs(
            instanceId = instanceId,
            name = name,
            securityProfileId = securityProfileId,
            tags = tags,
        )
        return getSecurityProfileResultToKotlin(getSecurityProfilePlain(argument.toJava()).await())
    }

    /**
     * @see [getSecurityProfile].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;connect&#46;kotlin&#46;inputs&#46;GetSecurityProfilePlainArgs].
     * @return A collection of values returned by getSecurityProfile.
     */
    public suspend fun getSecurityProfile(argument: suspend GetSecurityProfilePlainArgsBuilder.() -> Unit): GetSecurityProfileResult {
        val builder = GetSecurityProfilePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecurityProfileResultToKotlin(getSecurityProfilePlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific Amazon Connect User.
     * ## Example Usage
     * By `name`
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.connect.getUser({
     *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     name: "Example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.connect.get_user(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     name="Example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Connect.GetUser.Invoke(new()
     *     {
     *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *         Name = "Example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := connect.LookupUser(ctx, &connect.LookupUserArgs{
     * 			InstanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     * 			Name:       pulumi.StringRef("Example"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.connect.ConnectFunctions;
     * import com.pulumi.aws.connect.inputs.GetUserArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ConnectFunctions.getUser(GetUserArgs.builder()
     *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
     *             .name("Example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:connect:getUser
     *       Arguments:
     *         instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
     *         name: Example
     * ```
     * <!--End PulumiCodeChooser -->
     * By `user_id`
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.connect.getUser({
     *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     userId: "cccccccc-bbbb-cccc-dddd-111111111111",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.connect.get_user(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     user_id="cccccccc-bbbb-cccc-dddd-111111111111")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Connect.GetUser.Invoke(new()
     *     {
     *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *         UserId = "cccccccc-bbbb-cccc-dddd-111111111111",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := connect.LookupUser(ctx, &connect.LookupUserArgs{
     * 			InstanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     * 			UserId:     pulumi.StringRef("cccccccc-bbbb-cccc-dddd-111111111111"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.connect.ConnectFunctions;
     * import com.pulumi.aws.connect.inputs.GetUserArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ConnectFunctions.getUser(GetUserArgs.builder()
     *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
     *             .userId("cccccccc-bbbb-cccc-dddd-111111111111")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:connect:getUser
     *       Arguments:
     *         instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
     *         userId: cccccccc-bbbb-cccc-dddd-111111111111
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getUser.
     * @return A collection of values returned by getUser.
     */
    public suspend fun getUser(argument: GetUserPlainArgs): GetUserResult =
        getUserResultToKotlin(getUserPlain(argument.toJava()).await())

    /**
     * @see [getUser].
     * @param instanceId Reference to the hosting Amazon Connect Instance
     * @param name Returns information on a specific User by name
     * @param tags A map of tags to assign to the User.
     * @param userId Returns information on a specific User by User id
     * @return A collection of values returned by getUser.
     */
    public suspend fun getUser(
        instanceId: String,
        name: String? = null,
        tags: Map<String, String>? = null,
        userId: String? = null,
    ): GetUserResult {
        val argument = GetUserPlainArgs(
            instanceId = instanceId,
            name = name,
            tags = tags,
            userId = userId,
        )
        return getUserResultToKotlin(getUserPlain(argument.toJava()).await())
    }

    /**
     * @see [getUser].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;connect&#46;kotlin&#46;inputs&#46;GetUserPlainArgs].
     * @return A collection of values returned by getUser.
     */
    public suspend fun getUser(argument: suspend GetUserPlainArgsBuilder.() -> Unit): GetUserResult {
        val builder = GetUserPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserResultToKotlin(getUserPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific Amazon Connect User Hierarchy Group.
     * ## Example Usage
     * By `name`
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.connect.getUserHierarchyGroup({
     *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     name: "Example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.connect.get_user_hierarchy_group(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     name="Example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Connect.GetUserHierarchyGroup.Invoke(new()
     *     {
     *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *         Name = "Example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := connect.LookupUserHierarchyGroup(ctx, &connect.LookupUserHierarchyGroupArgs{
     * 			InstanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     * 			Name:       pulumi.StringRef("Example"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.connect.ConnectFunctions;
     * import com.pulumi.aws.connect.inputs.GetUserHierarchyGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ConnectFunctions.getUserHierarchyGroup(GetUserHierarchyGroupArgs.builder()
     *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
     *             .name("Example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:connect:getUserHierarchyGroup
     *       Arguments:
     *         instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
     *         name: Example
     * ```
     * <!--End PulumiCodeChooser -->
     * By `hierarchy_group_id`
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.connect.getUserHierarchyGroup({
     *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     hierarchyGroupId: "cccccccc-bbbb-cccc-dddd-111111111111",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.connect.get_user_hierarchy_group(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     hierarchy_group_id="cccccccc-bbbb-cccc-dddd-111111111111")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Connect.GetUserHierarchyGroup.Invoke(new()
     *     {
     *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *         HierarchyGroupId = "cccccccc-bbbb-cccc-dddd-111111111111",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := connect.LookupUserHierarchyGroup(ctx, &connect.LookupUserHierarchyGroupArgs{
     * 			InstanceId:       "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     * 			HierarchyGroupId: pulumi.StringRef("cccccccc-bbbb-cccc-dddd-111111111111"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.connect.ConnectFunctions;
     * import com.pulumi.aws.connect.inputs.GetUserHierarchyGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ConnectFunctions.getUserHierarchyGroup(GetUserHierarchyGroupArgs.builder()
     *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
     *             .hierarchyGroupId("cccccccc-bbbb-cccc-dddd-111111111111")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:connect:getUserHierarchyGroup
     *       Arguments:
     *         instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
     *         hierarchyGroupId: cccccccc-bbbb-cccc-dddd-111111111111
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getUserHierarchyGroup.
     * @return A collection of values returned by getUserHierarchyGroup.
     */
    public suspend fun getUserHierarchyGroup(argument: GetUserHierarchyGroupPlainArgs): GetUserHierarchyGroupResult =
        getUserHierarchyGroupResultToKotlin(getUserHierarchyGroupPlain(argument.toJava()).await())

    /**
     * @see [getUserHierarchyGroup].
     * @param hierarchyGroupId Returns information on a specific hierarchy group by hierarchy group id
     * @param instanceId Reference to the hosting Amazon Connect Instance
     * @param name Returns information on a specific hierarchy group by name
     * @param tags Map of tags to assign to the hierarchy group.
     * @return A collection of values returned by getUserHierarchyGroup.
     */
    public suspend fun getUserHierarchyGroup(
        hierarchyGroupId: String? = null,
        instanceId: String,
        name: String? = null,
        tags: Map<String, String>? = null,
    ): GetUserHierarchyGroupResult {
        val argument = GetUserHierarchyGroupPlainArgs(
            hierarchyGroupId = hierarchyGroupId,
            instanceId = instanceId,
            name = name,
            tags = tags,
        )
        return getUserHierarchyGroupResultToKotlin(getUserHierarchyGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getUserHierarchyGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;connect&#46;kotlin&#46;inputs&#46;GetUserHierarchyGroupPlainArgs].
     * @return A collection of values returned by getUserHierarchyGroup.
     */
    public suspend fun getUserHierarchyGroup(argument: suspend GetUserHierarchyGroupPlainArgsBuilder.() -> Unit): GetUserHierarchyGroupResult {
        val builder = GetUserHierarchyGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserHierarchyGroupResultToKotlin(getUserHierarchyGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific Amazon Connect User Hierarchy Structure
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.connect.getUserHierarchyStructure({
     *     instanceId: testAwsConnectInstance.id,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.connect.get_user_hierarchy_structure(instance_id=test_aws_connect_instance["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Connect.GetUserHierarchyStructure.Invoke(new()
     *     {
     *         InstanceId = testAwsConnectInstance.Id,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := connect.LookupUserHierarchyStructure(ctx, &connect.LookupUserHierarchyStructureArgs{
     * 			InstanceId: testAwsConnectInstance.Id,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.connect.ConnectFunctions;
     * import com.pulumi.aws.connect.inputs.GetUserHierarchyStructureArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = ConnectFunctions.getUserHierarchyStructure(GetUserHierarchyStructureArgs.builder()
     *             .instanceId(testAwsConnectInstance.id())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:connect:getUserHierarchyStructure
     *       Arguments:
     *         instanceId: ${testAwsConnectInstance.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getUserHierarchyStructure.
     * @return A collection of values returned by getUserHierarchyStructure.
     */
    public suspend fun getUserHierarchyStructure(argument: GetUserHierarchyStructurePlainArgs): GetUserHierarchyStructureResult =
        getUserHierarchyStructureResultToKotlin(getUserHierarchyStructurePlain(argument.toJava()).await())

    /**
     * @see [getUserHierarchyStructure].
     * @param instanceId Reference to the hosting Amazon Connect Instance
     * @return A collection of values returned by getUserHierarchyStructure.
     */
    public suspend fun getUserHierarchyStructure(instanceId: String): GetUserHierarchyStructureResult {
        val argument = GetUserHierarchyStructurePlainArgs(
            instanceId = instanceId,
        )
        return getUserHierarchyStructureResultToKotlin(getUserHierarchyStructurePlain(argument.toJava()).await())
    }

    /**
     * @see [getUserHierarchyStructure].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;connect&#46;kotlin&#46;inputs&#46;GetUserHierarchyStructurePlainArgs].
     * @return A collection of values returned by getUserHierarchyStructure.
     */
    public suspend fun getUserHierarchyStructure(argument: suspend GetUserHierarchyStructurePlainArgsBuilder.() -> Unit): GetUserHierarchyStructureResult {
        val builder = GetUserHierarchyStructurePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserHierarchyStructureResultToKotlin(getUserHierarchyStructurePlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific Amazon Connect Vocabulary.
     * ## Example Usage
     * By `name`
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.connect.getVocabulary({
     *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     name: "Example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.connect.get_vocabulary(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     name="Example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Connect.GetVocabulary.Invoke(new()
     *     {
     *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *         Name = "Example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := connect.LookupVocabulary(ctx, &connect.LookupVocabularyArgs{
     * 			InstanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     * 			Name:       pulumi.StringRef("Example"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.connect.ConnectFunctions;
     * import com.pulumi.aws.connect.inputs.GetVocabularyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ConnectFunctions.getVocabulary(GetVocabularyArgs.builder()
     *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
     *             .name("Example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:connect:getVocabulary
     *       Arguments:
     *         instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
     *         name: Example
     * ```
     * <!--End PulumiCodeChooser -->
     * By `vocabulary_id`
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.connect.getVocabulary({
     *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     vocabularyId: "cccccccc-bbbb-cccc-dddd-111111111111",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.connect.get_vocabulary(instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *     vocabulary_id="cccccccc-bbbb-cccc-dddd-111111111111")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Connect.GetVocabulary.Invoke(new()
     *     {
     *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     *         VocabularyId = "cccccccc-bbbb-cccc-dddd-111111111111",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := connect.LookupVocabulary(ctx, &connect.LookupVocabularyArgs{
     * 			InstanceId:   "aaaaaaaa-bbbb-cccc-dddd-111111111111",
     * 			VocabularyId: pulumi.StringRef("cccccccc-bbbb-cccc-dddd-111111111111"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.connect.ConnectFunctions;
     * import com.pulumi.aws.connect.inputs.GetVocabularyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ConnectFunctions.getVocabulary(GetVocabularyArgs.builder()
     *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
     *             .vocabularyId("cccccccc-bbbb-cccc-dddd-111111111111")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:connect:getVocabulary
     *       Arguments:
     *         instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
     *         vocabularyId: cccccccc-bbbb-cccc-dddd-111111111111
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVocabulary.
     * @return A collection of values returned by getVocabulary.
     */
    public suspend fun getVocabulary(argument: GetVocabularyPlainArgs): GetVocabularyResult =
        getVocabularyResultToKotlin(getVocabularyPlain(argument.toJava()).await())

    /**
     * @see [getVocabulary].
     * @param instanceId Reference to the hosting Amazon Connect Instance
     * @param name Returns information on a specific Vocabulary by name
     * @param tags A map of tags to assign to the Vocabulary.
     * @param vocabularyId Returns information on a specific Vocabulary by Vocabulary id
     * @return A collection of values returned by getVocabulary.
     */
    public suspend fun getVocabulary(
        instanceId: String,
        name: String? = null,
        tags: Map<String, String>? = null,
        vocabularyId: String? = null,
    ): GetVocabularyResult {
        val argument = GetVocabularyPlainArgs(
            instanceId = instanceId,
            name = name,
            tags = tags,
            vocabularyId = vocabularyId,
        )
        return getVocabularyResultToKotlin(getVocabularyPlain(argument.toJava()).await())
    }

    /**
     * @see [getVocabulary].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;connect&#46;kotlin&#46;inputs&#46;GetVocabularyPlainArgs].
     * @return A collection of values returned by getVocabulary.
     */
    public suspend fun getVocabulary(argument: suspend GetVocabularyPlainArgsBuilder.() -> Unit): GetVocabularyResult {
        val builder = GetVocabularyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVocabularyResultToKotlin(getVocabularyPlain(builtArgument.toJava()).await())
    }
}
