@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.ContactFlowArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Connect Contact Flow resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * This resource embeds or references Contact Flows specified in Amazon Connect Contact Flow Language. For more information see
 * [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html)
 * !> **WARN:** Contact Flows exported from the Console [Contact Flow import/export](https://docs&#46;aws&#46;amazon&#46;com/connect/latest/adminguide/contact-flow-import-export&#46;html) are not in the Amazon Connect Contact Flow Language and can not be used with this resource&#46; Instead, the recommendation is to use the AWS CLI [`describe-contact-flow`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/connect/describe-contact-flow.html).
 * See example below which uses `jq` to extract the `Content` attribute and saves it to a local file.
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.connect.ContactFlow("test", {
 *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name: "Test",
 *     description: "Test Contact Flow Description",
 *     type: "CONTACT_FLOW",
 *     content: JSON.stringify({
 *         Version: "2019-10-30",
 *         StartAction: "12345678-1234-1234-1234-123456789012",
 *         Actions: [
 *             {
 *                 Identifier: "12345678-1234-1234-1234-123456789012",
 *                 Type: "MessageParticipant",
 *                 Transitions: {
 *                     NextAction: "abcdef-abcd-abcd-abcd-abcdefghijkl",
 *                     Errors: [],
 *                     Conditions: [],
 *                 },
 *                 Parameters: {
 *                     Text: "Thanks for calling the sample flow!",
 *                 },
 *             },
 *             {
 *                 Identifier: "abcdef-abcd-abcd-abcd-abcdefghijkl",
 *                 Type: "DisconnectParticipant",
 *                 Transitions: {},
 *                 Parameters: {},
 *             },
 *         ],
 *     }),
 *     tags: {
 *         Name: "Test Contact Flow",
 *         Application: "Example",
 *         Method: "Create",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * test = aws.connect.ContactFlow("test",
 *     instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name="Test",
 *     description="Test Contact Flow Description",
 *     type="CONTACT_FLOW",
 *     content=json.dumps({
 *         "Version": "2019-10-30",
 *         "StartAction": "12345678-1234-1234-1234-123456789012",
 *         "Actions": [
 *             {
 *                 "Identifier": "12345678-1234-1234-1234-123456789012",
 *                 "Type": "MessageParticipant",
 *                 "Transitions": {
 *                     "NextAction": "abcdef-abcd-abcd-abcd-abcdefghijkl",
 *                     "Errors": [],
 *                     "Conditions": [],
 *                 },
 *                 "Parameters": {
 *                     "Text": "Thanks for calling the sample flow!",
 *                 },
 *             },
 *             {
 *                 "Identifier": "abcdef-abcd-abcd-abcd-abcdefghijkl",
 *                 "Type": "DisconnectParticipant",
 *                 "Transitions": {},
 *                 "Parameters": {},
 *             },
 *         ],
 *     }),
 *     tags={
 *         "Name": "Test Contact Flow",
 *         "Application": "Example",
 *         "Method": "Create",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Connect.ContactFlow("test", new()
 *     {
 *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *         Name = "Test",
 *         Description = "Test Contact Flow Description",
 *         Type = "CONTACT_FLOW",
 *         Content = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2019-10-30",
 *             ["StartAction"] = "12345678-1234-1234-1234-123456789012",
 *             ["Actions"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Identifier"] = "12345678-1234-1234-1234-123456789012",
 *                     ["Type"] = "MessageParticipant",
 *                     ["Transitions"] = new Dictionary<string, object?>
 *                     {
 *                         ["NextAction"] = "abcdef-abcd-abcd-abcd-abcdefghijkl",
 *                         ["Errors"] = new[]
 *                         {
 *                         },
 *                         ["Conditions"] = new[]
 *                         {
 *                         },
 *                     },
 *                     ["Parameters"] = new Dictionary<string, object?>
 *                     {
 *                         ["Text"] = "Thanks for calling the sample flow!",
 *                     },
 *                 },
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Identifier"] = "abcdef-abcd-abcd-abcd-abcdefghijkl",
 *                     ["Type"] = "DisconnectParticipant",
 *                     ["Transitions"] = new Dictionary<string, object?>
 *                     {
 *                     },
 *                     ["Parameters"] = new Dictionary<string, object?>
 *                     {
 *                     },
 *                 },
 *             },
 *         }),
 *         Tags =
 *         {
 *             { "Name", "Test Contact Flow" },
 *             { "Application", "Example" },
 *             { "Method", "Create" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version":     "2019-10-30",
 * 			"StartAction": "12345678-1234-1234-1234-123456789012",
 * 			"Actions": []interface{}{
 * 				map[string]interface{}{
 * 					"Identifier": "12345678-1234-1234-1234-123456789012",
 * 					"Type":       "MessageParticipant",
 * 					"Transitions": map[string]interface{}{
 * 						"NextAction": "abcdef-abcd-abcd-abcd-abcdefghijkl",
 * 						"Errors":     []interface{}{},
 * 						"Conditions": []interface{}{},
 * 					},
 * 					"Parameters": map[string]interface{}{
 * 						"Text": "Thanks for calling the sample flow!",
 * 					},
 * 				},
 * 				map[string]interface{}{
 * 					"Identifier":  "abcdef-abcd-abcd-abcd-abcdefghijkl",
 * 					"Type":        "DisconnectParticipant",
 * 					"Transitions": nil,
 * 					"Parameters":  nil,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		_, err = connect.NewContactFlow(ctx, "test", &connect.ContactFlowArgs{
 * 			InstanceId:  pulumi.String("aaaaaaaa-bbbb-cccc-dddd-111111111111"),
 * 			Name:        pulumi.String("Test"),
 * 			Description: pulumi.String("Test Contact Flow Description"),
 * 			Type:        pulumi.String("CONTACT_FLOW"),
 * 			Content:     pulumi.String(json0),
 * 			Tags: pulumi.StringMap{
 * 				"Name":        pulumi.String("Test Contact Flow"),
 * 				"Application": pulumi.String("Example"),
 * 				"Method":      pulumi.String("Create"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.ContactFlow;
 * import com.pulumi.aws.connect.ContactFlowArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ContactFlow("test", ContactFlowArgs.builder()
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .name("Test")
 *             .description("Test Contact Flow Description")
 *             .type("CONTACT_FLOW")
 *             .content(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2019-10-30"),
 *                     jsonProperty("StartAction", "12345678-1234-1234-1234-123456789012"),
 *                     jsonProperty("Actions", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("Identifier", "12345678-1234-1234-1234-123456789012"),
 *                             jsonProperty("Type", "MessageParticipant"),
 *                             jsonProperty("Transitions", jsonObject(
 *                                 jsonProperty("NextAction", "abcdef-abcd-abcd-abcd-abcdefghijkl"),
 *                                 jsonProperty("Errors", jsonArray(
 *                                 )),
 *                                 jsonProperty("Conditions", jsonArray(
 *                                 ))
 *                             )),
 *                             jsonProperty("Parameters", jsonObject(
 *                                 jsonProperty("Text", "Thanks for calling the sample flow!")
 *                             ))
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("Identifier", "abcdef-abcd-abcd-abcd-abcdefghijkl"),
 *                             jsonProperty("Type", "DisconnectParticipant"),
 *                             jsonProperty("Transitions", jsonObject(
 *                             )),
 *                             jsonProperty("Parameters", jsonObject(
 *                             ))
 *                         )
 *                     ))
 *                 )))
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "Test Contact Flow"),
 *                 Map.entry("Application", "Example"),
 *                 Map.entry("Method", "Create")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:connect:ContactFlow
 *     properties:
 *       instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
 *       name: Test
 *       description: Test Contact Flow Description
 *       type: CONTACT_FLOW
 *       content:
 *         fn::toJSON:
 *           Version: 2019-10-30
 *           StartAction: 12345678-1234-1234-1234-123456789012
 *           Actions:
 *             - Identifier: 12345678-1234-1234-1234-123456789012
 *               Type: MessageParticipant
 *               Transitions:
 *                 NextAction: abcdef-abcd-abcd-abcd-abcdefghijkl
 *                 Errors: []
 *                 Conditions: []
 *               Parameters:
 *                 Text: Thanks for calling the sample flow!
 *             - Identifier: abcdef-abcd-abcd-abcd-abcdefghijkl
 *               Type: DisconnectParticipant
 *               Transitions: {}
 *               Parameters: {}
 *       tags:
 *         Name: Test Contact Flow
 *         Application: Example
 *         Method: Create
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With External Content
 * Use the AWS CLI to extract Contact Flow Content:
 * ```console
 * % aws connect describe-contact-flow --instance-id 1b3c5d8-1b3c-1b3c-1b3c-1b3c5d81b3c5 --contact-flow-id c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5 --region us-west-2 | jq '.ContactFlow.Content | fromjson' > contact_flow.json
 * ```
 * Use the generated file as input:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const test = new aws.connect.ContactFlow("test", {
 *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name: "Test",
 *     description: "Test Contact Flow Description",
 *     type: "CONTACT_FLOW",
 *     filename: "contact_flow.json",
 *     contentHash: std.filebase64sha256({
 *         input: "contact_flow.json",
 *     }).then(invoke => invoke.result),
 *     tags: {
 *         Name: "Test Contact Flow",
 *         Application: "Example",
 *         Method: "Create",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * test = aws.connect.ContactFlow("test",
 *     instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name="Test",
 *     description="Test Contact Flow Description",
 *     type="CONTACT_FLOW",
 *     filename="contact_flow.json",
 *     content_hash=std.filebase64sha256(input="contact_flow.json").result,
 *     tags={
 *         "Name": "Test Contact Flow",
 *         "Application": "Example",
 *         "Method": "Create",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Connect.ContactFlow("test", new()
 *     {
 *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *         Name = "Test",
 *         Description = "Test Contact Flow Description",
 *         Type = "CONTACT_FLOW",
 *         Filename = "contact_flow.json",
 *         ContentHash = Std.Filebase64sha256.Invoke(new()
 *         {
 *             Input = "contact_flow.json",
 *         }).Apply(invoke => invoke.Result),
 *         Tags =
 *         {
 *             { "Name", "Test Contact Flow" },
 *             { "Application", "Example" },
 *             { "Method", "Create" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFilebase64sha256, err := std.Filebase64sha256(ctx, &std.Filebase64sha256Args{
 * 			Input: "contact_flow.json",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = connect.NewContactFlow(ctx, "test", &connect.ContactFlowArgs{
 * 			InstanceId:  pulumi.String("aaaaaaaa-bbbb-cccc-dddd-111111111111"),
 * 			Name:        pulumi.String("Test"),
 * 			Description: pulumi.String("Test Contact Flow Description"),
 * 			Type:        pulumi.String("CONTACT_FLOW"),
 * 			Filename:    pulumi.String("contact_flow.json"),
 * 			ContentHash: pulumi.String(invokeFilebase64sha256.Result),
 * 			Tags: pulumi.StringMap{
 * 				"Name":        pulumi.String("Test Contact Flow"),
 * 				"Application": pulumi.String("Example"),
 * 				"Method":      pulumi.String("Create"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.ContactFlow;
 * import com.pulumi.aws.connect.ContactFlowArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ContactFlow("test", ContactFlowArgs.builder()
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .name("Test")
 *             .description("Test Contact Flow Description")
 *             .type("CONTACT_FLOW")
 *             .filename("contact_flow.json")
 *             .contentHash(StdFunctions.filebase64sha256(Filebase64sha256Args.builder()
 *                 .input("contact_flow.json")
 *                 .build()).result())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "Test Contact Flow"),
 *                 Map.entry("Application", "Example"),
 *                 Map.entry("Method", "Create")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:connect:ContactFlow
 *     properties:
 *       instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
 *       name: Test
 *       description: Test Contact Flow Description
 *       type: CONTACT_FLOW
 *       filename: contact_flow.json
 *       contentHash:
 *         fn::invoke:
 *           Function: std:filebase64sha256
 *           Arguments:
 *             input: contact_flow.json
 *           Return: result
 *       tags:
 *         Name: Test Contact Flow
 *         Application: Example
 *         Method: Create
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amazon Connect Contact Flows using the `instance_id` and `contact_flow_id` separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:connect/contactFlow:ContactFlow example f1288a1f-6193-445a-b47e-af739b2:c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5
 * ```
 * @property content Specifies the content of the Contact Flow, provided as a JSON string, written in Amazon Connect Contact Flow Language. If defined, the `filename` argument cannot be used.
 * @property contentHash Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the Contact Flow source specified with `filename`.
 * @property description Specifies the description of the Contact Flow.
 * @property filename The path to the Contact Flow source within the local filesystem. Conflicts with `content`.
 * @property instanceId Specifies the identifier of the hosting Amazon Connect Instance.
 * @property name Specifies the name of the Contact Flow.
 * @property tags Tags to apply to the Contact Flow. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type Specifies the type of the Contact Flow. Defaults to `CONTACT_FLOW`. Allowed Values are: `CONTACT_FLOW`, `CUSTOMER_QUEUE`, `CUSTOMER_HOLD`, `CUSTOMER_WHISPER`, `AGENT_HOLD`, `AGENT_WHISPER`, `OUTBOUND_WHISPER`, `AGENT_TRANSFER`, `QUEUE_TRANSFER`.
 */
public data class ContactFlowArgs(
    public val content: Output<String>? = null,
    public val contentHash: Output<String>? = null,
    public val description: Output<String>? = null,
    public val filename: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.ContactFlowArgs> {
    override fun toJava(): com.pulumi.aws.connect.ContactFlowArgs =
        com.pulumi.aws.connect.ContactFlowArgs.builder()
            .content(content?.applyValue({ args0 -> args0 }))
            .contentHash(contentHash?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .filename(filename?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContactFlowArgs].
 */
@PulumiTagMarker
public class ContactFlowArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var contentHash: Output<String>? = null

    private var description: Output<String>? = null

    private var filename: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value Specifies the content of the Contact Flow, provided as a JSON string, written in Amazon Connect Contact Flow Language. If defined, the `filename` argument cannot be used.
     */
    @JvmName("fpgujsmkjrsytsei")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the Contact Flow source specified with `filename`.
     */
    @JvmName("xvdetjfoptjocbxf")
    public suspend fun contentHash(`value`: Output<String>) {
        this.contentHash = value
    }

    /**
     * @param value Specifies the description of the Contact Flow.
     */
    @JvmName("eqpnchqmwrrwvyyi")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The path to the Contact Flow source within the local filesystem. Conflicts with `content`.
     */
    @JvmName("cxjovkeymkhkwqjx")
    public suspend fun filename(`value`: Output<String>) {
        this.filename = value
    }

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("omjmxqeaulggokoj")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value Specifies the name of the Contact Flow.
     */
    @JvmName("jnulchsmxxiwkngi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Tags to apply to the Contact Flow. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dqocyipjjjpotltm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the type of the Contact Flow. Defaults to `CONTACT_FLOW`. Allowed Values are: `CONTACT_FLOW`, `CUSTOMER_QUEUE`, `CUSTOMER_HOLD`, `CUSTOMER_WHISPER`, `AGENT_HOLD`, `AGENT_WHISPER`, `OUTBOUND_WHISPER`, `AGENT_TRANSFER`, `QUEUE_TRANSFER`.
     */
    @JvmName("qiktuwxlonkycnfo")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the content of the Contact Flow, provided as a JSON string, written in Amazon Connect Contact Flow Language. If defined, the `filename` argument cannot be used.
     */
    @JvmName("snimbntcobwornqw")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the Contact Flow source specified with `filename`.
     */
    @JvmName("fepkcrtcnfkjyoxt")
    public suspend fun contentHash(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentHash = mapped
    }

    /**
     * @param value Specifies the description of the Contact Flow.
     */
    @JvmName("ejhwfysnlbnykywy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The path to the Contact Flow source within the local filesystem. Conflicts with `content`.
     */
    @JvmName("ghkkwqjtqpxgbqth")
    public suspend fun filename(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filename = mapped
    }

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("seiulgykodppdqme")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value Specifies the name of the Contact Flow.
     */
    @JvmName("oejjumdipttfkdyw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Tags to apply to the Contact Flow. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pjyawlwqyhbqrwkw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to apply to the Contact Flow. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("atfrgsdtnqmrdhav")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies the type of the Contact Flow. Defaults to `CONTACT_FLOW`. Allowed Values are: `CONTACT_FLOW`, `CUSTOMER_QUEUE`, `CUSTOMER_HOLD`, `CUSTOMER_WHISPER`, `AGENT_HOLD`, `AGENT_WHISPER`, `OUTBOUND_WHISPER`, `AGENT_TRANSFER`, `QUEUE_TRANSFER`.
     */
    @JvmName("rltninxhjefxydfx")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ContactFlowArgs = ContactFlowArgs(
        content = content,
        contentHash = contentHash,
        description = description,
        filename = filename,
        instanceId = instanceId,
        name = name,
        tags = tags,
        type = type,
    )
}
