@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.kotlin.outputs.HoursOfOperationConfig
import com.pulumi.aws.connect.kotlin.outputs.HoursOfOperationConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [HoursOfOperation].
 */
@PulumiTagMarker
public class HoursOfOperationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HoursOfOperationArgs = HoursOfOperationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HoursOfOperationArgsBuilder.() -> Unit) {
        val builder = HoursOfOperationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HoursOfOperation {
        val builtJavaResource = com.pulumi.aws.connect.HoursOfOperation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return HoursOfOperation(builtJavaResource)
    }
}

/**
 * Provides an Amazon Connect Hours of Operation resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.connect.HoursOfOperation("test", {
 *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name: "Office Hours",
 *     description: "Monday office hours",
 *     timeZone: "EST",
 *     configs: [
 *         {
 *             day: "MONDAY",
 *             endTime: {
 *                 hours: 23,
 *                 minutes: 8,
 *             },
 *             startTime: {
 *                 hours: 8,
 *                 minutes: 0,
 *             },
 *         },
 *         {
 *             day: "TUESDAY",
 *             endTime: {
 *                 hours: 21,
 *                 minutes: 0,
 *             },
 *             startTime: {
 *                 hours: 9,
 *                 minutes: 0,
 *             },
 *         },
 *     ],
 *     tags: {
 *         Name: "Example Hours of Operation",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.connect.HoursOfOperation("test",
 *     instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name="Office Hours",
 *     description="Monday office hours",
 *     time_zone="EST",
 *     configs=[
 *         {
 *             "day": "MONDAY",
 *             "end_time": {
 *                 "hours": 23,
 *                 "minutes": 8,
 *             },
 *             "start_time": {
 *                 "hours": 8,
 *                 "minutes": 0,
 *             },
 *         },
 *         {
 *             "day": "TUESDAY",
 *             "end_time": {
 *                 "hours": 21,
 *                 "minutes": 0,
 *             },
 *             "start_time": {
 *                 "hours": 9,
 *                 "minutes": 0,
 *             },
 *         },
 *     ],
 *     tags={
 *         "Name": "Example Hours of Operation",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Connect.HoursOfOperation("test", new()
 *     {
 *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *         Name = "Office Hours",
 *         Description = "Monday office hours",
 *         TimeZone = "EST",
 *         Configs = new[]
 *         {
 *             new Aws.Connect.Inputs.HoursOfOperationConfigArgs
 *             {
 *                 Day = "MONDAY",
 *                 EndTime = new Aws.Connect.Inputs.HoursOfOperationConfigEndTimeArgs
 *                 {
 *                     Hours = 23,
 *                     Minutes = 8,
 *                 },
 *                 StartTime = new Aws.Connect.Inputs.HoursOfOperationConfigStartTimeArgs
 *                 {
 *                     Hours = 8,
 *                     Minutes = 0,
 *                 },
 *             },
 *             new Aws.Connect.Inputs.HoursOfOperationConfigArgs
 *             {
 *                 Day = "TUESDAY",
 *                 EndTime = new Aws.Connect.Inputs.HoursOfOperationConfigEndTimeArgs
 *                 {
 *                     Hours = 21,
 *                     Minutes = 0,
 *                 },
 *                 StartTime = new Aws.Connect.Inputs.HoursOfOperationConfigStartTimeArgs
 *                 {
 *                     Hours = 9,
 *                     Minutes = 0,
 *                 },
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Name", "Example Hours of Operation" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewHoursOfOperation(ctx, "test", &connect.HoursOfOperationArgs{
 * 			InstanceId:  pulumi.String("aaaaaaaa-bbbb-cccc-dddd-111111111111"),
 * 			Name:        pulumi.String("Office Hours"),
 * 			Description: pulumi.String("Monday office hours"),
 * 			TimeZone:    pulumi.String("EST"),
 * 			Configs: connect.HoursOfOperationConfigArray{
 * 				&connect.HoursOfOperationConfigArgs{
 * 					Day: pulumi.String("MONDAY"),
 * 					EndTime: &connect.HoursOfOperationConfigEndTimeArgs{
 * 						Hours:   pulumi.Int(23),
 * 						Minutes: pulumi.Int(8),
 * 					},
 * 					StartTime: &connect.HoursOfOperationConfigStartTimeArgs{
 * 						Hours:   pulumi.Int(8),
 * 						Minutes: pulumi.Int(0),
 * 					},
 * 				},
 * 				&connect.HoursOfOperationConfigArgs{
 * 					Day: pulumi.String("TUESDAY"),
 * 					EndTime: &connect.HoursOfOperationConfigEndTimeArgs{
 * 						Hours:   pulumi.Int(21),
 * 						Minutes: pulumi.Int(0),
 * 					},
 * 					StartTime: &connect.HoursOfOperationConfigStartTimeArgs{
 * 						Hours:   pulumi.Int(9),
 * 						Minutes: pulumi.Int(0),
 * 					},
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("Example Hours of Operation"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.HoursOfOperation;
 * import com.pulumi.aws.connect.HoursOfOperationArgs;
 * import com.pulumi.aws.connect.inputs.HoursOfOperationConfigArgs;
 * import com.pulumi.aws.connect.inputs.HoursOfOperationConfigEndTimeArgs;
 * import com.pulumi.aws.connect.inputs.HoursOfOperationConfigStartTimeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new HoursOfOperation("test", HoursOfOperationArgs.builder()
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .name("Office Hours")
 *             .description("Monday office hours")
 *             .timeZone("EST")
 *             .configs(
 *                 HoursOfOperationConfigArgs.builder()
 *                     .day("MONDAY")
 *                     .endTime(HoursOfOperationConfigEndTimeArgs.builder()
 *                         .hours(23)
 *                         .minutes(8)
 *                         .build())
 *                     .startTime(HoursOfOperationConfigStartTimeArgs.builder()
 *                         .hours(8)
 *                         .minutes(0)
 *                         .build())
 *                     .build(),
 *                 HoursOfOperationConfigArgs.builder()
 *                     .day("TUESDAY")
 *                     .endTime(HoursOfOperationConfigEndTimeArgs.builder()
 *                         .hours(21)
 *                         .minutes(0)
 *                         .build())
 *                     .startTime(HoursOfOperationConfigStartTimeArgs.builder()
 *                         .hours(9)
 *                         .minutes(0)
 *                         .build())
 *                     .build())
 *             .tags(Map.of("Name", "Example Hours of Operation"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:connect:HoursOfOperation
 *     properties:
 *       instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
 *       name: Office Hours
 *       description: Monday office hours
 *       timeZone: EST
 *       configs:
 *         - day: MONDAY
 *           endTime:
 *             hours: 23
 *             minutes: 8
 *           startTime:
 *             hours: 8
 *             minutes: 0
 *         - day: TUESDAY
 *           endTime:
 *             hours: 21
 *             minutes: 0
 *           startTime:
 *             hours: 9
 *             minutes: 0
 *       tags:
 *         Name: Example Hours of Operation
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amazon Connect Hours of Operations using the `instance_id` and `hours_of_operation_id` separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:connect/hoursOfOperation:HoursOfOperation example f1288a1f-6193-445a-b47e-af739b2:c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5
 * ```
 */
public class HoursOfOperation internal constructor(
    override val javaResource: com.pulumi.aws.connect.HoursOfOperation,
) : KotlinCustomResource(javaResource, HoursOfOperationMapper) {
    /**
     * The Amazon Resource Name (ARN) of the Hours of Operation.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * One or more config blocks which define the configuration information for the hours of operation: day, start time, and end time . Config blocks are documented below.
     */
    public val configs: Output<List<HoursOfOperationConfig>>
        get() = javaResource.configs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * Specifies the description of the Hours of Operation.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The identifier for the hours of operation.
     */
    public val hoursOfOperationId: Output<String>
        get() = javaResource.hoursOfOperationId().applyValue({ args0 -> args0 })

    /**
     * Specifies the identifier of the hosting Amazon Connect Instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * Specifies the name of the Hours of Operation.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Tags to apply to the Hours of Operation. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Specifies the time zone of the Hours of Operation.
     */
    public val timeZone: Output<String>
        get() = javaResource.timeZone().applyValue({ args0 -> args0 })
}

public object HoursOfOperationMapper : ResourceMapper<HoursOfOperation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.connect.HoursOfOperation::class == javaResource::class

    override fun map(javaResource: Resource): HoursOfOperation = HoursOfOperation(
        javaResource as
            com.pulumi.aws.connect.HoursOfOperation,
    )
}

/**
 * @see [HoursOfOperation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HoursOfOperation].
 */
public suspend fun hoursOfOperation(
    name: String,
    block: suspend HoursOfOperationResourceBuilder.() -> Unit,
): HoursOfOperation {
    val builder = HoursOfOperationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HoursOfOperation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hoursOfOperation(name: String): HoursOfOperation {
    val builder = HoursOfOperationResourceBuilder()
    builder.name(name)
    return builder.build()
}
