@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.HoursOfOperationArgs.builder
import com.pulumi.aws.connect.kotlin.inputs.HoursOfOperationConfigArgs
import com.pulumi.aws.connect.kotlin.inputs.HoursOfOperationConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Connect Hours of Operation resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.connect.HoursOfOperation("test", {
 *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name: "Office Hours",
 *     description: "Monday office hours",
 *     timeZone: "EST",
 *     configs: [
 *         {
 *             day: "MONDAY",
 *             endTime: {
 *                 hours: 23,
 *                 minutes: 8,
 *             },
 *             startTime: {
 *                 hours: 8,
 *                 minutes: 0,
 *             },
 *         },
 *         {
 *             day: "TUESDAY",
 *             endTime: {
 *                 hours: 21,
 *                 minutes: 0,
 *             },
 *             startTime: {
 *                 hours: 9,
 *                 minutes: 0,
 *             },
 *         },
 *     ],
 *     tags: {
 *         Name: "Example Hours of Operation",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.connect.HoursOfOperation("test",
 *     instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name="Office Hours",
 *     description="Monday office hours",
 *     time_zone="EST",
 *     configs=[
 *         {
 *             "day": "MONDAY",
 *             "end_time": {
 *                 "hours": 23,
 *                 "minutes": 8,
 *             },
 *             "start_time": {
 *                 "hours": 8,
 *                 "minutes": 0,
 *             },
 *         },
 *         {
 *             "day": "TUESDAY",
 *             "end_time": {
 *                 "hours": 21,
 *                 "minutes": 0,
 *             },
 *             "start_time": {
 *                 "hours": 9,
 *                 "minutes": 0,
 *             },
 *         },
 *     ],
 *     tags={
 *         "Name": "Example Hours of Operation",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Connect.HoursOfOperation("test", new()
 *     {
 *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *         Name = "Office Hours",
 *         Description = "Monday office hours",
 *         TimeZone = "EST",
 *         Configs = new[]
 *         {
 *             new Aws.Connect.Inputs.HoursOfOperationConfigArgs
 *             {
 *                 Day = "MONDAY",
 *                 EndTime = new Aws.Connect.Inputs.HoursOfOperationConfigEndTimeArgs
 *                 {
 *                     Hours = 23,
 *                     Minutes = 8,
 *                 },
 *                 StartTime = new Aws.Connect.Inputs.HoursOfOperationConfigStartTimeArgs
 *                 {
 *                     Hours = 8,
 *                     Minutes = 0,
 *                 },
 *             },
 *             new Aws.Connect.Inputs.HoursOfOperationConfigArgs
 *             {
 *                 Day = "TUESDAY",
 *                 EndTime = new Aws.Connect.Inputs.HoursOfOperationConfigEndTimeArgs
 *                 {
 *                     Hours = 21,
 *                     Minutes = 0,
 *                 },
 *                 StartTime = new Aws.Connect.Inputs.HoursOfOperationConfigStartTimeArgs
 *                 {
 *                     Hours = 9,
 *                     Minutes = 0,
 *                 },
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Name", "Example Hours of Operation" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewHoursOfOperation(ctx, "test", &connect.HoursOfOperationArgs{
 * 			InstanceId:  pulumi.String("aaaaaaaa-bbbb-cccc-dddd-111111111111"),
 * 			Name:        pulumi.String("Office Hours"),
 * 			Description: pulumi.String("Monday office hours"),
 * 			TimeZone:    pulumi.String("EST"),
 * 			Configs: connect.HoursOfOperationConfigArray{
 * 				&connect.HoursOfOperationConfigArgs{
 * 					Day: pulumi.String("MONDAY"),
 * 					EndTime: &connect.HoursOfOperationConfigEndTimeArgs{
 * 						Hours:   pulumi.Int(23),
 * 						Minutes: pulumi.Int(8),
 * 					},
 * 					StartTime: &connect.HoursOfOperationConfigStartTimeArgs{
 * 						Hours:   pulumi.Int(8),
 * 						Minutes: pulumi.Int(0),
 * 					},
 * 				},
 * 				&connect.HoursOfOperationConfigArgs{
 * 					Day: pulumi.String("TUESDAY"),
 * 					EndTime: &connect.HoursOfOperationConfigEndTimeArgs{
 * 						Hours:   pulumi.Int(21),
 * 						Minutes: pulumi.Int(0),
 * 					},
 * 					StartTime: &connect.HoursOfOperationConfigStartTimeArgs{
 * 						Hours:   pulumi.Int(9),
 * 						Minutes: pulumi.Int(0),
 * 					},
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("Example Hours of Operation"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.HoursOfOperation;
 * import com.pulumi.aws.connect.HoursOfOperationArgs;
 * import com.pulumi.aws.connect.inputs.HoursOfOperationConfigArgs;
 * import com.pulumi.aws.connect.inputs.HoursOfOperationConfigEndTimeArgs;
 * import com.pulumi.aws.connect.inputs.HoursOfOperationConfigStartTimeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new HoursOfOperation("test", HoursOfOperationArgs.builder()
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .name("Office Hours")
 *             .description("Monday office hours")
 *             .timeZone("EST")
 *             .configs(
 *                 HoursOfOperationConfigArgs.builder()
 *                     .day("MONDAY")
 *                     .endTime(HoursOfOperationConfigEndTimeArgs.builder()
 *                         .hours(23)
 *                         .minutes(8)
 *                         .build())
 *                     .startTime(HoursOfOperationConfigStartTimeArgs.builder()
 *                         .hours(8)
 *                         .minutes(0)
 *                         .build())
 *                     .build(),
 *                 HoursOfOperationConfigArgs.builder()
 *                     .day("TUESDAY")
 *                     .endTime(HoursOfOperationConfigEndTimeArgs.builder()
 *                         .hours(21)
 *                         .minutes(0)
 *                         .build())
 *                     .startTime(HoursOfOperationConfigStartTimeArgs.builder()
 *                         .hours(9)
 *                         .minutes(0)
 *                         .build())
 *                     .build())
 *             .tags(Map.of("Name", "Example Hours of Operation"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:connect:HoursOfOperation
 *     properties:
 *       instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
 *       name: Office Hours
 *       description: Monday office hours
 *       timeZone: EST
 *       configs:
 *         - day: MONDAY
 *           endTime:
 *             hours: 23
 *             minutes: 8
 *           startTime:
 *             hours: 8
 *             minutes: 0
 *         - day: TUESDAY
 *           endTime:
 *             hours: 21
 *             minutes: 0
 *           startTime:
 *             hours: 9
 *             minutes: 0
 *       tags:
 *         Name: Example Hours of Operation
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amazon Connect Hours of Operations using the `instance_id` and `hours_of_operation_id` separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:connect/hoursOfOperation:HoursOfOperation example f1288a1f-6193-445a-b47e-af739b2:c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5
 * ```
 * @property configs One or more config blocks which define the configuration information for the hours of operation: day, start time, and end time . Config blocks are documented below.
 * @property description Specifies the description of the Hours of Operation.
 * @property instanceId Specifies the identifier of the hosting Amazon Connect Instance.
 * @property name Specifies the name of the Hours of Operation.
 * @property tags Tags to apply to the Hours of Operation. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeZone Specifies the time zone of the Hours of Operation.
 */
public data class HoursOfOperationArgs(
    public val configs: Output<List<HoursOfOperationConfigArgs>>? = null,
    public val description: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeZone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.HoursOfOperationArgs> {
    override fun toJava(): com.pulumi.aws.connect.HoursOfOperationArgs =
        com.pulumi.aws.connect.HoursOfOperationArgs.builder()
            .configs(
                configs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HoursOfOperationArgs].
 */
@PulumiTagMarker
public class HoursOfOperationArgsBuilder internal constructor() {
    private var configs: Output<List<HoursOfOperationConfigArgs>>? = null

    private var description: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeZone: Output<String>? = null

    /**
     * @param value One or more config blocks which define the configuration information for the hours of operation: day, start time, and end time . Config blocks are documented below.
     */
    @JvmName("chtnpvdchbrcxjxx")
    public suspend fun configs(`value`: Output<List<HoursOfOperationConfigArgs>>) {
        this.configs = value
    }

    @JvmName("jevnbmnijnodbjsh")
    public suspend fun configs(vararg values: Output<HoursOfOperationConfigArgs>) {
        this.configs = Output.all(values.asList())
    }

    /**
     * @param values One or more config blocks which define the configuration information for the hours of operation: day, start time, and end time . Config blocks are documented below.
     */
    @JvmName("mpkbmyyovahwcoxb")
    public suspend fun configs(values: List<Output<HoursOfOperationConfigArgs>>) {
        this.configs = Output.all(values)
    }

    /**
     * @param value Specifies the description of the Hours of Operation.
     */
    @JvmName("ibhlqkvmgncryppd")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("jmbnucrvrremxpdv")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value Specifies the name of the Hours of Operation.
     */
    @JvmName("gseybdistoivynho")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Tags to apply to the Hours of Operation. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kavomruililwtilf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the time zone of the Hours of Operation.
     */
    @JvmName("xiaxsutiweqqiwfs")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value One or more config blocks which define the configuration information for the hours of operation: day, start time, and end time . Config blocks are documented below.
     */
    @JvmName("cwvykyctsdvhbhfe")
    public suspend fun configs(`value`: List<HoursOfOperationConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configs = mapped
    }

    /**
     * @param argument One or more config blocks which define the configuration information for the hours of operation: day, start time, and end time . Config blocks are documented below.
     */
    @JvmName("bdhrwkisucghrmls")
    public suspend fun configs(argument: List<suspend HoursOfOperationConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HoursOfOperationConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configs = mapped
    }

    /**
     * @param argument One or more config blocks which define the configuration information for the hours of operation: day, start time, and end time . Config blocks are documented below.
     */
    @JvmName("ohmilheyfyaalyex")
    public suspend fun configs(vararg argument: suspend HoursOfOperationConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            HoursOfOperationConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configs = mapped
    }

    /**
     * @param argument One or more config blocks which define the configuration information for the hours of operation: day, start time, and end time . Config blocks are documented below.
     */
    @JvmName("dlfjxlqwcnouqgpt")
    public suspend fun configs(argument: suspend HoursOfOperationConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(HoursOfOperationConfigArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.configs = mapped
    }

    /**
     * @param values One or more config blocks which define the configuration information for the hours of operation: day, start time, and end time . Config blocks are documented below.
     */
    @JvmName("vvchnxgholvclqni")
    public suspend fun configs(vararg values: HoursOfOperationConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configs = mapped
    }

    /**
     * @param value Specifies the description of the Hours of Operation.
     */
    @JvmName("jdxqlwskcdoatyom")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("jonxcdyfidbrflso")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value Specifies the name of the Hours of Operation.
     */
    @JvmName("hiaexwmdrxvefvbc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Tags to apply to the Hours of Operation. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("efwexwfwytadttme")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to apply to the Hours of Operation. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wlrolqonbpowcnuv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies the time zone of the Hours of Operation.
     */
    @JvmName("rblnsnlshnrvshsd")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    internal fun build(): HoursOfOperationArgs = HoursOfOperationArgs(
        configs = configs,
        description = description,
        instanceId = instanceId,
        name = name,
        tags = tags,
        timeZone = timeZone,
    )
}
