@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.InstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Connect instance resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * !> **WARN:** Amazon Connect enforces a limit of [100 combined instance creation and deletions every 30 days](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits).  For example, if you create 80 instances and delete 20 of them, you must wait 30 days to create or delete another instance.  Use care when creating or deleting instances.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.connect.Instance("test", {
 *     identityManagementType: "CONNECT_MANAGED",
 *     inboundCallsEnabled: true,
 *     instanceAlias: "friendly-name-connect",
 *     outboundCallsEnabled: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.connect.Instance("test",
 *     identity_management_type="CONNECT_MANAGED",
 *     inbound_calls_enabled=True,
 *     instance_alias="friendly-name-connect",
 *     outbound_calls_enabled=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Connect.Instance("test", new()
 *     {
 *         IdentityManagementType = "CONNECT_MANAGED",
 *         InboundCallsEnabled = true,
 *         InstanceAlias = "friendly-name-connect",
 *         OutboundCallsEnabled = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewInstance(ctx, "test", &connect.InstanceArgs{
 * 			IdentityManagementType: pulumi.String("CONNECT_MANAGED"),
 * 			InboundCallsEnabled:    pulumi.Bool(true),
 * 			InstanceAlias:          pulumi.String("friendly-name-connect"),
 * 			OutboundCallsEnabled:   pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.Instance;
 * import com.pulumi.aws.connect.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Instance("test", InstanceArgs.builder()
 *             .identityManagementType("CONNECT_MANAGED")
 *             .inboundCallsEnabled(true)
 *             .instanceAlias("friendly-name-connect")
 *             .outboundCallsEnabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:connect:Instance
 *     properties:
 *       identityManagementType: CONNECT_MANAGED
 *       inboundCallsEnabled: true
 *       instanceAlias: friendly-name-connect
 *       outboundCallsEnabled: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Existing Active Directory
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.connect.Instance("test", {
 *     directoryId: testAwsDirectoryServiceDirectory.id,
 *     identityManagementType: "EXISTING_DIRECTORY",
 *     inboundCallsEnabled: true,
 *     instanceAlias: "friendly-name-connect",
 *     outboundCallsEnabled: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.connect.Instance("test",
 *     directory_id=test_aws_directory_service_directory["id"],
 *     identity_management_type="EXISTING_DIRECTORY",
 *     inbound_calls_enabled=True,
 *     instance_alias="friendly-name-connect",
 *     outbound_calls_enabled=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Connect.Instance("test", new()
 *     {
 *         DirectoryId = testAwsDirectoryServiceDirectory.Id,
 *         IdentityManagementType = "EXISTING_DIRECTORY",
 *         InboundCallsEnabled = true,
 *         InstanceAlias = "friendly-name-connect",
 *         OutboundCallsEnabled = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewInstance(ctx, "test", &connect.InstanceArgs{
 * 			DirectoryId:            pulumi.Any(testAwsDirectoryServiceDirectory.Id),
 * 			IdentityManagementType: pulumi.String("EXISTING_DIRECTORY"),
 * 			InboundCallsEnabled:    pulumi.Bool(true),
 * 			InstanceAlias:          pulumi.String("friendly-name-connect"),
 * 			OutboundCallsEnabled:   pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.Instance;
 * import com.pulumi.aws.connect.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Instance("test", InstanceArgs.builder()
 *             .directoryId(testAwsDirectoryServiceDirectory.id())
 *             .identityManagementType("EXISTING_DIRECTORY")
 *             .inboundCallsEnabled(true)
 *             .instanceAlias("friendly-name-connect")
 *             .outboundCallsEnabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:connect:Instance
 *     properties:
 *       directoryId: ${testAwsDirectoryServiceDirectory.id}
 *       identityManagementType: EXISTING_DIRECTORY
 *       inboundCallsEnabled: true
 *       instanceAlias: friendly-name-connect
 *       outboundCallsEnabled: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With SAML
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.connect.Instance("test", {
 *     identityManagementType: "SAML",
 *     inboundCallsEnabled: true,
 *     instanceAlias: "friendly-name-connect",
 *     outboundCallsEnabled: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.connect.Instance("test",
 *     identity_management_type="SAML",
 *     inbound_calls_enabled=True,
 *     instance_alias="friendly-name-connect",
 *     outbound_calls_enabled=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Connect.Instance("test", new()
 *     {
 *         IdentityManagementType = "SAML",
 *         InboundCallsEnabled = true,
 *         InstanceAlias = "friendly-name-connect",
 *         OutboundCallsEnabled = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewInstance(ctx, "test", &connect.InstanceArgs{
 * 			IdentityManagementType: pulumi.String("SAML"),
 * 			InboundCallsEnabled:    pulumi.Bool(true),
 * 			InstanceAlias:          pulumi.String("friendly-name-connect"),
 * 			OutboundCallsEnabled:   pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.Instance;
 * import com.pulumi.aws.connect.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Instance("test", InstanceArgs.builder()
 *             .identityManagementType("SAML")
 *             .inboundCallsEnabled(true)
 *             .instanceAlias("friendly-name-connect")
 *             .outboundCallsEnabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:connect:Instance
 *     properties:
 *       identityManagementType: SAML
 *       inboundCallsEnabled: true
 *       instanceAlias: friendly-name-connect
 *       outboundCallsEnabled: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Connect instances using the `id`. For example:
 * ```sh
 * $ pulumi import aws:connect/instance:Instance example f1288a1f-6193-445a-b47e-af739b2
 * ```
 * @property autoResolveBestVoicesEnabled Specifies whether auto resolve best voices is enabled. Defaults to `true`.
 * @property contactFlowLogsEnabled Specifies whether contact flow logs are enabled. Defaults to `false`.
 * @property contactLensEnabled Specifies whether contact lens is enabled. Defaults to `true`.
 * @property directoryId The identifier for the directory if identity_management_type is `EXISTING_DIRECTORY`.
 * @property earlyMediaEnabled Specifies whether early media for outbound calls is enabled . Defaults to `true` if outbound calls is enabled.
 * @property identityManagementType Specifies the identity management type attached to the instance. Allowed Values are: `SAML`, `CONNECT_MANAGED`, `EXISTING_DIRECTORY`.
 * @property inboundCallsEnabled Specifies whether inbound calls are enabled.
 * @property instanceAlias Specifies the name of the instance. Required if `directory_id` not specified.
 * @property multiPartyConferenceEnabled Specifies whether multi-party calls/conference is enabled. Defaults to `false`.
 * @property outboundCallsEnabled Specifies whether outbound calls are enabled.
 * <!-- * `use_custom_tts_voices` - (Optional) Whether use custom tts voices is enabled. Defaults to `false` -->
 */
public data class InstanceArgs(
    public val autoResolveBestVoicesEnabled: Output<Boolean>? = null,
    public val contactFlowLogsEnabled: Output<Boolean>? = null,
    public val contactLensEnabled: Output<Boolean>? = null,
    public val directoryId: Output<String>? = null,
    public val earlyMediaEnabled: Output<Boolean>? = null,
    public val identityManagementType: Output<String>? = null,
    public val inboundCallsEnabled: Output<Boolean>? = null,
    public val instanceAlias: Output<String>? = null,
    public val multiPartyConferenceEnabled: Output<Boolean>? = null,
    public val outboundCallsEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.InstanceArgs> {
    override fun toJava(): com.pulumi.aws.connect.InstanceArgs =
        com.pulumi.aws.connect.InstanceArgs.builder()
            .autoResolveBestVoicesEnabled(autoResolveBestVoicesEnabled?.applyValue({ args0 -> args0 }))
            .contactFlowLogsEnabled(contactFlowLogsEnabled?.applyValue({ args0 -> args0 }))
            .contactLensEnabled(contactLensEnabled?.applyValue({ args0 -> args0 }))
            .directoryId(directoryId?.applyValue({ args0 -> args0 }))
            .earlyMediaEnabled(earlyMediaEnabled?.applyValue({ args0 -> args0 }))
            .identityManagementType(identityManagementType?.applyValue({ args0 -> args0 }))
            .inboundCallsEnabled(inboundCallsEnabled?.applyValue({ args0 -> args0 }))
            .instanceAlias(instanceAlias?.applyValue({ args0 -> args0 }))
            .multiPartyConferenceEnabled(multiPartyConferenceEnabled?.applyValue({ args0 -> args0 }))
            .outboundCallsEnabled(outboundCallsEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var autoResolveBestVoicesEnabled: Output<Boolean>? = null

    private var contactFlowLogsEnabled: Output<Boolean>? = null

    private var contactLensEnabled: Output<Boolean>? = null

    private var directoryId: Output<String>? = null

    private var earlyMediaEnabled: Output<Boolean>? = null

    private var identityManagementType: Output<String>? = null

    private var inboundCallsEnabled: Output<Boolean>? = null

    private var instanceAlias: Output<String>? = null

    private var multiPartyConferenceEnabled: Output<Boolean>? = null

    private var outboundCallsEnabled: Output<Boolean>? = null

    /**
     * @param value Specifies whether auto resolve best voices is enabled. Defaults to `true`.
     */
    @JvmName("snakskuhdlrcingj")
    public suspend fun autoResolveBestVoicesEnabled(`value`: Output<Boolean>) {
        this.autoResolveBestVoicesEnabled = value
    }

    /**
     * @param value Specifies whether contact flow logs are enabled. Defaults to `false`.
     */
    @JvmName("unhvlhoalmgmjbul")
    public suspend fun contactFlowLogsEnabled(`value`: Output<Boolean>) {
        this.contactFlowLogsEnabled = value
    }

    /**
     * @param value Specifies whether contact lens is enabled. Defaults to `true`.
     */
    @JvmName("pymrkloaebspxqks")
    public suspend fun contactLensEnabled(`value`: Output<Boolean>) {
        this.contactLensEnabled = value
    }

    /**
     * @param value The identifier for the directory if identity_management_type is `EXISTING_DIRECTORY`.
     */
    @JvmName("rpdjxtdaymnyhilj")
    public suspend fun directoryId(`value`: Output<String>) {
        this.directoryId = value
    }

    /**
     * @param value Specifies whether early media for outbound calls is enabled . Defaults to `true` if outbound calls is enabled.
     */
    @JvmName("kmbgdvoiwnyfdwma")
    public suspend fun earlyMediaEnabled(`value`: Output<Boolean>) {
        this.earlyMediaEnabled = value
    }

    /**
     * @param value Specifies the identity management type attached to the instance. Allowed Values are: `SAML`, `CONNECT_MANAGED`, `EXISTING_DIRECTORY`.
     */
    @JvmName("nqdxfrlmqagtmdvg")
    public suspend fun identityManagementType(`value`: Output<String>) {
        this.identityManagementType = value
    }

    /**
     * @param value Specifies whether inbound calls are enabled.
     */
    @JvmName("wkfjyvnsxpvhlyvr")
    public suspend fun inboundCallsEnabled(`value`: Output<Boolean>) {
        this.inboundCallsEnabled = value
    }

    /**
     * @param value Specifies the name of the instance. Required if `directory_id` not specified.
     */
    @JvmName("epvdemqgkiuolhcj")
    public suspend fun instanceAlias(`value`: Output<String>) {
        this.instanceAlias = value
    }

    /**
     * @param value Specifies whether multi-party calls/conference is enabled. Defaults to `false`.
     */
    @JvmName("ujodwovesnvaljev")
    public suspend fun multiPartyConferenceEnabled(`value`: Output<Boolean>) {
        this.multiPartyConferenceEnabled = value
    }

    /**
     * @param value Specifies whether outbound calls are enabled.
     * <!-- * `use_custom_tts_voices` - (Optional) Whether use custom tts voices is enabled. Defaults to `false` -->
     */
    @JvmName("mmwqffrxvbcboqbm")
    public suspend fun outboundCallsEnabled(`value`: Output<Boolean>) {
        this.outboundCallsEnabled = value
    }

    /**
     * @param value Specifies whether auto resolve best voices is enabled. Defaults to `true`.
     */
    @JvmName("mukqqwnfhsvqmtod")
    public suspend fun autoResolveBestVoicesEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoResolveBestVoicesEnabled = mapped
    }

    /**
     * @param value Specifies whether contact flow logs are enabled. Defaults to `false`.
     */
    @JvmName("juhilvvjlrbkwopf")
    public suspend fun contactFlowLogsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactFlowLogsEnabled = mapped
    }

    /**
     * @param value Specifies whether contact lens is enabled. Defaults to `true`.
     */
    @JvmName("rbacadvkcyatatgm")
    public suspend fun contactLensEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactLensEnabled = mapped
    }

    /**
     * @param value The identifier for the directory if identity_management_type is `EXISTING_DIRECTORY`.
     */
    @JvmName("kysaqojmhbrixvne")
    public suspend fun directoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryId = mapped
    }

    /**
     * @param value Specifies whether early media for outbound calls is enabled . Defaults to `true` if outbound calls is enabled.
     */
    @JvmName("faesntshoixrpapp")
    public suspend fun earlyMediaEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.earlyMediaEnabled = mapped
    }

    /**
     * @param value Specifies the identity management type attached to the instance. Allowed Values are: `SAML`, `CONNECT_MANAGED`, `EXISTING_DIRECTORY`.
     */
    @JvmName("dipwkdvktcuobcem")
    public suspend fun identityManagementType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityManagementType = mapped
    }

    /**
     * @param value Specifies whether inbound calls are enabled.
     */
    @JvmName("lmihbgjyimyocfho")
    public suspend fun inboundCallsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inboundCallsEnabled = mapped
    }

    /**
     * @param value Specifies the name of the instance. Required if `directory_id` not specified.
     */
    @JvmName("xqddwhkbuovlpggx")
    public suspend fun instanceAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceAlias = mapped
    }

    /**
     * @param value Specifies whether multi-party calls/conference is enabled. Defaults to `false`.
     */
    @JvmName("jjextipekmoqrphu")
    public suspend fun multiPartyConferenceEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiPartyConferenceEnabled = mapped
    }

    /**
     * @param value Specifies whether outbound calls are enabled.
     * <!-- * `use_custom_tts_voices` - (Optional) Whether use custom tts voices is enabled. Defaults to `false` -->
     */
    @JvmName("sbxuaifobiywidwk")
    public suspend fun outboundCallsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outboundCallsEnabled = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        autoResolveBestVoicesEnabled = autoResolveBestVoicesEnabled,
        contactFlowLogsEnabled = contactFlowLogsEnabled,
        contactLensEnabled = contactLensEnabled,
        directoryId = directoryId,
        earlyMediaEnabled = earlyMediaEnabled,
        identityManagementType = identityManagementType,
        inboundCallsEnabled = inboundCallsEnabled,
        instanceAlias = instanceAlias,
        multiPartyConferenceEnabled = multiPartyConferenceEnabled,
        outboundCallsEnabled = outboundCallsEnabled,
    )
}
