@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.kotlin.outputs.InstanceStorageConfigStorageConfig
import com.pulumi.aws.connect.kotlin.outputs.InstanceStorageConfigStorageConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [InstanceStorageConfig].
 */
@PulumiTagMarker
public class InstanceStorageConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceStorageConfigArgs = InstanceStorageConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceStorageConfigArgsBuilder.() -> Unit) {
        val builder = InstanceStorageConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): InstanceStorageConfig {
        val builtJavaResource = com.pulumi.aws.connect.InstanceStorageConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return InstanceStorageConfig(builtJavaResource)
    }
}

/**
 * Provides an Amazon Connect Instance Storage Config resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * ## Example Usage
 * ### Storage Config Kinesis Firehose Config
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.InstanceStorageConfig("example", {
 *     instanceId: exampleAwsConnectInstance.id,
 *     resourceType: "CONTACT_TRACE_RECORDS",
 *     storageConfig: {
 *         kinesisFirehoseConfig: {
 *             firehoseArn: exampleAwsKinesisFirehoseDeliveryStream.arn,
 *         },
 *         storageType: "KINESIS_FIREHOSE",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.InstanceStorageConfig("example",
 *     instance_id=example_aws_connect_instance["id"],
 *     resource_type="CONTACT_TRACE_RECORDS",
 *     storage_config={
 *         "kinesis_firehose_config": {
 *             "firehose_arn": example_aws_kinesis_firehose_delivery_stream["arn"],
 *         },
 *         "storage_type": "KINESIS_FIREHOSE",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.InstanceStorageConfig("example", new()
 *     {
 *         InstanceId = exampleAwsConnectInstance.Id,
 *         ResourceType = "CONTACT_TRACE_RECORDS",
 *         StorageConfig = new Aws.Connect.Inputs.InstanceStorageConfigStorageConfigArgs
 *         {
 *             KinesisFirehoseConfig = new Aws.Connect.Inputs.InstanceStorageConfigStorageConfigKinesisFirehoseConfigArgs
 *             {
 *                 FirehoseArn = exampleAwsKinesisFirehoseDeliveryStream.Arn,
 *             },
 *             StorageType = "KINESIS_FIREHOSE",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewInstanceStorageConfig(ctx, "example", &connect.InstanceStorageConfigArgs{
 * 			InstanceId:   pulumi.Any(exampleAwsConnectInstance.Id),
 * 			ResourceType: pulumi.String("CONTACT_TRACE_RECORDS"),
 * 			StorageConfig: &connect.InstanceStorageConfigStorageConfigArgs{
 * 				KinesisFirehoseConfig: &connect.InstanceStorageConfigStorageConfigKinesisFirehoseConfigArgs{
 * 					FirehoseArn: pulumi.Any(exampleAwsKinesisFirehoseDeliveryStream.Arn),
 * 				},
 * 				StorageType: pulumi.String("KINESIS_FIREHOSE"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.InstanceStorageConfig;
 * import com.pulumi.aws.connect.InstanceStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisFirehoseConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceStorageConfig("example", InstanceStorageConfigArgs.builder()
 *             .instanceId(exampleAwsConnectInstance.id())
 *             .resourceType("CONTACT_TRACE_RECORDS")
 *             .storageConfig(InstanceStorageConfigStorageConfigArgs.builder()
 *                 .kinesisFirehoseConfig(InstanceStorageConfigStorageConfigKinesisFirehoseConfigArgs.builder()
 *                     .firehoseArn(exampleAwsKinesisFirehoseDeliveryStream.arn())
 *                     .build())
 *                 .storageType("KINESIS_FIREHOSE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:InstanceStorageConfig
 *     properties:
 *       instanceId: ${exampleAwsConnectInstance.id}
 *       resourceType: CONTACT_TRACE_RECORDS
 *       storageConfig:
 *         kinesisFirehoseConfig:
 *           firehoseArn: ${exampleAwsKinesisFirehoseDeliveryStream.arn}
 *         storageType: KINESIS_FIREHOSE
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Storage Config Kinesis Stream Config
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.InstanceStorageConfig("example", {
 *     instanceId: exampleAwsConnectInstance.id,
 *     resourceType: "CONTACT_TRACE_RECORDS",
 *     storageConfig: {
 *         kinesisStreamConfig: {
 *             streamArn: exampleAwsKinesisStream.arn,
 *         },
 *         storageType: "KINESIS_STREAM",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.InstanceStorageConfig("example",
 *     instance_id=example_aws_connect_instance["id"],
 *     resource_type="CONTACT_TRACE_RECORDS",
 *     storage_config={
 *         "kinesis_stream_config": {
 *             "stream_arn": example_aws_kinesis_stream["arn"],
 *         },
 *         "storage_type": "KINESIS_STREAM",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.InstanceStorageConfig("example", new()
 *     {
 *         InstanceId = exampleAwsConnectInstance.Id,
 *         ResourceType = "CONTACT_TRACE_RECORDS",
 *         StorageConfig = new Aws.Connect.Inputs.InstanceStorageConfigStorageConfigArgs
 *         {
 *             KinesisStreamConfig = new Aws.Connect.Inputs.InstanceStorageConfigStorageConfigKinesisStreamConfigArgs
 *             {
 *                 StreamArn = exampleAwsKinesisStream.Arn,
 *             },
 *             StorageType = "KINESIS_STREAM",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewInstanceStorageConfig(ctx, "example", &connect.InstanceStorageConfigArgs{
 * 			InstanceId:   pulumi.Any(exampleAwsConnectInstance.Id),
 * 			ResourceType: pulumi.String("CONTACT_TRACE_RECORDS"),
 * 			StorageConfig: &connect.InstanceStorageConfigStorageConfigArgs{
 * 				KinesisStreamConfig: &connect.InstanceStorageConfigStorageConfigKinesisStreamConfigArgs{
 * 					StreamArn: pulumi.Any(exampleAwsKinesisStream.Arn),
 * 				},
 * 				StorageType: pulumi.String("KINESIS_STREAM"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.InstanceStorageConfig;
 * import com.pulumi.aws.connect.InstanceStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisStreamConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceStorageConfig("example", InstanceStorageConfigArgs.builder()
 *             .instanceId(exampleAwsConnectInstance.id())
 *             .resourceType("CONTACT_TRACE_RECORDS")
 *             .storageConfig(InstanceStorageConfigStorageConfigArgs.builder()
 *                 .kinesisStreamConfig(InstanceStorageConfigStorageConfigKinesisStreamConfigArgs.builder()
 *                     .streamArn(exampleAwsKinesisStream.arn())
 *                     .build())
 *                 .storageType("KINESIS_STREAM")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:InstanceStorageConfig
 *     properties:
 *       instanceId: ${exampleAwsConnectInstance.id}
 *       resourceType: CONTACT_TRACE_RECORDS
 *       storageConfig:
 *         kinesisStreamConfig:
 *           streamArn: ${exampleAwsKinesisStream.arn}
 *         storageType: KINESIS_STREAM
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Storage Config Kinesis Video Stream Config
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.InstanceStorageConfig("example", {
 *     instanceId: exampleAwsConnectInstance.id,
 *     resourceType: "MEDIA_STREAMS",
 *     storageConfig: {
 *         kinesisVideoStreamConfig: {
 *             prefix: "example",
 *             retentionPeriodHours: 3,
 *             encryptionConfig: {
 *                 encryptionType: "KMS",
 *                 keyId: exampleAwsKmsKey.arn,
 *             },
 *         },
 *         storageType: "KINESIS_VIDEO_STREAM",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.InstanceStorageConfig("example",
 *     instance_id=example_aws_connect_instance["id"],
 *     resource_type="MEDIA_STREAMS",
 *     storage_config={
 *         "kinesis_video_stream_config": {
 *             "prefix": "example",
 *             "retention_period_hours": 3,
 *             "encryption_config": {
 *                 "encryption_type": "KMS",
 *                 "key_id": example_aws_kms_key["arn"],
 *             },
 *         },
 *         "storage_type": "KINESIS_VIDEO_STREAM",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.InstanceStorageConfig("example", new()
 *     {
 *         InstanceId = exampleAwsConnectInstance.Id,
 *         ResourceType = "MEDIA_STREAMS",
 *         StorageConfig = new Aws.Connect.Inputs.InstanceStorageConfigStorageConfigArgs
 *         {
 *             KinesisVideoStreamConfig = new Aws.Connect.Inputs.InstanceStorageConfigStorageConfigKinesisVideoStreamConfigArgs
 *             {
 *                 Prefix = "example",
 *                 RetentionPeriodHours = 3,
 *                 EncryptionConfig = new Aws.Connect.Inputs.InstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfigArgs
 *                 {
 *                     EncryptionType = "KMS",
 *                     KeyId = exampleAwsKmsKey.Arn,
 *                 },
 *             },
 *             StorageType = "KINESIS_VIDEO_STREAM",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewInstanceStorageConfig(ctx, "example", &connect.InstanceStorageConfigArgs{
 * 			InstanceId:   pulumi.Any(exampleAwsConnectInstance.Id),
 * 			ResourceType: pulumi.String("MEDIA_STREAMS"),
 * 			StorageConfig: &connect.InstanceStorageConfigStorageConfigArgs{
 * 				KinesisVideoStreamConfig: &connect.InstanceStorageConfigStorageConfigKinesisVideoStreamConfigArgs{
 * 					Prefix:               pulumi.String("example"),
 * 					RetentionPeriodHours: pulumi.Int(3),
 * 					EncryptionConfig: &connect.InstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfigArgs{
 * 						EncryptionType: pulumi.String("KMS"),
 * 						KeyId:          pulumi.Any(exampleAwsKmsKey.Arn),
 * 					},
 * 				},
 * 				StorageType: pulumi.String("KINESIS_VIDEO_STREAM"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.InstanceStorageConfig;
 * import com.pulumi.aws.connect.InstanceStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisVideoStreamConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceStorageConfig("example", InstanceStorageConfigArgs.builder()
 *             .instanceId(exampleAwsConnectInstance.id())
 *             .resourceType("MEDIA_STREAMS")
 *             .storageConfig(InstanceStorageConfigStorageConfigArgs.builder()
 *                 .kinesisVideoStreamConfig(InstanceStorageConfigStorageConfigKinesisVideoStreamConfigArgs.builder()
 *                     .prefix("example")
 *                     .retentionPeriodHours(3)
 *                     .encryptionConfig(InstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfigArgs.builder()
 *                         .encryptionType("KMS")
 *                         .keyId(exampleAwsKmsKey.arn())
 *                         .build())
 *                     .build())
 *                 .storageType("KINESIS_VIDEO_STREAM")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:InstanceStorageConfig
 *     properties:
 *       instanceId: ${exampleAwsConnectInstance.id}
 *       resourceType: MEDIA_STREAMS
 *       storageConfig:
 *         kinesisVideoStreamConfig:
 *           prefix: example
 *           retentionPeriodHours: 3
 *           encryptionConfig:
 *             encryptionType: KMS
 *             keyId: ${exampleAwsKmsKey.arn}
 *         storageType: KINESIS_VIDEO_STREAM
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Storage Config S3 Config
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.InstanceStorageConfig("example", {
 *     instanceId: exampleAwsConnectInstance.id,
 *     resourceType: "CHAT_TRANSCRIPTS",
 *     storageConfig: {
 *         s3Config: {
 *             bucketName: exampleAwsS3Bucket.id,
 *             bucketPrefix: "example",
 *         },
 *         storageType: "S3",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.InstanceStorageConfig("example",
 *     instance_id=example_aws_connect_instance["id"],
 *     resource_type="CHAT_TRANSCRIPTS",
 *     storage_config={
 *         "s3_config": {
 *             "bucket_name": example_aws_s3_bucket["id"],
 *             "bucket_prefix": "example",
 *         },
 *         "storage_type": "S3",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.InstanceStorageConfig("example", new()
 *     {
 *         InstanceId = exampleAwsConnectInstance.Id,
 *         ResourceType = "CHAT_TRANSCRIPTS",
 *         StorageConfig = new Aws.Connect.Inputs.InstanceStorageConfigStorageConfigArgs
 *         {
 *             S3Config = new Aws.Connect.Inputs.InstanceStorageConfigStorageConfigS3ConfigArgs
 *             {
 *                 BucketName = exampleAwsS3Bucket.Id,
 *                 BucketPrefix = "example",
 *             },
 *             StorageType = "S3",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewInstanceStorageConfig(ctx, "example", &connect.InstanceStorageConfigArgs{
 * 			InstanceId:   pulumi.Any(exampleAwsConnectInstance.Id),
 * 			ResourceType: pulumi.String("CHAT_TRANSCRIPTS"),
 * 			StorageConfig: &connect.InstanceStorageConfigStorageConfigArgs{
 * 				S3Config: &connect.InstanceStorageConfigStorageConfigS3ConfigArgs{
 * 					BucketName:   pulumi.Any(exampleAwsS3Bucket.Id),
 * 					BucketPrefix: pulumi.String("example"),
 * 				},
 * 				StorageType: pulumi.String("S3"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.InstanceStorageConfig;
 * import com.pulumi.aws.connect.InstanceStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigS3ConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceStorageConfig("example", InstanceStorageConfigArgs.builder()
 *             .instanceId(exampleAwsConnectInstance.id())
 *             .resourceType("CHAT_TRANSCRIPTS")
 *             .storageConfig(InstanceStorageConfigStorageConfigArgs.builder()
 *                 .s3Config(InstanceStorageConfigStorageConfigS3ConfigArgs.builder()
 *                     .bucketName(exampleAwsS3Bucket.id())
 *                     .bucketPrefix("example")
 *                     .build())
 *                 .storageType("S3")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:InstanceStorageConfig
 *     properties:
 *       instanceId: ${exampleAwsConnectInstance.id}
 *       resourceType: CHAT_TRANSCRIPTS
 *       storageConfig:
 *         s3Config:
 *           bucketName: ${exampleAwsS3Bucket.id}
 *           bucketPrefix: example
 *         storageType: S3
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Storage Config S3 Config with Encryption Config
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.InstanceStorageConfig("example", {
 *     instanceId: exampleAwsConnectInstance.id,
 *     resourceType: "CHAT_TRANSCRIPTS",
 *     storageConfig: {
 *         s3Config: {
 *             bucketName: exampleAwsS3Bucket.id,
 *             bucketPrefix: "example",
 *             encryptionConfig: {
 *                 encryptionType: "KMS",
 *                 keyId: exampleAwsKmsKey.arn,
 *             },
 *         },
 *         storageType: "S3",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.InstanceStorageConfig("example",
 *     instance_id=example_aws_connect_instance["id"],
 *     resource_type="CHAT_TRANSCRIPTS",
 *     storage_config={
 *         "s3_config": {
 *             "bucket_name": example_aws_s3_bucket["id"],
 *             "bucket_prefix": "example",
 *             "encryption_config": {
 *                 "encryption_type": "KMS",
 *                 "key_id": example_aws_kms_key["arn"],
 *             },
 *         },
 *         "storage_type": "S3",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.InstanceStorageConfig("example", new()
 *     {
 *         InstanceId = exampleAwsConnectInstance.Id,
 *         ResourceType = "CHAT_TRANSCRIPTS",
 *         StorageConfig = new Aws.Connect.Inputs.InstanceStorageConfigStorageConfigArgs
 *         {
 *             S3Config = new Aws.Connect.Inputs.InstanceStorageConfigStorageConfigS3ConfigArgs
 *             {
 *                 BucketName = exampleAwsS3Bucket.Id,
 *                 BucketPrefix = "example",
 *                 EncryptionConfig = new Aws.Connect.Inputs.InstanceStorageConfigStorageConfigS3ConfigEncryptionConfigArgs
 *                 {
 *                     EncryptionType = "KMS",
 *                     KeyId = exampleAwsKmsKey.Arn,
 *                 },
 *             },
 *             StorageType = "S3",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewInstanceStorageConfig(ctx, "example", &connect.InstanceStorageConfigArgs{
 * 			InstanceId:   pulumi.Any(exampleAwsConnectInstance.Id),
 * 			ResourceType: pulumi.String("CHAT_TRANSCRIPTS"),
 * 			StorageConfig: &connect.InstanceStorageConfigStorageConfigArgs{
 * 				S3Config: &connect.InstanceStorageConfigStorageConfigS3ConfigArgs{
 * 					BucketName:   pulumi.Any(exampleAwsS3Bucket.Id),
 * 					BucketPrefix: pulumi.String("example"),
 * 					EncryptionConfig: &connect.InstanceStorageConfigStorageConfigS3ConfigEncryptionConfigArgs{
 * 						EncryptionType: pulumi.String("KMS"),
 * 						KeyId:          pulumi.Any(exampleAwsKmsKey.Arn),
 * 					},
 * 				},
 * 				StorageType: pulumi.String("S3"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.InstanceStorageConfig;
 * import com.pulumi.aws.connect.InstanceStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigS3ConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigS3ConfigEncryptionConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceStorageConfig("example", InstanceStorageConfigArgs.builder()
 *             .instanceId(exampleAwsConnectInstance.id())
 *             .resourceType("CHAT_TRANSCRIPTS")
 *             .storageConfig(InstanceStorageConfigStorageConfigArgs.builder()
 *                 .s3Config(InstanceStorageConfigStorageConfigS3ConfigArgs.builder()
 *                     .bucketName(exampleAwsS3Bucket.id())
 *                     .bucketPrefix("example")
 *                     .encryptionConfig(InstanceStorageConfigStorageConfigS3ConfigEncryptionConfigArgs.builder()
 *                         .encryptionType("KMS")
 *                         .keyId(exampleAwsKmsKey.arn())
 *                         .build())
 *                     .build())
 *                 .storageType("S3")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:InstanceStorageConfig
 *     properties:
 *       instanceId: ${exampleAwsConnectInstance.id}
 *       resourceType: CHAT_TRANSCRIPTS
 *       storageConfig:
 *         s3Config:
 *           bucketName: ${exampleAwsS3Bucket.id}
 *           bucketPrefix: example
 *           encryptionConfig:
 *             encryptionType: KMS
 *             keyId: ${exampleAwsKmsKey.arn}
 *         storageType: S3
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amazon Connect Instance Storage Configs using the `instance_id`, `association_id`, and `resource_type` separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:connect/instanceStorageConfig:InstanceStorageConfig example f1288a1f-6193-445a-b47e-af739b2:c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5:CHAT_TRANSCRIPTS
 * ```
 */
public class InstanceStorageConfig internal constructor(
    override val javaResource: com.pulumi.aws.connect.InstanceStorageConfig,
) : KotlinCustomResource(javaResource, InstanceStorageConfigMapper) {
    /**
     * The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.
     */
    public val associationId: Output<String>
        get() = javaResource.associationId().applyValue({ args0 -> args0 })

    /**
     * Specifies the identifier of the hosting Amazon Connect Instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * A valid resource type. Valid Values: `AGENT_EVENTS` | `ATTACHMENTS` | `CALL_RECORDINGS` | `CHAT_TRANSCRIPTS` | `CONTACT_EVALUATIONS` | `CONTACT_TRACE_RECORDS` | `MEDIA_STREAMS` | `REAL_TIME_CONTACT_ANALYSIS_SEGMENTS` | `SCHEDULED_REPORTS` | `SCREEN_RECORDINGS`.
     */
    public val resourceType: Output<String>
        get() = javaResource.resourceType().applyValue({ args0 -> args0 })

    /**
     * Specifies the storage configuration options for the Connect Instance. Documented below.
     */
    public val storageConfig: Output<InstanceStorageConfigStorageConfig>
        get() = javaResource.storageConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })
}

public object InstanceStorageConfigMapper : ResourceMapper<InstanceStorageConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.connect.InstanceStorageConfig::class == javaResource::class

    override fun map(javaResource: Resource): InstanceStorageConfig =
        InstanceStorageConfig(javaResource as com.pulumi.aws.connect.InstanceStorageConfig)
}

/**
 * @see [InstanceStorageConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InstanceStorageConfig].
 */
public suspend fun instanceStorageConfig(
    name: String,
    block: suspend InstanceStorageConfigResourceBuilder.() -> Unit,
): InstanceStorageConfig {
    val builder = InstanceStorageConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InstanceStorageConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instanceStorageConfig(name: String): InstanceStorageConfig {
    val builder = InstanceStorageConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
