@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.InstanceStorageConfigArgs.builder
import com.pulumi.aws.connect.kotlin.inputs.InstanceStorageConfigStorageConfigArgs
import com.pulumi.aws.connect.kotlin.inputs.InstanceStorageConfigStorageConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Connect Instance Storage Config resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * ## Example Usage
 * ### Storage Config Kinesis Firehose Config
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.InstanceStorageConfig("example", {
 *     instanceId: exampleAwsConnectInstance.id,
 *     resourceType: "CONTACT_TRACE_RECORDS",
 *     storageConfig: {
 *         kinesisFirehoseConfig: {
 *             firehoseArn: exampleAwsKinesisFirehoseDeliveryStream.arn,
 *         },
 *         storageType: "KINESIS_FIREHOSE",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.InstanceStorageConfig("example",
 *     instance_id=example_aws_connect_instance["id"],
 *     resource_type="CONTACT_TRACE_RECORDS",
 *     storage_config={
 *         "kinesis_firehose_config": {
 *             "firehose_arn": example_aws_kinesis_firehose_delivery_stream["arn"],
 *         },
 *         "storage_type": "KINESIS_FIREHOSE",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.InstanceStorageConfig("example", new()
 *     {
 *         InstanceId = exampleAwsConnectInstance.Id,
 *         ResourceType = "CONTACT_TRACE_RECORDS",
 *         StorageConfig = new Aws.Connect.Inputs.InstanceStorageConfigStorageConfigArgs
 *         {
 *             KinesisFirehoseConfig = new Aws.Connect.Inputs.InstanceStorageConfigStorageConfigKinesisFirehoseConfigArgs
 *             {
 *                 FirehoseArn = exampleAwsKinesisFirehoseDeliveryStream.Arn,
 *             },
 *             StorageType = "KINESIS_FIREHOSE",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewInstanceStorageConfig(ctx, "example", &connect.InstanceStorageConfigArgs{
 * 			InstanceId:   pulumi.Any(exampleAwsConnectInstance.Id),
 * 			ResourceType: pulumi.String("CONTACT_TRACE_RECORDS"),
 * 			StorageConfig: &connect.InstanceStorageConfigStorageConfigArgs{
 * 				KinesisFirehoseConfig: &connect.InstanceStorageConfigStorageConfigKinesisFirehoseConfigArgs{
 * 					FirehoseArn: pulumi.Any(exampleAwsKinesisFirehoseDeliveryStream.Arn),
 * 				},
 * 				StorageType: pulumi.String("KINESIS_FIREHOSE"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.InstanceStorageConfig;
 * import com.pulumi.aws.connect.InstanceStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisFirehoseConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceStorageConfig("example", InstanceStorageConfigArgs.builder()
 *             .instanceId(exampleAwsConnectInstance.id())
 *             .resourceType("CONTACT_TRACE_RECORDS")
 *             .storageConfig(InstanceStorageConfigStorageConfigArgs.builder()
 *                 .kinesisFirehoseConfig(InstanceStorageConfigStorageConfigKinesisFirehoseConfigArgs.builder()
 *                     .firehoseArn(exampleAwsKinesisFirehoseDeliveryStream.arn())
 *                     .build())
 *                 .storageType("KINESIS_FIREHOSE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:InstanceStorageConfig
 *     properties:
 *       instanceId: ${exampleAwsConnectInstance.id}
 *       resourceType: CONTACT_TRACE_RECORDS
 *       storageConfig:
 *         kinesisFirehoseConfig:
 *           firehoseArn: ${exampleAwsKinesisFirehoseDeliveryStream.arn}
 *         storageType: KINESIS_FIREHOSE
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Storage Config Kinesis Stream Config
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.InstanceStorageConfig("example", {
 *     instanceId: exampleAwsConnectInstance.id,
 *     resourceType: "CONTACT_TRACE_RECORDS",
 *     storageConfig: {
 *         kinesisStreamConfig: {
 *             streamArn: exampleAwsKinesisStream.arn,
 *         },
 *         storageType: "KINESIS_STREAM",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.InstanceStorageConfig("example",
 *     instance_id=example_aws_connect_instance["id"],
 *     resource_type="CONTACT_TRACE_RECORDS",
 *     storage_config={
 *         "kinesis_stream_config": {
 *             "stream_arn": example_aws_kinesis_stream["arn"],
 *         },
 *         "storage_type": "KINESIS_STREAM",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.InstanceStorageConfig("example", new()
 *     {
 *         InstanceId = exampleAwsConnectInstance.Id,
 *         ResourceType = "CONTACT_TRACE_RECORDS",
 *         StorageConfig = new Aws.Connect.Inputs.InstanceStorageConfigStorageConfigArgs
 *         {
 *             KinesisStreamConfig = new Aws.Connect.Inputs.InstanceStorageConfigStorageConfigKinesisStreamConfigArgs
 *             {
 *                 StreamArn = exampleAwsKinesisStream.Arn,
 *             },
 *             StorageType = "KINESIS_STREAM",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewInstanceStorageConfig(ctx, "example", &connect.InstanceStorageConfigArgs{
 * 			InstanceId:   pulumi.Any(exampleAwsConnectInstance.Id),
 * 			ResourceType: pulumi.String("CONTACT_TRACE_RECORDS"),
 * 			StorageConfig: &connect.InstanceStorageConfigStorageConfigArgs{
 * 				KinesisStreamConfig: &connect.InstanceStorageConfigStorageConfigKinesisStreamConfigArgs{
 * 					StreamArn: pulumi.Any(exampleAwsKinesisStream.Arn),
 * 				},
 * 				StorageType: pulumi.String("KINESIS_STREAM"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.InstanceStorageConfig;
 * import com.pulumi.aws.connect.InstanceStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisStreamConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceStorageConfig("example", InstanceStorageConfigArgs.builder()
 *             .instanceId(exampleAwsConnectInstance.id())
 *             .resourceType("CONTACT_TRACE_RECORDS")
 *             .storageConfig(InstanceStorageConfigStorageConfigArgs.builder()
 *                 .kinesisStreamConfig(InstanceStorageConfigStorageConfigKinesisStreamConfigArgs.builder()
 *                     .streamArn(exampleAwsKinesisStream.arn())
 *                     .build())
 *                 .storageType("KINESIS_STREAM")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:InstanceStorageConfig
 *     properties:
 *       instanceId: ${exampleAwsConnectInstance.id}
 *       resourceType: CONTACT_TRACE_RECORDS
 *       storageConfig:
 *         kinesisStreamConfig:
 *           streamArn: ${exampleAwsKinesisStream.arn}
 *         storageType: KINESIS_STREAM
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Storage Config Kinesis Video Stream Config
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.InstanceStorageConfig("example", {
 *     instanceId: exampleAwsConnectInstance.id,
 *     resourceType: "MEDIA_STREAMS",
 *     storageConfig: {
 *         kinesisVideoStreamConfig: {
 *             prefix: "example",
 *             retentionPeriodHours: 3,
 *             encryptionConfig: {
 *                 encryptionType: "KMS",
 *                 keyId: exampleAwsKmsKey.arn,
 *             },
 *         },
 *         storageType: "KINESIS_VIDEO_STREAM",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.InstanceStorageConfig("example",
 *     instance_id=example_aws_connect_instance["id"],
 *     resource_type="MEDIA_STREAMS",
 *     storage_config={
 *         "kinesis_video_stream_config": {
 *             "prefix": "example",
 *             "retention_period_hours": 3,
 *             "encryption_config": {
 *                 "encryption_type": "KMS",
 *                 "key_id": example_aws_kms_key["arn"],
 *             },
 *         },
 *         "storage_type": "KINESIS_VIDEO_STREAM",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.InstanceStorageConfig("example", new()
 *     {
 *         InstanceId = exampleAwsConnectInstance.Id,
 *         ResourceType = "MEDIA_STREAMS",
 *         StorageConfig = new Aws.Connect.Inputs.InstanceStorageConfigStorageConfigArgs
 *         {
 *             KinesisVideoStreamConfig = new Aws.Connect.Inputs.InstanceStorageConfigStorageConfigKinesisVideoStreamConfigArgs
 *             {
 *                 Prefix = "example",
 *                 RetentionPeriodHours = 3,
 *                 EncryptionConfig = new Aws.Connect.Inputs.InstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfigArgs
 *                 {
 *                     EncryptionType = "KMS",
 *                     KeyId = exampleAwsKmsKey.Arn,
 *                 },
 *             },
 *             StorageType = "KINESIS_VIDEO_STREAM",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewInstanceStorageConfig(ctx, "example", &connect.InstanceStorageConfigArgs{
 * 			InstanceId:   pulumi.Any(exampleAwsConnectInstance.Id),
 * 			ResourceType: pulumi.String("MEDIA_STREAMS"),
 * 			StorageConfig: &connect.InstanceStorageConfigStorageConfigArgs{
 * 				KinesisVideoStreamConfig: &connect.InstanceStorageConfigStorageConfigKinesisVideoStreamConfigArgs{
 * 					Prefix:               pulumi.String("example"),
 * 					RetentionPeriodHours: pulumi.Int(3),
 * 					EncryptionConfig: &connect.InstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfigArgs{
 * 						EncryptionType: pulumi.String("KMS"),
 * 						KeyId:          pulumi.Any(exampleAwsKmsKey.Arn),
 * 					},
 * 				},
 * 				StorageType: pulumi.String("KINESIS_VIDEO_STREAM"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.InstanceStorageConfig;
 * import com.pulumi.aws.connect.InstanceStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisVideoStreamConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceStorageConfig("example", InstanceStorageConfigArgs.builder()
 *             .instanceId(exampleAwsConnectInstance.id())
 *             .resourceType("MEDIA_STREAMS")
 *             .storageConfig(InstanceStorageConfigStorageConfigArgs.builder()
 *                 .kinesisVideoStreamConfig(InstanceStorageConfigStorageConfigKinesisVideoStreamConfigArgs.builder()
 *                     .prefix("example")
 *                     .retentionPeriodHours(3)
 *                     .encryptionConfig(InstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfigArgs.builder()
 *                         .encryptionType("KMS")
 *                         .keyId(exampleAwsKmsKey.arn())
 *                         .build())
 *                     .build())
 *                 .storageType("KINESIS_VIDEO_STREAM")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:InstanceStorageConfig
 *     properties:
 *       instanceId: ${exampleAwsConnectInstance.id}
 *       resourceType: MEDIA_STREAMS
 *       storageConfig:
 *         kinesisVideoStreamConfig:
 *           prefix: example
 *           retentionPeriodHours: 3
 *           encryptionConfig:
 *             encryptionType: KMS
 *             keyId: ${exampleAwsKmsKey.arn}
 *         storageType: KINESIS_VIDEO_STREAM
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Storage Config S3 Config
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.InstanceStorageConfig("example", {
 *     instanceId: exampleAwsConnectInstance.id,
 *     resourceType: "CHAT_TRANSCRIPTS",
 *     storageConfig: {
 *         s3Config: {
 *             bucketName: exampleAwsS3Bucket.id,
 *             bucketPrefix: "example",
 *         },
 *         storageType: "S3",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.InstanceStorageConfig("example",
 *     instance_id=example_aws_connect_instance["id"],
 *     resource_type="CHAT_TRANSCRIPTS",
 *     storage_config={
 *         "s3_config": {
 *             "bucket_name": example_aws_s3_bucket["id"],
 *             "bucket_prefix": "example",
 *         },
 *         "storage_type": "S3",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.InstanceStorageConfig("example", new()
 *     {
 *         InstanceId = exampleAwsConnectInstance.Id,
 *         ResourceType = "CHAT_TRANSCRIPTS",
 *         StorageConfig = new Aws.Connect.Inputs.InstanceStorageConfigStorageConfigArgs
 *         {
 *             S3Config = new Aws.Connect.Inputs.InstanceStorageConfigStorageConfigS3ConfigArgs
 *             {
 *                 BucketName = exampleAwsS3Bucket.Id,
 *                 BucketPrefix = "example",
 *             },
 *             StorageType = "S3",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewInstanceStorageConfig(ctx, "example", &connect.InstanceStorageConfigArgs{
 * 			InstanceId:   pulumi.Any(exampleAwsConnectInstance.Id),
 * 			ResourceType: pulumi.String("CHAT_TRANSCRIPTS"),
 * 			StorageConfig: &connect.InstanceStorageConfigStorageConfigArgs{
 * 				S3Config: &connect.InstanceStorageConfigStorageConfigS3ConfigArgs{
 * 					BucketName:   pulumi.Any(exampleAwsS3Bucket.Id),
 * 					BucketPrefix: pulumi.String("example"),
 * 				},
 * 				StorageType: pulumi.String("S3"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.InstanceStorageConfig;
 * import com.pulumi.aws.connect.InstanceStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigS3ConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceStorageConfig("example", InstanceStorageConfigArgs.builder()
 *             .instanceId(exampleAwsConnectInstance.id())
 *             .resourceType("CHAT_TRANSCRIPTS")
 *             .storageConfig(InstanceStorageConfigStorageConfigArgs.builder()
 *                 .s3Config(InstanceStorageConfigStorageConfigS3ConfigArgs.builder()
 *                     .bucketName(exampleAwsS3Bucket.id())
 *                     .bucketPrefix("example")
 *                     .build())
 *                 .storageType("S3")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:InstanceStorageConfig
 *     properties:
 *       instanceId: ${exampleAwsConnectInstance.id}
 *       resourceType: CHAT_TRANSCRIPTS
 *       storageConfig:
 *         s3Config:
 *           bucketName: ${exampleAwsS3Bucket.id}
 *           bucketPrefix: example
 *         storageType: S3
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Storage Config S3 Config with Encryption Config
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.InstanceStorageConfig("example", {
 *     instanceId: exampleAwsConnectInstance.id,
 *     resourceType: "CHAT_TRANSCRIPTS",
 *     storageConfig: {
 *         s3Config: {
 *             bucketName: exampleAwsS3Bucket.id,
 *             bucketPrefix: "example",
 *             encryptionConfig: {
 *                 encryptionType: "KMS",
 *                 keyId: exampleAwsKmsKey.arn,
 *             },
 *         },
 *         storageType: "S3",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.InstanceStorageConfig("example",
 *     instance_id=example_aws_connect_instance["id"],
 *     resource_type="CHAT_TRANSCRIPTS",
 *     storage_config={
 *         "s3_config": {
 *             "bucket_name": example_aws_s3_bucket["id"],
 *             "bucket_prefix": "example",
 *             "encryption_config": {
 *                 "encryption_type": "KMS",
 *                 "key_id": example_aws_kms_key["arn"],
 *             },
 *         },
 *         "storage_type": "S3",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.InstanceStorageConfig("example", new()
 *     {
 *         InstanceId = exampleAwsConnectInstance.Id,
 *         ResourceType = "CHAT_TRANSCRIPTS",
 *         StorageConfig = new Aws.Connect.Inputs.InstanceStorageConfigStorageConfigArgs
 *         {
 *             S3Config = new Aws.Connect.Inputs.InstanceStorageConfigStorageConfigS3ConfigArgs
 *             {
 *                 BucketName = exampleAwsS3Bucket.Id,
 *                 BucketPrefix = "example",
 *                 EncryptionConfig = new Aws.Connect.Inputs.InstanceStorageConfigStorageConfigS3ConfigEncryptionConfigArgs
 *                 {
 *                     EncryptionType = "KMS",
 *                     KeyId = exampleAwsKmsKey.Arn,
 *                 },
 *             },
 *             StorageType = "S3",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewInstanceStorageConfig(ctx, "example", &connect.InstanceStorageConfigArgs{
 * 			InstanceId:   pulumi.Any(exampleAwsConnectInstance.Id),
 * 			ResourceType: pulumi.String("CHAT_TRANSCRIPTS"),
 * 			StorageConfig: &connect.InstanceStorageConfigStorageConfigArgs{
 * 				S3Config: &connect.InstanceStorageConfigStorageConfigS3ConfigArgs{
 * 					BucketName:   pulumi.Any(exampleAwsS3Bucket.Id),
 * 					BucketPrefix: pulumi.String("example"),
 * 					EncryptionConfig: &connect.InstanceStorageConfigStorageConfigS3ConfigEncryptionConfigArgs{
 * 						EncryptionType: pulumi.String("KMS"),
 * 						KeyId:          pulumi.Any(exampleAwsKmsKey.Arn),
 * 					},
 * 				},
 * 				StorageType: pulumi.String("S3"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.InstanceStorageConfig;
 * import com.pulumi.aws.connect.InstanceStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigS3ConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigS3ConfigEncryptionConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceStorageConfig("example", InstanceStorageConfigArgs.builder()
 *             .instanceId(exampleAwsConnectInstance.id())
 *             .resourceType("CHAT_TRANSCRIPTS")
 *             .storageConfig(InstanceStorageConfigStorageConfigArgs.builder()
 *                 .s3Config(InstanceStorageConfigStorageConfigS3ConfigArgs.builder()
 *                     .bucketName(exampleAwsS3Bucket.id())
 *                     .bucketPrefix("example")
 *                     .encryptionConfig(InstanceStorageConfigStorageConfigS3ConfigEncryptionConfigArgs.builder()
 *                         .encryptionType("KMS")
 *                         .keyId(exampleAwsKmsKey.arn())
 *                         .build())
 *                     .build())
 *                 .storageType("S3")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:InstanceStorageConfig
 *     properties:
 *       instanceId: ${exampleAwsConnectInstance.id}
 *       resourceType: CHAT_TRANSCRIPTS
 *       storageConfig:
 *         s3Config:
 *           bucketName: ${exampleAwsS3Bucket.id}
 *           bucketPrefix: example
 *           encryptionConfig:
 *             encryptionType: KMS
 *             keyId: ${exampleAwsKmsKey.arn}
 *         storageType: S3
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amazon Connect Instance Storage Configs using the `instance_id`, `association_id`, and `resource_type` separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:connect/instanceStorageConfig:InstanceStorageConfig example f1288a1f-6193-445a-b47e-af739b2:c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5:CHAT_TRANSCRIPTS
 * ```
 * @property instanceId Specifies the identifier of the hosting Amazon Connect Instance.
 * @property resourceType A valid resource type. Valid Values: `AGENT_EVENTS` | `ATTACHMENTS` | `CALL_RECORDINGS` | `CHAT_TRANSCRIPTS` | `CONTACT_EVALUATIONS` | `CONTACT_TRACE_RECORDS` | `MEDIA_STREAMS` | `REAL_TIME_CONTACT_ANALYSIS_SEGMENTS` | `SCHEDULED_REPORTS` | `SCREEN_RECORDINGS`.
 * @property storageConfig Specifies the storage configuration options for the Connect Instance. Documented below.
 */
public data class InstanceStorageConfigArgs(
    public val instanceId: Output<String>? = null,
    public val resourceType: Output<String>? = null,
    public val storageConfig: Output<InstanceStorageConfigStorageConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.InstanceStorageConfigArgs> {
    override fun toJava(): com.pulumi.aws.connect.InstanceStorageConfigArgs =
        com.pulumi.aws.connect.InstanceStorageConfigArgs.builder()
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 }))
            .storageConfig(storageConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [InstanceStorageConfigArgs].
 */
@PulumiTagMarker
public class InstanceStorageConfigArgsBuilder internal constructor() {
    private var instanceId: Output<String>? = null

    private var resourceType: Output<String>? = null

    private var storageConfig: Output<InstanceStorageConfigStorageConfigArgs>? = null

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("sdpwdmftsjehhfmn")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value A valid resource type. Valid Values: `AGENT_EVENTS` | `ATTACHMENTS` | `CALL_RECORDINGS` | `CHAT_TRANSCRIPTS` | `CONTACT_EVALUATIONS` | `CONTACT_TRACE_RECORDS` | `MEDIA_STREAMS` | `REAL_TIME_CONTACT_ANALYSIS_SEGMENTS` | `SCHEDULED_REPORTS` | `SCREEN_RECORDINGS`.
     */
    @JvmName("poulvqoqlwygwuiv")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value Specifies the storage configuration options for the Connect Instance. Documented below.
     */
    @JvmName("excltxckssvoidkg")
    public suspend fun storageConfig(`value`: Output<InstanceStorageConfigStorageConfigArgs>) {
        this.storageConfig = value
    }

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("jomcgddjyvxmaife")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value A valid resource type. Valid Values: `AGENT_EVENTS` | `ATTACHMENTS` | `CALL_RECORDINGS` | `CHAT_TRANSCRIPTS` | `CONTACT_EVALUATIONS` | `CONTACT_TRACE_RECORDS` | `MEDIA_STREAMS` | `REAL_TIME_CONTACT_ANALYSIS_SEGMENTS` | `SCHEDULED_REPORTS` | `SCREEN_RECORDINGS`.
     */
    @JvmName("ibahoupwsklvngsx")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value Specifies the storage configuration options for the Connect Instance. Documented below.
     */
    @JvmName("elyfspjmhbcnjeko")
    public suspend fun storageConfig(`value`: InstanceStorageConfigStorageConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageConfig = mapped
    }

    /**
     * @param argument Specifies the storage configuration options for the Connect Instance. Documented below.
     */
    @JvmName("ghpmkmrdjlleiurl")
    public suspend fun storageConfig(argument: suspend InstanceStorageConfigStorageConfigArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceStorageConfigStorageConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.storageConfig = mapped
    }

    internal fun build(): InstanceStorageConfigArgs = InstanceStorageConfigArgs(
        instanceId = instanceId,
        resourceType = resourceType,
        storageConfig = storageConfig,
    )
}
