@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LambdaFunctionAssociation].
 */
@PulumiTagMarker
public class LambdaFunctionAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LambdaFunctionAssociationArgs = LambdaFunctionAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LambdaFunctionAssociationArgsBuilder.() -> Unit) {
        val builder = LambdaFunctionAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LambdaFunctionAssociation {
        val builtJavaResource =
            com.pulumi.aws.connect.LambdaFunctionAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LambdaFunctionAssociation(builtJavaResource)
    }
}

/**
 * Provides an Amazon Connect Lambda Function Association. For more information see
 * [Amazon Connect: Getting Started](https://docs&#46;aws&#46;amazon&#46;com/connect/latest/adminguide/amazon-connect-get-started&#46;html) and [Invoke AWS Lambda functions](https://docs.aws.amazon.com/connect/latest/adminguide/connect-lambda-functions.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.LambdaFunctionAssociation("example", {
 *     functionArn: exampleAwsLambdaFunction.arn,
 *     instanceId: exampleAwsConnectInstance.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.LambdaFunctionAssociation("example",
 *     function_arn=example_aws_lambda_function["arn"],
 *     instance_id=example_aws_connect_instance["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.LambdaFunctionAssociation("example", new()
 *     {
 *         FunctionArn = exampleAwsLambdaFunction.Arn,
 *         InstanceId = exampleAwsConnectInstance.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewLambdaFunctionAssociation(ctx, "example", &connect.LambdaFunctionAssociationArgs{
 * 			FunctionArn: pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 			InstanceId:  pulumi.Any(exampleAwsConnectInstance.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.LambdaFunctionAssociation;
 * import com.pulumi.aws.connect.LambdaFunctionAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LambdaFunctionAssociation("example", LambdaFunctionAssociationArgs.builder()
 *             .functionArn(exampleAwsLambdaFunction.arn())
 *             .instanceId(exampleAwsConnectInstance.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:LambdaFunctionAssociation
 *     properties:
 *       functionArn: ${exampleAwsLambdaFunction.arn}
 *       instanceId: ${exampleAwsConnectInstance.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_connect_lambda_function_association` using the `instance_id` and `function_arn` separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:connect/lambdaFunctionAssociation:LambdaFunctionAssociation example aaaaaaaa-bbbb-cccc-dddd-111111111111,arn:aws:lambda:us-west-2:123456789123:function:example
 * ```
 */
public class LambdaFunctionAssociation internal constructor(
    override val javaResource: com.pulumi.aws.connect.LambdaFunctionAssociation,
) : KotlinCustomResource(javaResource, LambdaFunctionAssociationMapper) {
    /**
     * Amazon Resource Name (ARN) of the Lambda Function, omitting any version or alias qualifier.
     */
    public val functionArn: Output<String>
        get() = javaResource.functionArn().applyValue({ args0 -> args0 })

    /**
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })
}

public object LambdaFunctionAssociationMapper : ResourceMapper<LambdaFunctionAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.connect.LambdaFunctionAssociation::class == javaResource::class

    override fun map(javaResource: Resource): LambdaFunctionAssociation =
        LambdaFunctionAssociation(javaResource as com.pulumi.aws.connect.LambdaFunctionAssociation)
}

/**
 * @see [LambdaFunctionAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LambdaFunctionAssociation].
 */
public suspend fun lambdaFunctionAssociation(
    name: String,
    block: suspend LambdaFunctionAssociationResourceBuilder.() -> Unit,
): LambdaFunctionAssociation {
    val builder = LambdaFunctionAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LambdaFunctionAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun lambdaFunctionAssociation(name: String): LambdaFunctionAssociation {
    val builder = LambdaFunctionAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
