@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.PhoneNumberArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Connect Phone Number resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.PhoneNumber("example", {
 *     targetArn: exampleAwsConnectInstance.arn,
 *     countryCode: "US",
 *     type: "DID",
 *     tags: {
 *         hello: "world",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.PhoneNumber("example",
 *     target_arn=example_aws_connect_instance["arn"],
 *     country_code="US",
 *     type="DID",
 *     tags={
 *         "hello": "world",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.PhoneNumber("example", new()
 *     {
 *         TargetArn = exampleAwsConnectInstance.Arn,
 *         CountryCode = "US",
 *         Type = "DID",
 *         Tags =
 *         {
 *             { "hello", "world" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewPhoneNumber(ctx, "example", &connect.PhoneNumberArgs{
 * 			TargetArn:   pulumi.Any(exampleAwsConnectInstance.Arn),
 * 			CountryCode: pulumi.String("US"),
 * 			Type:        pulumi.String("DID"),
 * 			Tags: pulumi.StringMap{
 * 				"hello": pulumi.String("world"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.PhoneNumber;
 * import com.pulumi.aws.connect.PhoneNumberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PhoneNumber("example", PhoneNumberArgs.builder()
 *             .targetArn(exampleAwsConnectInstance.arn())
 *             .countryCode("US")
 *             .type("DID")
 *             .tags(Map.of("hello", "world"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:PhoneNumber
 *     properties:
 *       targetArn: ${exampleAwsConnectInstance.arn}
 *       countryCode: US
 *       type: DID
 *       tags:
 *         hello: world
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Description
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.PhoneNumber("example", {
 *     targetArn: exampleAwsConnectInstance.arn,
 *     countryCode: "US",
 *     type: "DID",
 *     description: "example description",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.PhoneNumber("example",
 *     target_arn=example_aws_connect_instance["arn"],
 *     country_code="US",
 *     type="DID",
 *     description="example description")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.PhoneNumber("example", new()
 *     {
 *         TargetArn = exampleAwsConnectInstance.Arn,
 *         CountryCode = "US",
 *         Type = "DID",
 *         Description = "example description",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewPhoneNumber(ctx, "example", &connect.PhoneNumberArgs{
 * 			TargetArn:   pulumi.Any(exampleAwsConnectInstance.Arn),
 * 			CountryCode: pulumi.String("US"),
 * 			Type:        pulumi.String("DID"),
 * 			Description: pulumi.String("example description"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.PhoneNumber;
 * import com.pulumi.aws.connect.PhoneNumberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PhoneNumber("example", PhoneNumberArgs.builder()
 *             .targetArn(exampleAwsConnectInstance.arn())
 *             .countryCode("US")
 *             .type("DID")
 *             .description("example description")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:PhoneNumber
 *     properties:
 *       targetArn: ${exampleAwsConnectInstance.arn}
 *       countryCode: US
 *       type: DID
 *       description: example description
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Prefix to filter phone numbers
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.PhoneNumber("example", {
 *     targetArn: exampleAwsConnectInstance.arn,
 *     countryCode: "US",
 *     type: "DID",
 *     prefix: "+18005",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.PhoneNumber("example",
 *     target_arn=example_aws_connect_instance["arn"],
 *     country_code="US",
 *     type="DID",
 *     prefix="+18005")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.PhoneNumber("example", new()
 *     {
 *         TargetArn = exampleAwsConnectInstance.Arn,
 *         CountryCode = "US",
 *         Type = "DID",
 *         Prefix = "+18005",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewPhoneNumber(ctx, "example", &connect.PhoneNumberArgs{
 * 			TargetArn:   pulumi.Any(exampleAwsConnectInstance.Arn),
 * 			CountryCode: pulumi.String("US"),
 * 			Type:        pulumi.String("DID"),
 * 			Prefix:      pulumi.String("+18005"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.PhoneNumber;
 * import com.pulumi.aws.connect.PhoneNumberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PhoneNumber("example", PhoneNumberArgs.builder()
 *             .targetArn(exampleAwsConnectInstance.arn())
 *             .countryCode("US")
 *             .type("DID")
 *             .prefix("+18005")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:PhoneNumber
 *     properties:
 *       targetArn: ${exampleAwsConnectInstance.arn}
 *       countryCode: US
 *       type: DID
 *       prefix: '+18005'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amazon Connect Phone Numbers using its `id`. For example:
 * ```sh
 * $ pulumi import aws:connect/phoneNumber:PhoneNumber example 12345678-abcd-1234-efgh-9876543210ab
 * ```
 * @property countryCode The ISO country code. For a list of Valid values, refer to [PhoneNumberCountryCode](https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchAvailablePhoneNumbers.html#connect-SearchAvailablePhoneNumbers-request-PhoneNumberCountryCode).
 * @property description The description of the phone number.
 * @property prefix The prefix of the phone number that is used to filter available phone numbers. If provided, it must contain `+` as part of the country code. Do not specify this argument when importing the resource.
 * @property tags Tags to apply to the Phone Number. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targetArn The Amazon Resource Name (ARN) for Amazon Connect instances that phone numbers are claimed to.
 * @property type The type of phone number. Valid Values: `TOLL_FREE` | `DID`.
 */
public data class PhoneNumberArgs(
    public val countryCode: Output<String>? = null,
    public val description: Output<String>? = null,
    public val prefix: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetArn: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.PhoneNumberArgs> {
    override fun toJava(): com.pulumi.aws.connect.PhoneNumberArgs =
        com.pulumi.aws.connect.PhoneNumberArgs.builder()
            .countryCode(countryCode?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetArn(targetArn?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PhoneNumberArgs].
 */
@PulumiTagMarker
public class PhoneNumberArgsBuilder internal constructor() {
    private var countryCode: Output<String>? = null

    private var description: Output<String>? = null

    private var prefix: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetArn: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The ISO country code. For a list of Valid values, refer to [PhoneNumberCountryCode](https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchAvailablePhoneNumbers.html#connect-SearchAvailablePhoneNumbers-request-PhoneNumberCountryCode).
     */
    @JvmName("kqjaqainaxlxopmm")
    public suspend fun countryCode(`value`: Output<String>) {
        this.countryCode = value
    }

    /**
     * @param value The description of the phone number.
     */
    @JvmName("lqupjjwhflvwyjxw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The prefix of the phone number that is used to filter available phone numbers. If provided, it must contain `+` as part of the country code. Do not specify this argument when importing the resource.
     */
    @JvmName("nckixahknwmhpdcg")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Tags to apply to the Phone Number. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wvildyfrndkehghd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) for Amazon Connect instances that phone numbers are claimed to.
     */
    @JvmName("rdikxcoofgorhlyy")
    public suspend fun targetArn(`value`: Output<String>) {
        this.targetArn = value
    }

    /**
     * @param value The type of phone number. Valid Values: `TOLL_FREE` | `DID`.
     */
    @JvmName("tbhxsrjubxmocvrx")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The ISO country code. For a list of Valid values, refer to [PhoneNumberCountryCode](https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchAvailablePhoneNumbers.html#connect-SearchAvailablePhoneNumbers-request-PhoneNumberCountryCode).
     */
    @JvmName("bahrecogjcoagabk")
    public suspend fun countryCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.countryCode = mapped
    }

    /**
     * @param value The description of the phone number.
     */
    @JvmName("agrqfyhbwngluqrj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The prefix of the phone number that is used to filter available phone numbers. If provided, it must contain `+` as part of the country code. Do not specify this argument when importing the resource.
     */
    @JvmName("rvqsjhcunnsefrox")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Tags to apply to the Phone Number. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("awcyckfecbeaewsr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to apply to the Phone Number. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rkqlfkxgpykvciwx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) for Amazon Connect instances that phone numbers are claimed to.
     */
    @JvmName("fkteshtbujnslqam")
    public suspend fun targetArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetArn = mapped
    }

    /**
     * @param value The type of phone number. Valid Values: `TOLL_FREE` | `DID`.
     */
    @JvmName("egaexwfhsvukopll")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): PhoneNumberArgs = PhoneNumberArgs(
        countryCode = countryCode,
        description = description,
        prefix = prefix,
        tags = tags,
        targetArn = targetArn,
        type = type,
    )
}
