@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.kotlin.outputs.QueueOutboundCallerConfig
import com.pulumi.aws.connect.kotlin.outputs.QueueOutboundCallerConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Queue].
 */
@PulumiTagMarker
public class QueueResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: QueueArgs = QueueArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend QueueArgsBuilder.() -> Unit) {
        val builder = QueueArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Queue {
        val builtJavaResource = com.pulumi.aws.connect.Queue(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Queue(builtJavaResource)
    }
}

/**
 * Provides an Amazon Connect Queue resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.connect.Queue("test", {
 *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name: "Example Name",
 *     description: "Example Description",
 *     hoursOfOperationId: "12345678-1234-1234-1234-123456789012",
 *     tags: {
 *         Name: "Example Queue",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.connect.Queue("test",
 *     instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name="Example Name",
 *     description="Example Description",
 *     hours_of_operation_id="12345678-1234-1234-1234-123456789012",
 *     tags={
 *         "Name": "Example Queue",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Connect.Queue("test", new()
 *     {
 *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *         Name = "Example Name",
 *         Description = "Example Description",
 *         HoursOfOperationId = "12345678-1234-1234-1234-123456789012",
 *         Tags =
 *         {
 *             { "Name", "Example Queue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewQueue(ctx, "test", &connect.QueueArgs{
 * 			InstanceId:         pulumi.String("aaaaaaaa-bbbb-cccc-dddd-111111111111"),
 * 			Name:               pulumi.String("Example Name"),
 * 			Description:        pulumi.String("Example Description"),
 * 			HoursOfOperationId: pulumi.String("12345678-1234-1234-1234-123456789012"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("Example Queue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.Queue;
 * import com.pulumi.aws.connect.QueueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Queue("test", QueueArgs.builder()
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .name("Example Name")
 *             .description("Example Description")
 *             .hoursOfOperationId("12345678-1234-1234-1234-123456789012")
 *             .tags(Map.of("Name", "Example Queue"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:connect:Queue
 *     properties:
 *       instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
 *       name: Example Name
 *       description: Example Description
 *       hoursOfOperationId: 12345678-1234-1234-1234-123456789012
 *       tags:
 *         Name: Example Queue
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Quick Connect IDs
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.connect.Queue("test", {
 *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name: "Example Name",
 *     description: "Example Description",
 *     hoursOfOperationId: "12345678-1234-1234-1234-123456789012",
 *     quickConnectIds: ["12345678-abcd-1234-abcd-123456789012"],
 *     tags: {
 *         Name: "Example Queue with Quick Connect IDs",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.connect.Queue("test",
 *     instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name="Example Name",
 *     description="Example Description",
 *     hours_of_operation_id="12345678-1234-1234-1234-123456789012",
 *     quick_connect_ids=["12345678-abcd-1234-abcd-123456789012"],
 *     tags={
 *         "Name": "Example Queue with Quick Connect IDs",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Connect.Queue("test", new()
 *     {
 *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *         Name = "Example Name",
 *         Description = "Example Description",
 *         HoursOfOperationId = "12345678-1234-1234-1234-123456789012",
 *         QuickConnectIds = new[]
 *         {
 *             "12345678-abcd-1234-abcd-123456789012",
 *         },
 *         Tags =
 *         {
 *             { "Name", "Example Queue with Quick Connect IDs" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewQueue(ctx, "test", &connect.QueueArgs{
 * 			InstanceId:         pulumi.String("aaaaaaaa-bbbb-cccc-dddd-111111111111"),
 * 			Name:               pulumi.String("Example Name"),
 * 			Description:        pulumi.String("Example Description"),
 * 			HoursOfOperationId: pulumi.String("12345678-1234-1234-1234-123456789012"),
 * 			QuickConnectIds: pulumi.StringArray{
 * 				pulumi.String("12345678-abcd-1234-abcd-123456789012"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("Example Queue with Quick Connect IDs"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.Queue;
 * import com.pulumi.aws.connect.QueueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Queue("test", QueueArgs.builder()
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .name("Example Name")
 *             .description("Example Description")
 *             .hoursOfOperationId("12345678-1234-1234-1234-123456789012")
 *             .quickConnectIds("12345678-abcd-1234-abcd-123456789012")
 *             .tags(Map.of("Name", "Example Queue with Quick Connect IDs"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:connect:Queue
 *     properties:
 *       instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
 *       name: Example Name
 *       description: Example Description
 *       hoursOfOperationId: 12345678-1234-1234-1234-123456789012
 *       quickConnectIds:
 *         - 12345678-abcd-1234-abcd-123456789012
 *       tags:
 *         Name: Example Queue with Quick Connect IDs
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Outbound Caller Config
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.connect.Queue("test", {
 *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name: "Example Name",
 *     description: "Example Description",
 *     hoursOfOperationId: "12345678-1234-1234-1234-123456789012",
 *     outboundCallerConfig: {
 *         outboundCallerIdName: "example",
 *         outboundCallerIdNumberId: "12345678-abcd-1234-abcd-123456789012",
 *         outboundFlowId: "87654321-defg-1234-defg-987654321234",
 *     },
 *     tags: {
 *         Name: "Example Queue with Outbound Caller Config",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.connect.Queue("test",
 *     instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name="Example Name",
 *     description="Example Description",
 *     hours_of_operation_id="12345678-1234-1234-1234-123456789012",
 *     outbound_caller_config={
 *         "outbound_caller_id_name": "example",
 *         "outbound_caller_id_number_id": "12345678-abcd-1234-abcd-123456789012",
 *         "outbound_flow_id": "87654321-defg-1234-defg-987654321234",
 *     },
 *     tags={
 *         "Name": "Example Queue with Outbound Caller Config",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Connect.Queue("test", new()
 *     {
 *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *         Name = "Example Name",
 *         Description = "Example Description",
 *         HoursOfOperationId = "12345678-1234-1234-1234-123456789012",
 *         OutboundCallerConfig = new Aws.Connect.Inputs.QueueOutboundCallerConfigArgs
 *         {
 *             OutboundCallerIdName = "example",
 *             OutboundCallerIdNumberId = "12345678-abcd-1234-abcd-123456789012",
 *             OutboundFlowId = "87654321-defg-1234-defg-987654321234",
 *         },
 *         Tags =
 *         {
 *             { "Name", "Example Queue with Outbound Caller Config" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewQueue(ctx, "test", &connect.QueueArgs{
 * 			InstanceId:         pulumi.String("aaaaaaaa-bbbb-cccc-dddd-111111111111"),
 * 			Name:               pulumi.String("Example Name"),
 * 			Description:        pulumi.String("Example Description"),
 * 			HoursOfOperationId: pulumi.String("12345678-1234-1234-1234-123456789012"),
 * 			OutboundCallerConfig: &connect.QueueOutboundCallerConfigArgs{
 * 				OutboundCallerIdName:     pulumi.String("example"),
 * 				OutboundCallerIdNumberId: pulumi.String("12345678-abcd-1234-abcd-123456789012"),
 * 				OutboundFlowId:           pulumi.String("87654321-defg-1234-defg-987654321234"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("Example Queue with Outbound Caller Config"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.Queue;
 * import com.pulumi.aws.connect.QueueArgs;
 * import com.pulumi.aws.connect.inputs.QueueOutboundCallerConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Queue("test", QueueArgs.builder()
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .name("Example Name")
 *             .description("Example Description")
 *             .hoursOfOperationId("12345678-1234-1234-1234-123456789012")
 *             .outboundCallerConfig(QueueOutboundCallerConfigArgs.builder()
 *                 .outboundCallerIdName("example")
 *                 .outboundCallerIdNumberId("12345678-abcd-1234-abcd-123456789012")
 *                 .outboundFlowId("87654321-defg-1234-defg-987654321234")
 *                 .build())
 *             .tags(Map.of("Name", "Example Queue with Outbound Caller Config"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:connect:Queue
 *     properties:
 *       instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
 *       name: Example Name
 *       description: Example Description
 *       hoursOfOperationId: 12345678-1234-1234-1234-123456789012
 *       outboundCallerConfig:
 *         outboundCallerIdName: example
 *         outboundCallerIdNumberId: 12345678-abcd-1234-abcd-123456789012
 *         outboundFlowId: 87654321-defg-1234-defg-987654321234
 *       tags:
 *         Name: Example Queue with Outbound Caller Config
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amazon Connect Queues using the `instance_id` and `queue_id` separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:connect/queue:Queue example f1288a1f-6193-445a-b47e-af739b2:c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5
 * ```
 */
public class Queue internal constructor(
    override val javaResource: com.pulumi.aws.connect.Queue,
) : KotlinCustomResource(javaResource, QueueMapper) {
    /**
     * The Amazon Resource Name (ARN) of the Queue.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Specifies the description of the Queue.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the identifier of the Hours of Operation.
     */
    public val hoursOfOperationId: Output<String>
        get() = javaResource.hoursOfOperationId().applyValue({ args0 -> args0 })

    /**
     * Specifies the identifier of the hosting Amazon Connect Instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * Specifies the maximum number of contacts that can be in the queue before it is considered full. Minimum value of 0.
     */
    public val maxContacts: Output<Int>?
        get() = javaResource.maxContacts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the name of the Queue.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A block that defines the outbound caller ID name, number, and outbound whisper flow. The Outbound Caller Config block is documented below.
     */
    public val outboundCallerConfig: Output<QueueOutboundCallerConfig>?
        get() = javaResource.outboundCallerConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The identifier for the Queue.
     */
    public val queueId: Output<String>
        get() = javaResource.queueId().applyValue({ args0 -> args0 })

    /**
     * Specifies a list of quick connects ids that determine the quick connects available to agents who are working the queue.
     */
    public val quickConnectIds: Output<List<String>>?
        get() = javaResource.quickConnectIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Specifies the description of the Queue. Valid values are `ENABLED`, `DISABLED`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Tags to apply to the Queue. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object QueueMapper : ResourceMapper<Queue> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.connect.Queue::class == javaResource::class

    override fun map(javaResource: Resource): Queue = Queue(
        javaResource as
            com.pulumi.aws.connect.Queue,
    )
}

/**
 * @see [Queue].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Queue].
 */
public suspend fun queue(name: String, block: suspend QueueResourceBuilder.() -> Unit): Queue {
    val builder = QueueResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Queue].
 * @param name The _unique_ name of the resulting resource.
 */
public fun queue(name: String): Queue {
    val builder = QueueResourceBuilder()
    builder.name(name)
    return builder.build()
}
