@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.QueueArgs.builder
import com.pulumi.aws.connect.kotlin.inputs.QueueOutboundCallerConfigArgs
import com.pulumi.aws.connect.kotlin.inputs.QueueOutboundCallerConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Connect Queue resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.connect.Queue("test", {
 *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name: "Example Name",
 *     description: "Example Description",
 *     hoursOfOperationId: "12345678-1234-1234-1234-123456789012",
 *     tags: {
 *         Name: "Example Queue",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.connect.Queue("test",
 *     instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name="Example Name",
 *     description="Example Description",
 *     hours_of_operation_id="12345678-1234-1234-1234-123456789012",
 *     tags={
 *         "Name": "Example Queue",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Connect.Queue("test", new()
 *     {
 *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *         Name = "Example Name",
 *         Description = "Example Description",
 *         HoursOfOperationId = "12345678-1234-1234-1234-123456789012",
 *         Tags =
 *         {
 *             { "Name", "Example Queue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewQueue(ctx, "test", &connect.QueueArgs{
 * 			InstanceId:         pulumi.String("aaaaaaaa-bbbb-cccc-dddd-111111111111"),
 * 			Name:               pulumi.String("Example Name"),
 * 			Description:        pulumi.String("Example Description"),
 * 			HoursOfOperationId: pulumi.String("12345678-1234-1234-1234-123456789012"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("Example Queue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.Queue;
 * import com.pulumi.aws.connect.QueueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Queue("test", QueueArgs.builder()
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .name("Example Name")
 *             .description("Example Description")
 *             .hoursOfOperationId("12345678-1234-1234-1234-123456789012")
 *             .tags(Map.of("Name", "Example Queue"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:connect:Queue
 *     properties:
 *       instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
 *       name: Example Name
 *       description: Example Description
 *       hoursOfOperationId: 12345678-1234-1234-1234-123456789012
 *       tags:
 *         Name: Example Queue
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Quick Connect IDs
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.connect.Queue("test", {
 *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name: "Example Name",
 *     description: "Example Description",
 *     hoursOfOperationId: "12345678-1234-1234-1234-123456789012",
 *     quickConnectIds: ["12345678-abcd-1234-abcd-123456789012"],
 *     tags: {
 *         Name: "Example Queue with Quick Connect IDs",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.connect.Queue("test",
 *     instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name="Example Name",
 *     description="Example Description",
 *     hours_of_operation_id="12345678-1234-1234-1234-123456789012",
 *     quick_connect_ids=["12345678-abcd-1234-abcd-123456789012"],
 *     tags={
 *         "Name": "Example Queue with Quick Connect IDs",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Connect.Queue("test", new()
 *     {
 *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *         Name = "Example Name",
 *         Description = "Example Description",
 *         HoursOfOperationId = "12345678-1234-1234-1234-123456789012",
 *         QuickConnectIds = new[]
 *         {
 *             "12345678-abcd-1234-abcd-123456789012",
 *         },
 *         Tags =
 *         {
 *             { "Name", "Example Queue with Quick Connect IDs" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewQueue(ctx, "test", &connect.QueueArgs{
 * 			InstanceId:         pulumi.String("aaaaaaaa-bbbb-cccc-dddd-111111111111"),
 * 			Name:               pulumi.String("Example Name"),
 * 			Description:        pulumi.String("Example Description"),
 * 			HoursOfOperationId: pulumi.String("12345678-1234-1234-1234-123456789012"),
 * 			QuickConnectIds: pulumi.StringArray{
 * 				pulumi.String("12345678-abcd-1234-abcd-123456789012"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("Example Queue with Quick Connect IDs"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.Queue;
 * import com.pulumi.aws.connect.QueueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Queue("test", QueueArgs.builder()
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .name("Example Name")
 *             .description("Example Description")
 *             .hoursOfOperationId("12345678-1234-1234-1234-123456789012")
 *             .quickConnectIds("12345678-abcd-1234-abcd-123456789012")
 *             .tags(Map.of("Name", "Example Queue with Quick Connect IDs"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:connect:Queue
 *     properties:
 *       instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
 *       name: Example Name
 *       description: Example Description
 *       hoursOfOperationId: 12345678-1234-1234-1234-123456789012
 *       quickConnectIds:
 *         - 12345678-abcd-1234-abcd-123456789012
 *       tags:
 *         Name: Example Queue with Quick Connect IDs
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Outbound Caller Config
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.connect.Queue("test", {
 *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name: "Example Name",
 *     description: "Example Description",
 *     hoursOfOperationId: "12345678-1234-1234-1234-123456789012",
 *     outboundCallerConfig: {
 *         outboundCallerIdName: "example",
 *         outboundCallerIdNumberId: "12345678-abcd-1234-abcd-123456789012",
 *         outboundFlowId: "87654321-defg-1234-defg-987654321234",
 *     },
 *     tags: {
 *         Name: "Example Queue with Outbound Caller Config",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.connect.Queue("test",
 *     instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name="Example Name",
 *     description="Example Description",
 *     hours_of_operation_id="12345678-1234-1234-1234-123456789012",
 *     outbound_caller_config={
 *         "outbound_caller_id_name": "example",
 *         "outbound_caller_id_number_id": "12345678-abcd-1234-abcd-123456789012",
 *         "outbound_flow_id": "87654321-defg-1234-defg-987654321234",
 *     },
 *     tags={
 *         "Name": "Example Queue with Outbound Caller Config",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Connect.Queue("test", new()
 *     {
 *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *         Name = "Example Name",
 *         Description = "Example Description",
 *         HoursOfOperationId = "12345678-1234-1234-1234-123456789012",
 *         OutboundCallerConfig = new Aws.Connect.Inputs.QueueOutboundCallerConfigArgs
 *         {
 *             OutboundCallerIdName = "example",
 *             OutboundCallerIdNumberId = "12345678-abcd-1234-abcd-123456789012",
 *             OutboundFlowId = "87654321-defg-1234-defg-987654321234",
 *         },
 *         Tags =
 *         {
 *             { "Name", "Example Queue with Outbound Caller Config" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewQueue(ctx, "test", &connect.QueueArgs{
 * 			InstanceId:         pulumi.String("aaaaaaaa-bbbb-cccc-dddd-111111111111"),
 * 			Name:               pulumi.String("Example Name"),
 * 			Description:        pulumi.String("Example Description"),
 * 			HoursOfOperationId: pulumi.String("12345678-1234-1234-1234-123456789012"),
 * 			OutboundCallerConfig: &connect.QueueOutboundCallerConfigArgs{
 * 				OutboundCallerIdName:     pulumi.String("example"),
 * 				OutboundCallerIdNumberId: pulumi.String("12345678-abcd-1234-abcd-123456789012"),
 * 				OutboundFlowId:           pulumi.String("87654321-defg-1234-defg-987654321234"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("Example Queue with Outbound Caller Config"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.Queue;
 * import com.pulumi.aws.connect.QueueArgs;
 * import com.pulumi.aws.connect.inputs.QueueOutboundCallerConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Queue("test", QueueArgs.builder()
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .name("Example Name")
 *             .description("Example Description")
 *             .hoursOfOperationId("12345678-1234-1234-1234-123456789012")
 *             .outboundCallerConfig(QueueOutboundCallerConfigArgs.builder()
 *                 .outboundCallerIdName("example")
 *                 .outboundCallerIdNumberId("12345678-abcd-1234-abcd-123456789012")
 *                 .outboundFlowId("87654321-defg-1234-defg-987654321234")
 *                 .build())
 *             .tags(Map.of("Name", "Example Queue with Outbound Caller Config"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:connect:Queue
 *     properties:
 *       instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
 *       name: Example Name
 *       description: Example Description
 *       hoursOfOperationId: 12345678-1234-1234-1234-123456789012
 *       outboundCallerConfig:
 *         outboundCallerIdName: example
 *         outboundCallerIdNumberId: 12345678-abcd-1234-abcd-123456789012
 *         outboundFlowId: 87654321-defg-1234-defg-987654321234
 *       tags:
 *         Name: Example Queue with Outbound Caller Config
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amazon Connect Queues using the `instance_id` and `queue_id` separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:connect/queue:Queue example f1288a1f-6193-445a-b47e-af739b2:c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5
 * ```
 * @property description Specifies the description of the Queue.
 * @property hoursOfOperationId Specifies the identifier of the Hours of Operation.
 * @property instanceId Specifies the identifier of the hosting Amazon Connect Instance.
 * @property maxContacts Specifies the maximum number of contacts that can be in the queue before it is considered full. Minimum value of 0.
 * @property name Specifies the name of the Queue.
 * @property outboundCallerConfig A block that defines the outbound caller ID name, number, and outbound whisper flow. The Outbound Caller Config block is documented below.
 * @property quickConnectIds Specifies a list of quick connects ids that determine the quick connects available to agents who are working the queue.
 * @property status Specifies the description of the Queue. Valid values are `ENABLED`, `DISABLED`.
 * @property tags Tags to apply to the Queue. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class QueueArgs(
    public val description: Output<String>? = null,
    public val hoursOfOperationId: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val maxContacts: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val outboundCallerConfig: Output<QueueOutboundCallerConfigArgs>? = null,
    public val quickConnectIds: Output<List<String>>? = null,
    public val status: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.QueueArgs> {
    override fun toJava(): com.pulumi.aws.connect.QueueArgs =
        com.pulumi.aws.connect.QueueArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .hoursOfOperationId(hoursOfOperationId?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .maxContacts(maxContacts?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .outboundCallerConfig(
                outboundCallerConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .quickConnectIds(quickConnectIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [QueueArgs].
 */
@PulumiTagMarker
public class QueueArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var hoursOfOperationId: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var maxContacts: Output<Int>? = null

    private var name: Output<String>? = null

    private var outboundCallerConfig: Output<QueueOutboundCallerConfigArgs>? = null

    private var quickConnectIds: Output<List<String>>? = null

    private var status: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies the description of the Queue.
     */
    @JvmName("txilomdpmftedrtd")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies the identifier of the Hours of Operation.
     */
    @JvmName("skiypkuhqdnajiqa")
    public suspend fun hoursOfOperationId(`value`: Output<String>) {
        this.hoursOfOperationId = value
    }

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("ifyafeeacbnotymx")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value Specifies the maximum number of contacts that can be in the queue before it is considered full. Minimum value of 0.
     */
    @JvmName("gkbuclflhyniipub")
    public suspend fun maxContacts(`value`: Output<Int>) {
        this.maxContacts = value
    }

    /**
     * @param value Specifies the name of the Queue.
     */
    @JvmName("hpdefcbyxnwjirpd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A block that defines the outbound caller ID name, number, and outbound whisper flow. The Outbound Caller Config block is documented below.
     */
    @JvmName("obquidkklxfqyxhy")
    public suspend fun outboundCallerConfig(`value`: Output<QueueOutboundCallerConfigArgs>) {
        this.outboundCallerConfig = value
    }

    /**
     * @param value Specifies a list of quick connects ids that determine the quick connects available to agents who are working the queue.
     */
    @JvmName("skpkkjvuxigduilc")
    public suspend fun quickConnectIds(`value`: Output<List<String>>) {
        this.quickConnectIds = value
    }

    @JvmName("gfyeanmuixrrgmju")
    public suspend fun quickConnectIds(vararg values: Output<String>) {
        this.quickConnectIds = Output.all(values.asList())
    }

    /**
     * @param values Specifies a list of quick connects ids that determine the quick connects available to agents who are working the queue.
     */
    @JvmName("tlsgujitxtrweqoy")
    public suspend fun quickConnectIds(values: List<Output<String>>) {
        this.quickConnectIds = Output.all(values)
    }

    /**
     * @param value Specifies the description of the Queue. Valid values are `ENABLED`, `DISABLED`.
     */
    @JvmName("vjqtrhfaskorbhxl")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Tags to apply to the Queue. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mbmtkijaodhadojb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the description of the Queue.
     */
    @JvmName("mwpnkyjgdritqjln")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies the identifier of the Hours of Operation.
     */
    @JvmName("jccqyaifbpooaqyy")
    public suspend fun hoursOfOperationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hoursOfOperationId = mapped
    }

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("lneqybxdbwksvcae")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value Specifies the maximum number of contacts that can be in the queue before it is considered full. Minimum value of 0.
     */
    @JvmName("qffshpcsjwnqlhdo")
    public suspend fun maxContacts(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxContacts = mapped
    }

    /**
     * @param value Specifies the name of the Queue.
     */
    @JvmName("nttbcotnfjxwmfyu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A block that defines the outbound caller ID name, number, and outbound whisper flow. The Outbound Caller Config block is documented below.
     */
    @JvmName("owxmxpkdqpqiucem")
    public suspend fun outboundCallerConfig(`value`: QueueOutboundCallerConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outboundCallerConfig = mapped
    }

    /**
     * @param argument A block that defines the outbound caller ID name, number, and outbound whisper flow. The Outbound Caller Config block is documented below.
     */
    @JvmName("djiaeeadgcgesyxk")
    public suspend fun outboundCallerConfig(argument: suspend QueueOutboundCallerConfigArgsBuilder.() -> Unit) {
        val toBeMapped = QueueOutboundCallerConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.outboundCallerConfig = mapped
    }

    /**
     * @param value Specifies a list of quick connects ids that determine the quick connects available to agents who are working the queue.
     */
    @JvmName("wnkwghfieegdwlqj")
    public suspend fun quickConnectIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quickConnectIds = mapped
    }

    /**
     * @param values Specifies a list of quick connects ids that determine the quick connects available to agents who are working the queue.
     */
    @JvmName("joiaseumgsqmvivm")
    public suspend fun quickConnectIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.quickConnectIds = mapped
    }

    /**
     * @param value Specifies the description of the Queue. Valid values are `ENABLED`, `DISABLED`.
     */
    @JvmName("lxiysejavjdhgjfs")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Tags to apply to the Queue. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("buwghoftapexxpaj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to apply to the Queue. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pkkurthmmcmtckug")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): QueueArgs = QueueArgs(
        description = description,
        hoursOfOperationId = hoursOfOperationId,
        instanceId = instanceId,
        maxContacts = maxContacts,
        name = name,
        outboundCallerConfig = outboundCallerConfig,
        quickConnectIds = quickConnectIds,
        status = status,
        tags = tags,
    )
}
