@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.QuickConnectArgs.builder
import com.pulumi.aws.connect.kotlin.inputs.QuickConnectQuickConnectConfigArgs
import com.pulumi.aws.connect.kotlin.inputs.QuickConnectQuickConnectConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Connect Quick Connect resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.connect.QuickConnect("test", {
 *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name: "Example Name",
 *     description: "quick connect phone number",
 *     quickConnectConfig: {
 *         quickConnectType: "PHONE_NUMBER",
 *         phoneConfigs: [{
 *             phoneNumber: "+12345678912",
 *         }],
 *     },
 *     tags: {
 *         Name: "Example Quick Connect",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.connect.QuickConnect("test",
 *     instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name="Example Name",
 *     description="quick connect phone number",
 *     quick_connect_config={
 *         "quick_connect_type": "PHONE_NUMBER",
 *         "phone_configs": [{
 *             "phone_number": "+12345678912",
 *         }],
 *     },
 *     tags={
 *         "Name": "Example Quick Connect",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Connect.QuickConnect("test", new()
 *     {
 *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *         Name = "Example Name",
 *         Description = "quick connect phone number",
 *         QuickConnectConfig = new Aws.Connect.Inputs.QuickConnectQuickConnectConfigArgs
 *         {
 *             QuickConnectType = "PHONE_NUMBER",
 *             PhoneConfigs = new[]
 *             {
 *                 new Aws.Connect.Inputs.QuickConnectQuickConnectConfigPhoneConfigArgs
 *                 {
 *                     PhoneNumber = "+12345678912",
 *                 },
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Name", "Example Quick Connect" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewQuickConnect(ctx, "test", &connect.QuickConnectArgs{
 * 			InstanceId:  pulumi.String("aaaaaaaa-bbbb-cccc-dddd-111111111111"),
 * 			Name:        pulumi.String("Example Name"),
 * 			Description: pulumi.String("quick connect phone number"),
 * 			QuickConnectConfig: &connect.QuickConnectQuickConnectConfigArgs{
 * 				QuickConnectType: pulumi.String("PHONE_NUMBER"),
 * 				PhoneConfigs: connect.QuickConnectQuickConnectConfigPhoneConfigArray{
 * 					&connect.QuickConnectQuickConnectConfigPhoneConfigArgs{
 * 						PhoneNumber: pulumi.String("+12345678912"),
 * 					},
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("Example Quick Connect"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.QuickConnect;
 * import com.pulumi.aws.connect.QuickConnectArgs;
 * import com.pulumi.aws.connect.inputs.QuickConnectQuickConnectConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new QuickConnect("test", QuickConnectArgs.builder()
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .name("Example Name")
 *             .description("quick connect phone number")
 *             .quickConnectConfig(QuickConnectQuickConnectConfigArgs.builder()
 *                 .quickConnectType("PHONE_NUMBER")
 *                 .phoneConfigs(QuickConnectQuickConnectConfigPhoneConfigArgs.builder()
 *                     .phoneNumber("+12345678912")
 *                     .build())
 *                 .build())
 *             .tags(Map.of("Name", "Example Quick Connect"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:connect:QuickConnect
 *     properties:
 *       instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
 *       name: Example Name
 *       description: quick connect phone number
 *       quickConnectConfig:
 *         quickConnectType: PHONE_NUMBER
 *         phoneConfigs:
 *           - phoneNumber: '+12345678912'
 *       tags:
 *         Name: Example Quick Connect
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amazon Connect Quick Connects using the `instance_id` and `quick_connect_id` separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:connect/quickConnect:QuickConnect example f1288a1f-6193-445a-b47e-af739b2:c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5
 * ```
 * @property description Specifies the description of the Quick Connect.
 * @property instanceId Specifies the identifier of the hosting Amazon Connect Instance.
 * @property name Specifies the name of the Quick Connect.
 * @property quickConnectConfig A block that defines the configuration information for the Quick Connect: `quick_connect_type` and one of `phone_config`, `queue_config`, `user_config` . The Quick Connect Config block is documented below.
 * @property tags Tags to apply to the Quick Connect. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class QuickConnectArgs(
    public val description: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val quickConnectConfig: Output<QuickConnectQuickConnectConfigArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.QuickConnectArgs> {
    override fun toJava(): com.pulumi.aws.connect.QuickConnectArgs =
        com.pulumi.aws.connect.QuickConnectArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .quickConnectConfig(
                quickConnectConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [QuickConnectArgs].
 */
@PulumiTagMarker
public class QuickConnectArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var name: Output<String>? = null

    private var quickConnectConfig: Output<QuickConnectQuickConnectConfigArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies the description of the Quick Connect.
     */
    @JvmName("rmunjfjlxosombms")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("wjxngkusosnfupui")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value Specifies the name of the Quick Connect.
     */
    @JvmName("vpstgakgeyauctfd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A block that defines the configuration information for the Quick Connect: `quick_connect_type` and one of `phone_config`, `queue_config`, `user_config` . The Quick Connect Config block is documented below.
     */
    @JvmName("keyrnvgkwvcsoqlj")
    public suspend fun quickConnectConfig(`value`: Output<QuickConnectQuickConnectConfigArgs>) {
        this.quickConnectConfig = value
    }

    /**
     * @param value Tags to apply to the Quick Connect. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hldirhxbfxokiiud")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the description of the Quick Connect.
     */
    @JvmName("jfiudqyovuxdioyn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("nooudympihmnjyrw")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value Specifies the name of the Quick Connect.
     */
    @JvmName("hlsyxslnvpohebuk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A block that defines the configuration information for the Quick Connect: `quick_connect_type` and one of `phone_config`, `queue_config`, `user_config` . The Quick Connect Config block is documented below.
     */
    @JvmName("kduyatdmdblaaqrc")
    public suspend fun quickConnectConfig(`value`: QuickConnectQuickConnectConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quickConnectConfig = mapped
    }

    /**
     * @param argument A block that defines the configuration information for the Quick Connect: `quick_connect_type` and one of `phone_config`, `queue_config`, `user_config` . The Quick Connect Config block is documented below.
     */
    @JvmName("nlbueydhjkhjtpsa")
    public suspend fun quickConnectConfig(argument: suspend QuickConnectQuickConnectConfigArgsBuilder.() -> Unit) {
        val toBeMapped = QuickConnectQuickConnectConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.quickConnectConfig = mapped
    }

    /**
     * @param value Tags to apply to the Quick Connect. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iremggwieulmnokv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to apply to the Quick Connect. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("clwjskvlfaqiwqsm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): QuickConnectArgs = QuickConnectArgs(
        description = description,
        instanceId = instanceId,
        name = name,
        quickConnectConfig = quickConnectConfig,
        tags = tags,
    )
}
