@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.kotlin.outputs.RoutingProfileMediaConcurrency
import com.pulumi.aws.connect.kotlin.outputs.RoutingProfileQueueConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.connect.kotlin.outputs.RoutingProfileMediaConcurrency.Companion.toKotlin as routingProfileMediaConcurrencyToKotlin
import com.pulumi.aws.connect.kotlin.outputs.RoutingProfileQueueConfig.Companion.toKotlin as routingProfileQueueConfigToKotlin

/**
 * Builder for [RoutingProfile].
 */
@PulumiTagMarker
public class RoutingProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RoutingProfileArgs = RoutingProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RoutingProfileArgsBuilder.() -> Unit) {
        val builder = RoutingProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RoutingProfile {
        val builtJavaResource = com.pulumi.aws.connect.RoutingProfile(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RoutingProfile(builtJavaResource)
    }
}

/**
 * Provides an Amazon Connect Routing Profile resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.RoutingProfile("example", {
 *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name: "example",
 *     defaultOutboundQueueId: "12345678-1234-1234-1234-123456789012",
 *     description: "example description",
 *     mediaConcurrencies: [{
 *         channel: "VOICE",
 *         concurrency: 1,
 *     }],
 *     queueConfigs: [{
 *         channel: "VOICE",
 *         delay: 2,
 *         priority: 1,
 *         queueId: "12345678-1234-1234-1234-123456789012",
 *     }],
 *     tags: {
 *         Name: "Example Routing Profile",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.RoutingProfile("example",
 *     instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name="example",
 *     default_outbound_queue_id="12345678-1234-1234-1234-123456789012",
 *     description="example description",
 *     media_concurrencies=[{
 *         "channel": "VOICE",
 *         "concurrency": 1,
 *     }],
 *     queue_configs=[{
 *         "channel": "VOICE",
 *         "delay": 2,
 *         "priority": 1,
 *         "queue_id": "12345678-1234-1234-1234-123456789012",
 *     }],
 *     tags={
 *         "Name": "Example Routing Profile",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.RoutingProfile("example", new()
 *     {
 *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *         Name = "example",
 *         DefaultOutboundQueueId = "12345678-1234-1234-1234-123456789012",
 *         Description = "example description",
 *         MediaConcurrencies = new[]
 *         {
 *             new Aws.Connect.Inputs.RoutingProfileMediaConcurrencyArgs
 *             {
 *                 Channel = "VOICE",
 *                 Concurrency = 1,
 *             },
 *         },
 *         QueueConfigs = new[]
 *         {
 *             new Aws.Connect.Inputs.RoutingProfileQueueConfigArgs
 *             {
 *                 Channel = "VOICE",
 *                 Delay = 2,
 *                 Priority = 1,
 *                 QueueId = "12345678-1234-1234-1234-123456789012",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Name", "Example Routing Profile" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewRoutingProfile(ctx, "example", &connect.RoutingProfileArgs{
 * 			InstanceId:             pulumi.String("aaaaaaaa-bbbb-cccc-dddd-111111111111"),
 * 			Name:                   pulumi.String("example"),
 * 			DefaultOutboundQueueId: pulumi.String("12345678-1234-1234-1234-123456789012"),
 * 			Description:            pulumi.String("example description"),
 * 			MediaConcurrencies: connect.RoutingProfileMediaConcurrencyArray{
 * 				&connect.RoutingProfileMediaConcurrencyArgs{
 * 					Channel:     pulumi.String("VOICE"),
 * 					Concurrency: pulumi.Int(1),
 * 				},
 * 			},
 * 			QueueConfigs: connect.RoutingProfileQueueConfigArray{
 * 				&connect.RoutingProfileQueueConfigArgs{
 * 					Channel:  pulumi.String("VOICE"),
 * 					Delay:    pulumi.Int(2),
 * 					Priority: pulumi.Int(1),
 * 					QueueId:  pulumi.String("12345678-1234-1234-1234-123456789012"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("Example Routing Profile"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.RoutingProfile;
 * import com.pulumi.aws.connect.RoutingProfileArgs;
 * import com.pulumi.aws.connect.inputs.RoutingProfileMediaConcurrencyArgs;
 * import com.pulumi.aws.connect.inputs.RoutingProfileQueueConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RoutingProfile("example", RoutingProfileArgs.builder()
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .name("example")
 *             .defaultOutboundQueueId("12345678-1234-1234-1234-123456789012")
 *             .description("example description")
 *             .mediaConcurrencies(RoutingProfileMediaConcurrencyArgs.builder()
 *                 .channel("VOICE")
 *                 .concurrency(1)
 *                 .build())
 *             .queueConfigs(RoutingProfileQueueConfigArgs.builder()
 *                 .channel("VOICE")
 *                 .delay(2)
 *                 .priority(1)
 *                 .queueId("12345678-1234-1234-1234-123456789012")
 *                 .build())
 *             .tags(Map.of("Name", "Example Routing Profile"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:RoutingProfile
 *     properties:
 *       instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
 *       name: example
 *       defaultOutboundQueueId: 12345678-1234-1234-1234-123456789012
 *       description: example description
 *       mediaConcurrencies:
 *         - channel: VOICE
 *           concurrency: 1
 *       queueConfigs:
 *         - channel: VOICE
 *           delay: 2
 *           priority: 1
 *           queueId: 12345678-1234-1234-1234-123456789012
 *       tags:
 *         Name: Example Routing Profile
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amazon Connect Routing Profiles using the `instance_id` and `routing_profile_id` separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:connect/routingProfile:RoutingProfile example f1288a1f-6193-445a-b47e-af739b2:c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5
 * ```
 */
public class RoutingProfile internal constructor(
    override val javaResource: com.pulumi.aws.connect.RoutingProfile,
) : KotlinCustomResource(javaResource, RoutingProfileMapper) {
    /**
     * The Amazon Resource Name (ARN) of the Routing Profile.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Specifies the default outbound queue for the Routing Profile.
     */
    public val defaultOutboundQueueId: Output<String>
        get() = javaResource.defaultOutboundQueueId().applyValue({ args0 -> args0 })

    /**
     * Specifies the description of the Routing Profile.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Specifies the identifier of the hosting Amazon Connect Instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * One or more `media_concurrencies` blocks that specify the channels that agents can handle in the Contact Control Panel (CCP) for this Routing Profile. The `media_concurrencies` block is documented below.
     */
    public val mediaConcurrencies: Output<List<RoutingProfileMediaConcurrency>>
        get() = javaResource.mediaConcurrencies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> routingProfileMediaConcurrencyToKotlin(args0) })
            })
        })

    /**
     * Specifies the name of the Routing Profile.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * One or more `queue_configs` blocks that specify the inbound queues associated with the routing profile. If no queue is added, the agent only can make outbound calls. The `queue_configs` block is documented below.
     */
    public val queueConfigs: Output<List<RoutingProfileQueueConfig>>?
        get() = javaResource.queueConfigs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> routingProfileQueueConfigToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The identifier for the Routing Profile.
     */
    public val routingProfileId: Output<String>
        get() = javaResource.routingProfileId().applyValue({ args0 -> args0 })

    /**
     * Tags to apply to the Routing Profile. If configured with a provider
     * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object RoutingProfileMapper : ResourceMapper<RoutingProfile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.connect.RoutingProfile::class == javaResource::class

    override fun map(javaResource: Resource): RoutingProfile = RoutingProfile(
        javaResource as
            com.pulumi.aws.connect.RoutingProfile,
    )
}

/**
 * @see [RoutingProfile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RoutingProfile].
 */
public suspend fun routingProfile(
    name: String,
    block: suspend RoutingProfileResourceBuilder.() -> Unit,
): RoutingProfile {
    val builder = RoutingProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RoutingProfile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun routingProfile(name: String): RoutingProfile {
    val builder = RoutingProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
