@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.RoutingProfileArgs.builder
import com.pulumi.aws.connect.kotlin.inputs.RoutingProfileMediaConcurrencyArgs
import com.pulumi.aws.connect.kotlin.inputs.RoutingProfileMediaConcurrencyArgsBuilder
import com.pulumi.aws.connect.kotlin.inputs.RoutingProfileQueueConfigArgs
import com.pulumi.aws.connect.kotlin.inputs.RoutingProfileQueueConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Connect Routing Profile resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.RoutingProfile("example", {
 *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name: "example",
 *     defaultOutboundQueueId: "12345678-1234-1234-1234-123456789012",
 *     description: "example description",
 *     mediaConcurrencies: [{
 *         channel: "VOICE",
 *         concurrency: 1,
 *     }],
 *     queueConfigs: [{
 *         channel: "VOICE",
 *         delay: 2,
 *         priority: 1,
 *         queueId: "12345678-1234-1234-1234-123456789012",
 *     }],
 *     tags: {
 *         Name: "Example Routing Profile",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.RoutingProfile("example",
 *     instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name="example",
 *     default_outbound_queue_id="12345678-1234-1234-1234-123456789012",
 *     description="example description",
 *     media_concurrencies=[{
 *         "channel": "VOICE",
 *         "concurrency": 1,
 *     }],
 *     queue_configs=[{
 *         "channel": "VOICE",
 *         "delay": 2,
 *         "priority": 1,
 *         "queue_id": "12345678-1234-1234-1234-123456789012",
 *     }],
 *     tags={
 *         "Name": "Example Routing Profile",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.RoutingProfile("example", new()
 *     {
 *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *         Name = "example",
 *         DefaultOutboundQueueId = "12345678-1234-1234-1234-123456789012",
 *         Description = "example description",
 *         MediaConcurrencies = new[]
 *         {
 *             new Aws.Connect.Inputs.RoutingProfileMediaConcurrencyArgs
 *             {
 *                 Channel = "VOICE",
 *                 Concurrency = 1,
 *             },
 *         },
 *         QueueConfigs = new[]
 *         {
 *             new Aws.Connect.Inputs.RoutingProfileQueueConfigArgs
 *             {
 *                 Channel = "VOICE",
 *                 Delay = 2,
 *                 Priority = 1,
 *                 QueueId = "12345678-1234-1234-1234-123456789012",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Name", "Example Routing Profile" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewRoutingProfile(ctx, "example", &connect.RoutingProfileArgs{
 * 			InstanceId:             pulumi.String("aaaaaaaa-bbbb-cccc-dddd-111111111111"),
 * 			Name:                   pulumi.String("example"),
 * 			DefaultOutboundQueueId: pulumi.String("12345678-1234-1234-1234-123456789012"),
 * 			Description:            pulumi.String("example description"),
 * 			MediaConcurrencies: connect.RoutingProfileMediaConcurrencyArray{
 * 				&connect.RoutingProfileMediaConcurrencyArgs{
 * 					Channel:     pulumi.String("VOICE"),
 * 					Concurrency: pulumi.Int(1),
 * 				},
 * 			},
 * 			QueueConfigs: connect.RoutingProfileQueueConfigArray{
 * 				&connect.RoutingProfileQueueConfigArgs{
 * 					Channel:  pulumi.String("VOICE"),
 * 					Delay:    pulumi.Int(2),
 * 					Priority: pulumi.Int(1),
 * 					QueueId:  pulumi.String("12345678-1234-1234-1234-123456789012"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("Example Routing Profile"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.RoutingProfile;
 * import com.pulumi.aws.connect.RoutingProfileArgs;
 * import com.pulumi.aws.connect.inputs.RoutingProfileMediaConcurrencyArgs;
 * import com.pulumi.aws.connect.inputs.RoutingProfileQueueConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RoutingProfile("example", RoutingProfileArgs.builder()
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .name("example")
 *             .defaultOutboundQueueId("12345678-1234-1234-1234-123456789012")
 *             .description("example description")
 *             .mediaConcurrencies(RoutingProfileMediaConcurrencyArgs.builder()
 *                 .channel("VOICE")
 *                 .concurrency(1)
 *                 .build())
 *             .queueConfigs(RoutingProfileQueueConfigArgs.builder()
 *                 .channel("VOICE")
 *                 .delay(2)
 *                 .priority(1)
 *                 .queueId("12345678-1234-1234-1234-123456789012")
 *                 .build())
 *             .tags(Map.of("Name", "Example Routing Profile"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:RoutingProfile
 *     properties:
 *       instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
 *       name: example
 *       defaultOutboundQueueId: 12345678-1234-1234-1234-123456789012
 *       description: example description
 *       mediaConcurrencies:
 *         - channel: VOICE
 *           concurrency: 1
 *       queueConfigs:
 *         - channel: VOICE
 *           delay: 2
 *           priority: 1
 *           queueId: 12345678-1234-1234-1234-123456789012
 *       tags:
 *         Name: Example Routing Profile
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amazon Connect Routing Profiles using the `instance_id` and `routing_profile_id` separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:connect/routingProfile:RoutingProfile example f1288a1f-6193-445a-b47e-af739b2:c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5
 * ```
 * @property defaultOutboundQueueId Specifies the default outbound queue for the Routing Profile.
 * @property description Specifies the description of the Routing Profile.
 * @property instanceId Specifies the identifier of the hosting Amazon Connect Instance.
 * @property mediaConcurrencies One or more `media_concurrencies` blocks that specify the channels that agents can handle in the Contact Control Panel (CCP) for this Routing Profile. The `media_concurrencies` block is documented below.
 * @property name Specifies the name of the Routing Profile.
 * @property queueConfigs One or more `queue_configs` blocks that specify the inbound queues associated with the routing profile. If no queue is added, the agent only can make outbound calls. The `queue_configs` block is documented below.
 * @property tags Tags to apply to the Routing Profile. If configured with a provider
 * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class RoutingProfileArgs(
    public val defaultOutboundQueueId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val mediaConcurrencies: Output<List<RoutingProfileMediaConcurrencyArgs>>? = null,
    public val name: Output<String>? = null,
    public val queueConfigs: Output<List<RoutingProfileQueueConfigArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.RoutingProfileArgs> {
    override fun toJava(): com.pulumi.aws.connect.RoutingProfileArgs =
        com.pulumi.aws.connect.RoutingProfileArgs.builder()
            .defaultOutboundQueueId(defaultOutboundQueueId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .mediaConcurrencies(
                mediaConcurrencies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .queueConfigs(
                queueConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RoutingProfileArgs].
 */
@PulumiTagMarker
public class RoutingProfileArgsBuilder internal constructor() {
    private var defaultOutboundQueueId: Output<String>? = null

    private var description: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var mediaConcurrencies: Output<List<RoutingProfileMediaConcurrencyArgs>>? = null

    private var name: Output<String>? = null

    private var queueConfigs: Output<List<RoutingProfileQueueConfigArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies the default outbound queue for the Routing Profile.
     */
    @JvmName("xtkmxqwkniridhkg")
    public suspend fun defaultOutboundQueueId(`value`: Output<String>) {
        this.defaultOutboundQueueId = value
    }

    /**
     * @param value Specifies the description of the Routing Profile.
     */
    @JvmName("tludcyvbjsuqtnsi")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("vgqannaulurikncj")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value One or more `media_concurrencies` blocks that specify the channels that agents can handle in the Contact Control Panel (CCP) for this Routing Profile. The `media_concurrencies` block is documented below.
     */
    @JvmName("bddcsdirtxdsjcig")
    public suspend fun mediaConcurrencies(`value`: Output<List<RoutingProfileMediaConcurrencyArgs>>) {
        this.mediaConcurrencies = value
    }

    @JvmName("ihpmxlkiwkhrrafo")
    public suspend fun mediaConcurrencies(vararg values: Output<RoutingProfileMediaConcurrencyArgs>) {
        this.mediaConcurrencies = Output.all(values.asList())
    }

    /**
     * @param values One or more `media_concurrencies` blocks that specify the channels that agents can handle in the Contact Control Panel (CCP) for this Routing Profile. The `media_concurrencies` block is documented below.
     */
    @JvmName("nluebpxokwgymwck")
    public suspend fun mediaConcurrencies(values: List<Output<RoutingProfileMediaConcurrencyArgs>>) {
        this.mediaConcurrencies = Output.all(values)
    }

    /**
     * @param value Specifies the name of the Routing Profile.
     */
    @JvmName("jbbbhkntvsduqwdk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value One or more `queue_configs` blocks that specify the inbound queues associated with the routing profile. If no queue is added, the agent only can make outbound calls. The `queue_configs` block is documented below.
     */
    @JvmName("vrxpubuaanrnkpvw")
    public suspend fun queueConfigs(`value`: Output<List<RoutingProfileQueueConfigArgs>>) {
        this.queueConfigs = value
    }

    @JvmName("shsmgxrfystigonn")
    public suspend fun queueConfigs(vararg values: Output<RoutingProfileQueueConfigArgs>) {
        this.queueConfigs = Output.all(values.asList())
    }

    /**
     * @param values One or more `queue_configs` blocks that specify the inbound queues associated with the routing profile. If no queue is added, the agent only can make outbound calls. The `queue_configs` block is documented below.
     */
    @JvmName("xrefytegicltecno")
    public suspend fun queueConfigs(values: List<Output<RoutingProfileQueueConfigArgs>>) {
        this.queueConfigs = Output.all(values)
    }

    /**
     * @param value Tags to apply to the Routing Profile. If configured with a provider
     * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dnummspbuhjrdpxh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the default outbound queue for the Routing Profile.
     */
    @JvmName("oubbtamboykwkjdt")
    public suspend fun defaultOutboundQueueId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultOutboundQueueId = mapped
    }

    /**
     * @param value Specifies the description of the Routing Profile.
     */
    @JvmName("wmwwnvlmlflmeaev")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("iqkbtymmrcqrcsxi")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value One or more `media_concurrencies` blocks that specify the channels that agents can handle in the Contact Control Panel (CCP) for this Routing Profile. The `media_concurrencies` block is documented below.
     */
    @JvmName("tsesuontdtkwllok")
    public suspend fun mediaConcurrencies(`value`: List<RoutingProfileMediaConcurrencyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mediaConcurrencies = mapped
    }

    /**
     * @param argument One or more `media_concurrencies` blocks that specify the channels that agents can handle in the Contact Control Panel (CCP) for this Routing Profile. The `media_concurrencies` block is documented below.
     */
    @JvmName("mnptwpivvgpxcivw")
    public suspend fun mediaConcurrencies(argument: List<suspend RoutingProfileMediaConcurrencyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RoutingProfileMediaConcurrencyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.mediaConcurrencies = mapped
    }

    /**
     * @param argument One or more `media_concurrencies` blocks that specify the channels that agents can handle in the Contact Control Panel (CCP) for this Routing Profile. The `media_concurrencies` block is documented below.
     */
    @JvmName("orhisvwsnllyagjn")
    public suspend fun mediaConcurrencies(vararg argument: suspend RoutingProfileMediaConcurrencyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RoutingProfileMediaConcurrencyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.mediaConcurrencies = mapped
    }

    /**
     * @param argument One or more `media_concurrencies` blocks that specify the channels that agents can handle in the Contact Control Panel (CCP) for this Routing Profile. The `media_concurrencies` block is documented below.
     */
    @JvmName("ifdvblsniovmqkik")
    public suspend fun mediaConcurrencies(argument: suspend RoutingProfileMediaConcurrencyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RoutingProfileMediaConcurrencyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.mediaConcurrencies = mapped
    }

    /**
     * @param values One or more `media_concurrencies` blocks that specify the channels that agents can handle in the Contact Control Panel (CCP) for this Routing Profile. The `media_concurrencies` block is documented below.
     */
    @JvmName("rwnjftogdmyrcbnh")
    public suspend fun mediaConcurrencies(vararg values: RoutingProfileMediaConcurrencyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mediaConcurrencies = mapped
    }

    /**
     * @param value Specifies the name of the Routing Profile.
     */
    @JvmName("tnqgolylkislmmwb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value One or more `queue_configs` blocks that specify the inbound queues associated with the routing profile. If no queue is added, the agent only can make outbound calls. The `queue_configs` block is documented below.
     */
    @JvmName("iwwjspicpsatqmgp")
    public suspend fun queueConfigs(`value`: List<RoutingProfileQueueConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queueConfigs = mapped
    }

    /**
     * @param argument One or more `queue_configs` blocks that specify the inbound queues associated with the routing profile. If no queue is added, the agent only can make outbound calls. The `queue_configs` block is documented below.
     */
    @JvmName("aebphkbwiyxmcxav")
    public suspend fun queueConfigs(argument: List<suspend RoutingProfileQueueConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RoutingProfileQueueConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.queueConfigs = mapped
    }

    /**
     * @param argument One or more `queue_configs` blocks that specify the inbound queues associated with the routing profile. If no queue is added, the agent only can make outbound calls. The `queue_configs` block is documented below.
     */
    @JvmName("lgqxsrlhpfxlxfei")
    public suspend fun queueConfigs(vararg argument: suspend RoutingProfileQueueConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RoutingProfileQueueConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.queueConfigs = mapped
    }

    /**
     * @param argument One or more `queue_configs` blocks that specify the inbound queues associated with the routing profile. If no queue is added, the agent only can make outbound calls. The `queue_configs` block is documented below.
     */
    @JvmName("hlbxdtxkohgvfssb")
    public suspend fun queueConfigs(argument: suspend RoutingProfileQueueConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RoutingProfileQueueConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.queueConfigs = mapped
    }

    /**
     * @param values One or more `queue_configs` blocks that specify the inbound queues associated with the routing profile. If no queue is added, the agent only can make outbound calls. The `queue_configs` block is documented below.
     */
    @JvmName("bpbmuafyjshcmogr")
    public suspend fun queueConfigs(vararg values: RoutingProfileQueueConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queueConfigs = mapped
    }

    /**
     * @param value Tags to apply to the Routing Profile. If configured with a provider
     * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fydikeqequsditsw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to apply to the Routing Profile. If configured with a provider
     * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ykpuxlfqwhaiminw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RoutingProfileArgs = RoutingProfileArgs(
        defaultOutboundQueueId = defaultOutboundQueueId,
        description = description,
        instanceId = instanceId,
        mediaConcurrencies = mediaConcurrencies,
        name = name,
        queueConfigs = queueConfigs,
        tags = tags,
    )
}
