@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.kotlin.outputs.UserIdentityInfo
import com.pulumi.aws.connect.kotlin.outputs.UserPhoneConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.connect.kotlin.outputs.UserIdentityInfo.Companion.toKotlin as userIdentityInfoToKotlin
import com.pulumi.aws.connect.kotlin.outputs.UserPhoneConfig.Companion.toKotlin as userPhoneConfigToKotlin

/**
 * Builder for [User].
 */
@PulumiTagMarker
public class UserResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserArgs = UserArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserArgsBuilder.() -> Unit) {
        val builder = UserArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): User {
        val builtJavaResource = com.pulumi.aws.connect.User(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return User(builtJavaResource)
    }
}

/**
 * Provides an Amazon Connect User resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.User("example", {
 *     instanceId: exampleAwsConnectInstance.id,
 *     name: "example",
 *     password: "Password123",
 *     routingProfileId: exampleAwsConnectRoutingProfile.routingProfileId,
 *     securityProfileIds: [exampleAwsConnectSecurityProfile&#46;securityProfileId],
 *     identityInfo: {
 *         firstName: "example",
 *         lastName: "example2",
 *     },
 *     phoneConfig: {
 *         afterContactWorkTimeLimit: 0,
 *         phoneType: "SOFT_PHONE",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.User("example",
 *     instance_id=example_aws_connect_instance["id"],
 *     name="example",
 *     password="Password123",
 *     routing_profile_id=example_aws_connect_routing_profile["routingProfileId"],
 *     security_profile_ids=[example_aws_connect_security_profile["securityProfileId"]],
 *     identity_info={
 *         "first_name": "example",
 *         "last_name": "example2",
 *     },
 *     phone_config={
 *         "after_contact_work_time_limit": 0,
 *         "phone_type": "SOFT_PHONE",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.User("example", new()
 *     {
 *         InstanceId = exampleAwsConnectInstance.Id,
 *         Name = "example",
 *         Password = "Password123",
 *         RoutingProfileId = exampleAwsConnectRoutingProfile.RoutingProfileId,
 *         SecurityProfileIds = new[]
 *         {
 *             exampleAwsConnectSecurityProfile.SecurityProfileId,
 *         },
 *         IdentityInfo = new Aws.Connect.Inputs.UserIdentityInfoArgs
 *         {
 *             FirstName = "example",
 *             LastName = "example2",
 *         },
 *         PhoneConfig = new Aws.Connect.Inputs.UserPhoneConfigArgs
 *         {
 *             AfterContactWorkTimeLimit = 0,
 *             PhoneType = "SOFT_PHONE",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewUser(ctx, "example", &connect.UserArgs{
 * 			InstanceId:       pulumi.Any(exampleAwsConnectInstance.Id),
 * 			Name:             pulumi.String("example"),
 * 			Password:         pulumi.String("Password123"),
 * 			RoutingProfileId: pulumi.Any(exampleAwsConnectRoutingProfile.RoutingProfileId),
 * 			SecurityProfileIds: pulumi.StringArray{
 * 				exampleAwsConnectSecurityProfile.SecurityProfileId,
 * 			},
 * 			IdentityInfo: &connect.UserIdentityInfoArgs{
 * 				FirstName: pulumi.String("example"),
 * 				LastName:  pulumi.String("example2"),
 * 			},
 * 			PhoneConfig: &connect.UserPhoneConfigArgs{
 * 				AfterContactWorkTimeLimit: pulumi.Int(0),
 * 				PhoneType:                 pulumi.String("SOFT_PHONE"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.User;
 * import com.pulumi.aws.connect.UserArgs;
 * import com.pulumi.aws.connect.inputs.UserIdentityInfoArgs;
 * import com.pulumi.aws.connect.inputs.UserPhoneConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new User("example", UserArgs.builder()
 *             .instanceId(exampleAwsConnectInstance.id())
 *             .name("example")
 *             .password("Password123")
 *             .routingProfileId(exampleAwsConnectRoutingProfile.routingProfileId())
 *             .securityProfileIds(exampleAwsConnectSecurityProfile.securityProfileId())
 *             .identityInfo(UserIdentityInfoArgs.builder()
 *                 .firstName("example")
 *                 .lastName("example2")
 *                 .build())
 *             .phoneConfig(UserPhoneConfigArgs.builder()
 *                 .afterContactWorkTimeLimit(0)
 *                 .phoneType("SOFT_PHONE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:User
 *     properties:
 *       instanceId: ${exampleAwsConnectInstance.id}
 *       name: example
 *       password: Password123
 *       routingProfileId: ${exampleAwsConnectRoutingProfile.routingProfileId}
 *       securityProfileIds:
 *         - ${exampleAwsConnectSecurityProfile.securityProfileId}
 *       identityInfo:
 *         firstName: example
 *         lastName: example2
 *       phoneConfig:
 *         afterContactWorkTimeLimit: 0
 *         phoneType: SOFT_PHONE
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With hierarchy_group_id
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.User("example", {
 *     instanceId: exampleAwsConnectInstance.id,
 *     name: "example",
 *     password: "Password123",
 *     routingProfileId: exampleAwsConnectRoutingProfile.routingProfileId,
 *     hierarchyGroupId: exampleAwsConnectUserHierarchyGroup.hierarchyGroupId,
 *     securityProfileIds: [exampleAwsConnectSecurityProfile&#46;securityProfileId],
 *     identityInfo: {
 *         firstName: "example",
 *         lastName: "example2",
 *     },
 *     phoneConfig: {
 *         afterContactWorkTimeLimit: 0,
 *         phoneType: "SOFT_PHONE",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.User("example",
 *     instance_id=example_aws_connect_instance["id"],
 *     name="example",
 *     password="Password123",
 *     routing_profile_id=example_aws_connect_routing_profile["routingProfileId"],
 *     hierarchy_group_id=example_aws_connect_user_hierarchy_group["hierarchyGroupId"],
 *     security_profile_ids=[example_aws_connect_security_profile["securityProfileId"]],
 *     identity_info={
 *         "first_name": "example",
 *         "last_name": "example2",
 *     },
 *     phone_config={
 *         "after_contact_work_time_limit": 0,
 *         "phone_type": "SOFT_PHONE",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.User("example", new()
 *     {
 *         InstanceId = exampleAwsConnectInstance.Id,
 *         Name = "example",
 *         Password = "Password123",
 *         RoutingProfileId = exampleAwsConnectRoutingProfile.RoutingProfileId,
 *         HierarchyGroupId = exampleAwsConnectUserHierarchyGroup.HierarchyGroupId,
 *         SecurityProfileIds = new[]
 *         {
 *             exampleAwsConnectSecurityProfile.SecurityProfileId,
 *         },
 *         IdentityInfo = new Aws.Connect.Inputs.UserIdentityInfoArgs
 *         {
 *             FirstName = "example",
 *             LastName = "example2",
 *         },
 *         PhoneConfig = new Aws.Connect.Inputs.UserPhoneConfigArgs
 *         {
 *             AfterContactWorkTimeLimit = 0,
 *             PhoneType = "SOFT_PHONE",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewUser(ctx, "example", &connect.UserArgs{
 * 			InstanceId:       pulumi.Any(exampleAwsConnectInstance.Id),
 * 			Name:             pulumi.String("example"),
 * 			Password:         pulumi.String("Password123"),
 * 			RoutingProfileId: pulumi.Any(exampleAwsConnectRoutingProfile.RoutingProfileId),
 * 			HierarchyGroupId: pulumi.Any(exampleAwsConnectUserHierarchyGroup.HierarchyGroupId),
 * 			SecurityProfileIds: pulumi.StringArray{
 * 				exampleAwsConnectSecurityProfile.SecurityProfileId,
 * 			},
 * 			IdentityInfo: &connect.UserIdentityInfoArgs{
 * 				FirstName: pulumi.String("example"),
 * 				LastName:  pulumi.String("example2"),
 * 			},
 * 			PhoneConfig: &connect.UserPhoneConfigArgs{
 * 				AfterContactWorkTimeLimit: pulumi.Int(0),
 * 				PhoneType:                 pulumi.String("SOFT_PHONE"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.User;
 * import com.pulumi.aws.connect.UserArgs;
 * import com.pulumi.aws.connect.inputs.UserIdentityInfoArgs;
 * import com.pulumi.aws.connect.inputs.UserPhoneConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new User("example", UserArgs.builder()
 *             .instanceId(exampleAwsConnectInstance.id())
 *             .name("example")
 *             .password("Password123")
 *             .routingProfileId(exampleAwsConnectRoutingProfile.routingProfileId())
 *             .hierarchyGroupId(exampleAwsConnectUserHierarchyGroup.hierarchyGroupId())
 *             .securityProfileIds(exampleAwsConnectSecurityProfile.securityProfileId())
 *             .identityInfo(UserIdentityInfoArgs.builder()
 *                 .firstName("example")
 *                 .lastName("example2")
 *                 .build())
 *             .phoneConfig(UserPhoneConfigArgs.builder()
 *                 .afterContactWorkTimeLimit(0)
 *                 .phoneType("SOFT_PHONE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:User
 *     properties:
 *       instanceId: ${exampleAwsConnectInstance.id}
 *       name: example
 *       password: Password123
 *       routingProfileId: ${exampleAwsConnectRoutingProfile.routingProfileId}
 *       hierarchyGroupId: ${exampleAwsConnectUserHierarchyGroup.hierarchyGroupId}
 *       securityProfileIds:
 *         - ${exampleAwsConnectSecurityProfile.securityProfileId}
 *       identityInfo:
 *         firstName: example
 *         lastName: example2
 *       phoneConfig:
 *         afterContactWorkTimeLimit: 0
 *         phoneType: SOFT_PHONE
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With identity_info filled
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.User("example", {
 *     instanceId: exampleAwsConnectInstance.id,
 *     name: "example",
 *     password: "Password123",
 *     routingProfileId: exampleAwsConnectRoutingProfile.routingProfileId,
 *     securityProfileIds: [exampleAwsConnectSecurityProfile&#46;securityProfileId],
 *     identityInfo: {
 *         email: "example@example.com",
 *         firstName: "example",
 *         lastName: "example2",
 *     },
 *     phoneConfig: {
 *         afterContactWorkTimeLimit: 0,
 *         phoneType: "SOFT_PHONE",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.User("example",
 *     instance_id=example_aws_connect_instance["id"],
 *     name="example",
 *     password="Password123",
 *     routing_profile_id=example_aws_connect_routing_profile["routingProfileId"],
 *     security_profile_ids=[example_aws_connect_security_profile["securityProfileId"]],
 *     identity_info={
 *         "email": "example@example.com",
 *         "first_name": "example",
 *         "last_name": "example2",
 *     },
 *     phone_config={
 *         "after_contact_work_time_limit": 0,
 *         "phone_type": "SOFT_PHONE",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.User("example", new()
 *     {
 *         InstanceId = exampleAwsConnectInstance.Id,
 *         Name = "example",
 *         Password = "Password123",
 *         RoutingProfileId = exampleAwsConnectRoutingProfile.RoutingProfileId,
 *         SecurityProfileIds = new[]
 *         {
 *             exampleAwsConnectSecurityProfile.SecurityProfileId,
 *         },
 *         IdentityInfo = new Aws.Connect.Inputs.UserIdentityInfoArgs
 *         {
 *             Email = "example@example.com",
 *             FirstName = "example",
 *             LastName = "example2",
 *         },
 *         PhoneConfig = new Aws.Connect.Inputs.UserPhoneConfigArgs
 *         {
 *             AfterContactWorkTimeLimit = 0,
 *             PhoneType = "SOFT_PHONE",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewUser(ctx, "example", &connect.UserArgs{
 * 			InstanceId:       pulumi.Any(exampleAwsConnectInstance.Id),
 * 			Name:             pulumi.String("example"),
 * 			Password:         pulumi.String("Password123"),
 * 			RoutingProfileId: pulumi.Any(exampleAwsConnectRoutingProfile.RoutingProfileId),
 * 			SecurityProfileIds: pulumi.StringArray{
 * 				exampleAwsConnectSecurityProfile.SecurityProfileId,
 * 			},
 * 			IdentityInfo: &connect.UserIdentityInfoArgs{
 * 				Email:     pulumi.String("example@example.com"),
 * 				FirstName: pulumi.String("example"),
 * 				LastName:  pulumi.String("example2"),
 * 			},
 * 			PhoneConfig: &connect.UserPhoneConfigArgs{
 * 				AfterContactWorkTimeLimit: pulumi.Int(0),
 * 				PhoneType:                 pulumi.String("SOFT_PHONE"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.User;
 * import com.pulumi.aws.connect.UserArgs;
 * import com.pulumi.aws.connect.inputs.UserIdentityInfoArgs;
 * import com.pulumi.aws.connect.inputs.UserPhoneConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new User("example", UserArgs.builder()
 *             .instanceId(exampleAwsConnectInstance.id())
 *             .name("example")
 *             .password("Password123")
 *             .routingProfileId(exampleAwsConnectRoutingProfile.routingProfileId())
 *             .securityProfileIds(exampleAwsConnectSecurityProfile.securityProfileId())
 *             .identityInfo(UserIdentityInfoArgs.builder()
 *                 .email("example@example.com")
 *                 .firstName("example")
 *                 .lastName("example2")
 *                 .build())
 *             .phoneConfig(UserPhoneConfigArgs.builder()
 *                 .afterContactWorkTimeLimit(0)
 *                 .phoneType("SOFT_PHONE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:User
 *     properties:
 *       instanceId: ${exampleAwsConnectInstance.id}
 *       name: example
 *       password: Password123
 *       routingProfileId: ${exampleAwsConnectRoutingProfile.routingProfileId}
 *       securityProfileIds:
 *         - ${exampleAwsConnectSecurityProfile.securityProfileId}
 *       identityInfo:
 *         email: example@example.com
 *         firstName: example
 *         lastName: example2
 *       phoneConfig:
 *         afterContactWorkTimeLimit: 0
 *         phoneType: SOFT_PHONE
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With phone_config phone type as desk phone
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.User("example", {
 *     instanceId: exampleAwsConnectInstance.id,
 *     name: "example",
 *     password: "Password123",
 *     routingProfileId: exampleAwsConnectRoutingProfile.routingProfileId,
 *     securityProfileIds: [exampleAwsConnectSecurityProfile&#46;securityProfileId],
 *     phoneConfig: {
 *         afterContactWorkTimeLimit: 0,
 *         phoneType: "SOFT_PHONE",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.User("example",
 *     instance_id=example_aws_connect_instance["id"],
 *     name="example",
 *     password="Password123",
 *     routing_profile_id=example_aws_connect_routing_profile["routingProfileId"],
 *     security_profile_ids=[example_aws_connect_security_profile["securityProfileId"]],
 *     phone_config={
 *         "after_contact_work_time_limit": 0,
 *         "phone_type": "SOFT_PHONE",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.User("example", new()
 *     {
 *         InstanceId = exampleAwsConnectInstance.Id,
 *         Name = "example",
 *         Password = "Password123",
 *         RoutingProfileId = exampleAwsConnectRoutingProfile.RoutingProfileId,
 *         SecurityProfileIds = new[]
 *         {
 *             exampleAwsConnectSecurityProfile.SecurityProfileId,
 *         },
 *         PhoneConfig = new Aws.Connect.Inputs.UserPhoneConfigArgs
 *         {
 *             AfterContactWorkTimeLimit = 0,
 *             PhoneType = "SOFT_PHONE",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewUser(ctx, "example", &connect.UserArgs{
 * 			InstanceId:       pulumi.Any(exampleAwsConnectInstance.Id),
 * 			Name:             pulumi.String("example"),
 * 			Password:         pulumi.String("Password123"),
 * 			RoutingProfileId: pulumi.Any(exampleAwsConnectRoutingProfile.RoutingProfileId),
 * 			SecurityProfileIds: pulumi.StringArray{
 * 				exampleAwsConnectSecurityProfile.SecurityProfileId,
 * 			},
 * 			PhoneConfig: &connect.UserPhoneConfigArgs{
 * 				AfterContactWorkTimeLimit: pulumi.Int(0),
 * 				PhoneType:                 pulumi.String("SOFT_PHONE"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.User;
 * import com.pulumi.aws.connect.UserArgs;
 * import com.pulumi.aws.connect.inputs.UserPhoneConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new User("example", UserArgs.builder()
 *             .instanceId(exampleAwsConnectInstance.id())
 *             .name("example")
 *             .password("Password123")
 *             .routingProfileId(exampleAwsConnectRoutingProfile.routingProfileId())
 *             .securityProfileIds(exampleAwsConnectSecurityProfile.securityProfileId())
 *             .phoneConfig(UserPhoneConfigArgs.builder()
 *                 .afterContactWorkTimeLimit(0)
 *                 .phoneType("SOFT_PHONE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:User
 *     properties:
 *       instanceId: ${exampleAwsConnectInstance.id}
 *       name: example
 *       password: Password123
 *       routingProfileId: ${exampleAwsConnectRoutingProfile.routingProfileId}
 *       securityProfileIds:
 *         - ${exampleAwsConnectSecurityProfile.securityProfileId}
 *       phoneConfig:
 *         afterContactWorkTimeLimit: 0
 *         phoneType: SOFT_PHONE
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With multiple Security profile ids specified in security_profile_ids
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.User("example", {
 *     instanceId: exampleAwsConnectInstance.id,
 *     name: "example",
 *     password: "Password123",
 *     routingProfileId: exampleAwsConnectRoutingProfile.routingProfileId,
 *     securityProfileIds: [
 *         exampleAwsConnectSecurityProfile.securityProfileId,
 *         example2.securityProfileId,
 *     ],
 *     phoneConfig: {
 *         afterContactWorkTimeLimit: 0,
 *         autoAccept: false,
 *         deskPhoneNumber: "+112345678912",
 *         phoneType: "DESK_PHONE",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.User("example",
 *     instance_id=example_aws_connect_instance["id"],
 *     name="example",
 *     password="Password123",
 *     routing_profile_id=example_aws_connect_routing_profile["routingProfileId"],
 *     security_profile_ids=[
 *         example_aws_connect_security_profile["securityProfileId"],
 *         example2["securityProfileId"],
 *     ],
 *     phone_config={
 *         "after_contact_work_time_limit": 0,
 *         "auto_accept": False,
 *         "desk_phone_number": "+112345678912",
 *         "phone_type": "DESK_PHONE",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.User("example", new()
 *     {
 *         InstanceId = exampleAwsConnectInstance.Id,
 *         Name = "example",
 *         Password = "Password123",
 *         RoutingProfileId = exampleAwsConnectRoutingProfile.RoutingProfileId,
 *         SecurityProfileIds = new[]
 *         {
 *             exampleAwsConnectSecurityProfile.SecurityProfileId,
 *             example2.SecurityProfileId,
 *         },
 *         PhoneConfig = new Aws.Connect.Inputs.UserPhoneConfigArgs
 *         {
 *             AfterContactWorkTimeLimit = 0,
 *             AutoAccept = false,
 *             DeskPhoneNumber = "+112345678912",
 *             PhoneType = "DESK_PHONE",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewUser(ctx, "example", &connect.UserArgs{
 * 			InstanceId:       pulumi.Any(exampleAwsConnectInstance.Id),
 * 			Name:             pulumi.String("example"),
 * 			Password:         pulumi.String("Password123"),
 * 			RoutingProfileId: pulumi.Any(exampleAwsConnectRoutingProfile.RoutingProfileId),
 * 			SecurityProfileIds: pulumi.StringArray{
 * 				exampleAwsConnectSecurityProfile.SecurityProfileId,
 * 				example2.SecurityProfileId,
 * 			},
 * 			PhoneConfig: &connect.UserPhoneConfigArgs{
 * 				AfterContactWorkTimeLimit: pulumi.Int(0),
 * 				AutoAccept:                pulumi.Bool(false),
 * 				DeskPhoneNumber:           pulumi.String("+112345678912"),
 * 				PhoneType:                 pulumi.String("DESK_PHONE"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.User;
 * import com.pulumi.aws.connect.UserArgs;
 * import com.pulumi.aws.connect.inputs.UserPhoneConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new User("example", UserArgs.builder()
 *             .instanceId(exampleAwsConnectInstance.id())
 *             .name("example")
 *             .password("Password123")
 *             .routingProfileId(exampleAwsConnectRoutingProfile.routingProfileId())
 *             .securityProfileIds(
 *                 exampleAwsConnectSecurityProfile.securityProfileId(),
 *                 example2.securityProfileId())
 *             .phoneConfig(UserPhoneConfigArgs.builder()
 *                 .afterContactWorkTimeLimit(0)
 *                 .autoAccept(false)
 *                 .deskPhoneNumber("+112345678912")
 *                 .phoneType("DESK_PHONE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:User
 *     properties:
 *       instanceId: ${exampleAwsConnectInstance.id}
 *       name: example
 *       password: Password123
 *       routingProfileId: ${exampleAwsConnectRoutingProfile.routingProfileId}
 *       securityProfileIds:
 *         - ${exampleAwsConnectSecurityProfile.securityProfileId}
 *         - ${example2.securityProfileId}
 *       phoneConfig:
 *         afterContactWorkTimeLimit: 0
 *         autoAccept: false
 *         deskPhoneNumber: '+112345678912'
 *         phoneType: DESK_PHONE
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amazon Connect Users using the `instance_id` and `user_id` separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:connect/user:User example f1288a1f-6193-445a-b47e-af739b2:c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5
 * ```
 */
public class User internal constructor(
    override val javaResource: com.pulumi.aws.connect.User,
) : KotlinCustomResource(javaResource, UserMapper) {
    /**
     * The Amazon Resource Name (ARN) of the user.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The identifier of the user account in the directory used for identity management. If Amazon Connect cannot access the directory, you can specify this identifier to authenticate users. If you include the identifier, we assume that Amazon Connect cannot access the directory. Otherwise, the identity information is used to authenticate users from your directory. This parameter is required if you are using an existing directory for identity management in Amazon Connect when Amazon Connect cannot access your directory to authenticate users. If you are using SAML for identity management and include this parameter, an error is returned.
     */
    public val directoryUserId: Output<String>
        get() = javaResource.directoryUserId().applyValue({ args0 -> args0 })

    /**
     * The identifier of the hierarchy group for the user.
     */
    public val hierarchyGroupId: Output<String>?
        get() = javaResource.hierarchyGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A block that contains information about the identity of the user. Documented below.
     */
    public val identityInfo: Output<UserIdentityInfo>?
        get() = javaResource.identityInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    userIdentityInfoToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Specifies the identifier of the hosting Amazon Connect Instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The user name for the account. For instances not using SAML for identity management, the user name can include up to 20 characters. If you are using SAML for identity management, the user name can include up to 64 characters from `[a-zA-Z0-9_-&#46;\@]+`.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The password for the user account. A password is required if you are using Amazon Connect for identity management. Otherwise, it is an error to include a password.
     */
    public val password: Output<String>?
        get() = javaResource.password().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A block that contains information about the phone settings for the user. Documented below.
     */
    public val phoneConfig: Output<UserPhoneConfig>
        get() = javaResource.phoneConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                userPhoneConfigToKotlin(args0)
            })
        })

    /**
     * The identifier of the routing profile for the user.
     */
    public val routingProfileId: Output<String>
        get() = javaResource.routingProfileId().applyValue({ args0 -> args0 })

    /**
     * A list of identifiers for the security profiles for the user. Specify a minimum of 1 and maximum of 10 security profile ids. For more information, see [Best Practices for Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html) in the Amazon Connect Administrator Guide.
     */
    public val securityProfileIds: Output<List<String>>
        get() = javaResource.securityProfileIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Tags to apply to the user. If configured with a provider
     * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The identifier for the user.
     */
    public val userId: Output<String>
        get() = javaResource.userId().applyValue({ args0 -> args0 })
}

public object UserMapper : ResourceMapper<User> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.connect.User::class == javaResource::class

    override fun map(javaResource: Resource): User = User(javaResource as com.pulumi.aws.connect.User)
}

/**
 * @see [User].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [User].
 */
public suspend fun user(name: String, block: suspend UserResourceBuilder.() -> Unit): User {
    val builder = UserResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [User].
 * @param name The _unique_ name of the resulting resource.
 */
public fun user(name: String): User {
    val builder = UserResourceBuilder()
    builder.name(name)
    return builder.build()
}
