@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.UserArgs.builder
import com.pulumi.aws.connect.kotlin.inputs.UserIdentityInfoArgs
import com.pulumi.aws.connect.kotlin.inputs.UserIdentityInfoArgsBuilder
import com.pulumi.aws.connect.kotlin.inputs.UserPhoneConfigArgs
import com.pulumi.aws.connect.kotlin.inputs.UserPhoneConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Connect User resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.User("example", {
 *     instanceId: exampleAwsConnectInstance.id,
 *     name: "example",
 *     password: "Password123",
 *     routingProfileId: exampleAwsConnectRoutingProfile.routingProfileId,
 *     securityProfileIds: [exampleAwsConnectSecurityProfile&#46;securityProfileId],
 *     identityInfo: {
 *         firstName: "example",
 *         lastName: "example2",
 *     },
 *     phoneConfig: {
 *         afterContactWorkTimeLimit: 0,
 *         phoneType: "SOFT_PHONE",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.User("example",
 *     instance_id=example_aws_connect_instance["id"],
 *     name="example",
 *     password="Password123",
 *     routing_profile_id=example_aws_connect_routing_profile["routingProfileId"],
 *     security_profile_ids=[example_aws_connect_security_profile["securityProfileId"]],
 *     identity_info={
 *         "first_name": "example",
 *         "last_name": "example2",
 *     },
 *     phone_config={
 *         "after_contact_work_time_limit": 0,
 *         "phone_type": "SOFT_PHONE",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.User("example", new()
 *     {
 *         InstanceId = exampleAwsConnectInstance.Id,
 *         Name = "example",
 *         Password = "Password123",
 *         RoutingProfileId = exampleAwsConnectRoutingProfile.RoutingProfileId,
 *         SecurityProfileIds = new[]
 *         {
 *             exampleAwsConnectSecurityProfile.SecurityProfileId,
 *         },
 *         IdentityInfo = new Aws.Connect.Inputs.UserIdentityInfoArgs
 *         {
 *             FirstName = "example",
 *             LastName = "example2",
 *         },
 *         PhoneConfig = new Aws.Connect.Inputs.UserPhoneConfigArgs
 *         {
 *             AfterContactWorkTimeLimit = 0,
 *             PhoneType = "SOFT_PHONE",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewUser(ctx, "example", &connect.UserArgs{
 * 			InstanceId:       pulumi.Any(exampleAwsConnectInstance.Id),
 * 			Name:             pulumi.String("example"),
 * 			Password:         pulumi.String("Password123"),
 * 			RoutingProfileId: pulumi.Any(exampleAwsConnectRoutingProfile.RoutingProfileId),
 * 			SecurityProfileIds: pulumi.StringArray{
 * 				exampleAwsConnectSecurityProfile.SecurityProfileId,
 * 			},
 * 			IdentityInfo: &connect.UserIdentityInfoArgs{
 * 				FirstName: pulumi.String("example"),
 * 				LastName:  pulumi.String("example2"),
 * 			},
 * 			PhoneConfig: &connect.UserPhoneConfigArgs{
 * 				AfterContactWorkTimeLimit: pulumi.Int(0),
 * 				PhoneType:                 pulumi.String("SOFT_PHONE"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.User;
 * import com.pulumi.aws.connect.UserArgs;
 * import com.pulumi.aws.connect.inputs.UserIdentityInfoArgs;
 * import com.pulumi.aws.connect.inputs.UserPhoneConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new User("example", UserArgs.builder()
 *             .instanceId(exampleAwsConnectInstance.id())
 *             .name("example")
 *             .password("Password123")
 *             .routingProfileId(exampleAwsConnectRoutingProfile.routingProfileId())
 *             .securityProfileIds(exampleAwsConnectSecurityProfile.securityProfileId())
 *             .identityInfo(UserIdentityInfoArgs.builder()
 *                 .firstName("example")
 *                 .lastName("example2")
 *                 .build())
 *             .phoneConfig(UserPhoneConfigArgs.builder()
 *                 .afterContactWorkTimeLimit(0)
 *                 .phoneType("SOFT_PHONE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:User
 *     properties:
 *       instanceId: ${exampleAwsConnectInstance.id}
 *       name: example
 *       password: Password123
 *       routingProfileId: ${exampleAwsConnectRoutingProfile.routingProfileId}
 *       securityProfileIds:
 *         - ${exampleAwsConnectSecurityProfile.securityProfileId}
 *       identityInfo:
 *         firstName: example
 *         lastName: example2
 *       phoneConfig:
 *         afterContactWorkTimeLimit: 0
 *         phoneType: SOFT_PHONE
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With hierarchy_group_id
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.User("example", {
 *     instanceId: exampleAwsConnectInstance.id,
 *     name: "example",
 *     password: "Password123",
 *     routingProfileId: exampleAwsConnectRoutingProfile.routingProfileId,
 *     hierarchyGroupId: exampleAwsConnectUserHierarchyGroup.hierarchyGroupId,
 *     securityProfileIds: [exampleAwsConnectSecurityProfile&#46;securityProfileId],
 *     identityInfo: {
 *         firstName: "example",
 *         lastName: "example2",
 *     },
 *     phoneConfig: {
 *         afterContactWorkTimeLimit: 0,
 *         phoneType: "SOFT_PHONE",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.User("example",
 *     instance_id=example_aws_connect_instance["id"],
 *     name="example",
 *     password="Password123",
 *     routing_profile_id=example_aws_connect_routing_profile["routingProfileId"],
 *     hierarchy_group_id=example_aws_connect_user_hierarchy_group["hierarchyGroupId"],
 *     security_profile_ids=[example_aws_connect_security_profile["securityProfileId"]],
 *     identity_info={
 *         "first_name": "example",
 *         "last_name": "example2",
 *     },
 *     phone_config={
 *         "after_contact_work_time_limit": 0,
 *         "phone_type": "SOFT_PHONE",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.User("example", new()
 *     {
 *         InstanceId = exampleAwsConnectInstance.Id,
 *         Name = "example",
 *         Password = "Password123",
 *         RoutingProfileId = exampleAwsConnectRoutingProfile.RoutingProfileId,
 *         HierarchyGroupId = exampleAwsConnectUserHierarchyGroup.HierarchyGroupId,
 *         SecurityProfileIds = new[]
 *         {
 *             exampleAwsConnectSecurityProfile.SecurityProfileId,
 *         },
 *         IdentityInfo = new Aws.Connect.Inputs.UserIdentityInfoArgs
 *         {
 *             FirstName = "example",
 *             LastName = "example2",
 *         },
 *         PhoneConfig = new Aws.Connect.Inputs.UserPhoneConfigArgs
 *         {
 *             AfterContactWorkTimeLimit = 0,
 *             PhoneType = "SOFT_PHONE",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewUser(ctx, "example", &connect.UserArgs{
 * 			InstanceId:       pulumi.Any(exampleAwsConnectInstance.Id),
 * 			Name:             pulumi.String("example"),
 * 			Password:         pulumi.String("Password123"),
 * 			RoutingProfileId: pulumi.Any(exampleAwsConnectRoutingProfile.RoutingProfileId),
 * 			HierarchyGroupId: pulumi.Any(exampleAwsConnectUserHierarchyGroup.HierarchyGroupId),
 * 			SecurityProfileIds: pulumi.StringArray{
 * 				exampleAwsConnectSecurityProfile.SecurityProfileId,
 * 			},
 * 			IdentityInfo: &connect.UserIdentityInfoArgs{
 * 				FirstName: pulumi.String("example"),
 * 				LastName:  pulumi.String("example2"),
 * 			},
 * 			PhoneConfig: &connect.UserPhoneConfigArgs{
 * 				AfterContactWorkTimeLimit: pulumi.Int(0),
 * 				PhoneType:                 pulumi.String("SOFT_PHONE"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.User;
 * import com.pulumi.aws.connect.UserArgs;
 * import com.pulumi.aws.connect.inputs.UserIdentityInfoArgs;
 * import com.pulumi.aws.connect.inputs.UserPhoneConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new User("example", UserArgs.builder()
 *             .instanceId(exampleAwsConnectInstance.id())
 *             .name("example")
 *             .password("Password123")
 *             .routingProfileId(exampleAwsConnectRoutingProfile.routingProfileId())
 *             .hierarchyGroupId(exampleAwsConnectUserHierarchyGroup.hierarchyGroupId())
 *             .securityProfileIds(exampleAwsConnectSecurityProfile.securityProfileId())
 *             .identityInfo(UserIdentityInfoArgs.builder()
 *                 .firstName("example")
 *                 .lastName("example2")
 *                 .build())
 *             .phoneConfig(UserPhoneConfigArgs.builder()
 *                 .afterContactWorkTimeLimit(0)
 *                 .phoneType("SOFT_PHONE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:User
 *     properties:
 *       instanceId: ${exampleAwsConnectInstance.id}
 *       name: example
 *       password: Password123
 *       routingProfileId: ${exampleAwsConnectRoutingProfile.routingProfileId}
 *       hierarchyGroupId: ${exampleAwsConnectUserHierarchyGroup.hierarchyGroupId}
 *       securityProfileIds:
 *         - ${exampleAwsConnectSecurityProfile.securityProfileId}
 *       identityInfo:
 *         firstName: example
 *         lastName: example2
 *       phoneConfig:
 *         afterContactWorkTimeLimit: 0
 *         phoneType: SOFT_PHONE
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With identity_info filled
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.User("example", {
 *     instanceId: exampleAwsConnectInstance.id,
 *     name: "example",
 *     password: "Password123",
 *     routingProfileId: exampleAwsConnectRoutingProfile.routingProfileId,
 *     securityProfileIds: [exampleAwsConnectSecurityProfile&#46;securityProfileId],
 *     identityInfo: {
 *         email: "example@example.com",
 *         firstName: "example",
 *         lastName: "example2",
 *     },
 *     phoneConfig: {
 *         afterContactWorkTimeLimit: 0,
 *         phoneType: "SOFT_PHONE",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.User("example",
 *     instance_id=example_aws_connect_instance["id"],
 *     name="example",
 *     password="Password123",
 *     routing_profile_id=example_aws_connect_routing_profile["routingProfileId"],
 *     security_profile_ids=[example_aws_connect_security_profile["securityProfileId"]],
 *     identity_info={
 *         "email": "example@example.com",
 *         "first_name": "example",
 *         "last_name": "example2",
 *     },
 *     phone_config={
 *         "after_contact_work_time_limit": 0,
 *         "phone_type": "SOFT_PHONE",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.User("example", new()
 *     {
 *         InstanceId = exampleAwsConnectInstance.Id,
 *         Name = "example",
 *         Password = "Password123",
 *         RoutingProfileId = exampleAwsConnectRoutingProfile.RoutingProfileId,
 *         SecurityProfileIds = new[]
 *         {
 *             exampleAwsConnectSecurityProfile.SecurityProfileId,
 *         },
 *         IdentityInfo = new Aws.Connect.Inputs.UserIdentityInfoArgs
 *         {
 *             Email = "example@example.com",
 *             FirstName = "example",
 *             LastName = "example2",
 *         },
 *         PhoneConfig = new Aws.Connect.Inputs.UserPhoneConfigArgs
 *         {
 *             AfterContactWorkTimeLimit = 0,
 *             PhoneType = "SOFT_PHONE",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewUser(ctx, "example", &connect.UserArgs{
 * 			InstanceId:       pulumi.Any(exampleAwsConnectInstance.Id),
 * 			Name:             pulumi.String("example"),
 * 			Password:         pulumi.String("Password123"),
 * 			RoutingProfileId: pulumi.Any(exampleAwsConnectRoutingProfile.RoutingProfileId),
 * 			SecurityProfileIds: pulumi.StringArray{
 * 				exampleAwsConnectSecurityProfile.SecurityProfileId,
 * 			},
 * 			IdentityInfo: &connect.UserIdentityInfoArgs{
 * 				Email:     pulumi.String("example@example.com"),
 * 				FirstName: pulumi.String("example"),
 * 				LastName:  pulumi.String("example2"),
 * 			},
 * 			PhoneConfig: &connect.UserPhoneConfigArgs{
 * 				AfterContactWorkTimeLimit: pulumi.Int(0),
 * 				PhoneType:                 pulumi.String("SOFT_PHONE"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.User;
 * import com.pulumi.aws.connect.UserArgs;
 * import com.pulumi.aws.connect.inputs.UserIdentityInfoArgs;
 * import com.pulumi.aws.connect.inputs.UserPhoneConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new User("example", UserArgs.builder()
 *             .instanceId(exampleAwsConnectInstance.id())
 *             .name("example")
 *             .password("Password123")
 *             .routingProfileId(exampleAwsConnectRoutingProfile.routingProfileId())
 *             .securityProfileIds(exampleAwsConnectSecurityProfile.securityProfileId())
 *             .identityInfo(UserIdentityInfoArgs.builder()
 *                 .email("example@example.com")
 *                 .firstName("example")
 *                 .lastName("example2")
 *                 .build())
 *             .phoneConfig(UserPhoneConfigArgs.builder()
 *                 .afterContactWorkTimeLimit(0)
 *                 .phoneType("SOFT_PHONE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:User
 *     properties:
 *       instanceId: ${exampleAwsConnectInstance.id}
 *       name: example
 *       password: Password123
 *       routingProfileId: ${exampleAwsConnectRoutingProfile.routingProfileId}
 *       securityProfileIds:
 *         - ${exampleAwsConnectSecurityProfile.securityProfileId}
 *       identityInfo:
 *         email: example@example.com
 *         firstName: example
 *         lastName: example2
 *       phoneConfig:
 *         afterContactWorkTimeLimit: 0
 *         phoneType: SOFT_PHONE
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With phone_config phone type as desk phone
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.User("example", {
 *     instanceId: exampleAwsConnectInstance.id,
 *     name: "example",
 *     password: "Password123",
 *     routingProfileId: exampleAwsConnectRoutingProfile.routingProfileId,
 *     securityProfileIds: [exampleAwsConnectSecurityProfile&#46;securityProfileId],
 *     phoneConfig: {
 *         afterContactWorkTimeLimit: 0,
 *         phoneType: "SOFT_PHONE",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.User("example",
 *     instance_id=example_aws_connect_instance["id"],
 *     name="example",
 *     password="Password123",
 *     routing_profile_id=example_aws_connect_routing_profile["routingProfileId"],
 *     security_profile_ids=[example_aws_connect_security_profile["securityProfileId"]],
 *     phone_config={
 *         "after_contact_work_time_limit": 0,
 *         "phone_type": "SOFT_PHONE",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.User("example", new()
 *     {
 *         InstanceId = exampleAwsConnectInstance.Id,
 *         Name = "example",
 *         Password = "Password123",
 *         RoutingProfileId = exampleAwsConnectRoutingProfile.RoutingProfileId,
 *         SecurityProfileIds = new[]
 *         {
 *             exampleAwsConnectSecurityProfile.SecurityProfileId,
 *         },
 *         PhoneConfig = new Aws.Connect.Inputs.UserPhoneConfigArgs
 *         {
 *             AfterContactWorkTimeLimit = 0,
 *             PhoneType = "SOFT_PHONE",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewUser(ctx, "example", &connect.UserArgs{
 * 			InstanceId:       pulumi.Any(exampleAwsConnectInstance.Id),
 * 			Name:             pulumi.String("example"),
 * 			Password:         pulumi.String("Password123"),
 * 			RoutingProfileId: pulumi.Any(exampleAwsConnectRoutingProfile.RoutingProfileId),
 * 			SecurityProfileIds: pulumi.StringArray{
 * 				exampleAwsConnectSecurityProfile.SecurityProfileId,
 * 			},
 * 			PhoneConfig: &connect.UserPhoneConfigArgs{
 * 				AfterContactWorkTimeLimit: pulumi.Int(0),
 * 				PhoneType:                 pulumi.String("SOFT_PHONE"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.User;
 * import com.pulumi.aws.connect.UserArgs;
 * import com.pulumi.aws.connect.inputs.UserPhoneConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new User("example", UserArgs.builder()
 *             .instanceId(exampleAwsConnectInstance.id())
 *             .name("example")
 *             .password("Password123")
 *             .routingProfileId(exampleAwsConnectRoutingProfile.routingProfileId())
 *             .securityProfileIds(exampleAwsConnectSecurityProfile.securityProfileId())
 *             .phoneConfig(UserPhoneConfigArgs.builder()
 *                 .afterContactWorkTimeLimit(0)
 *                 .phoneType("SOFT_PHONE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:User
 *     properties:
 *       instanceId: ${exampleAwsConnectInstance.id}
 *       name: example
 *       password: Password123
 *       routingProfileId: ${exampleAwsConnectRoutingProfile.routingProfileId}
 *       securityProfileIds:
 *         - ${exampleAwsConnectSecurityProfile.securityProfileId}
 *       phoneConfig:
 *         afterContactWorkTimeLimit: 0
 *         phoneType: SOFT_PHONE
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With multiple Security profile ids specified in security_profile_ids
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.User("example", {
 *     instanceId: exampleAwsConnectInstance.id,
 *     name: "example",
 *     password: "Password123",
 *     routingProfileId: exampleAwsConnectRoutingProfile.routingProfileId,
 *     securityProfileIds: [
 *         exampleAwsConnectSecurityProfile.securityProfileId,
 *         example2.securityProfileId,
 *     ],
 *     phoneConfig: {
 *         afterContactWorkTimeLimit: 0,
 *         autoAccept: false,
 *         deskPhoneNumber: "+112345678912",
 *         phoneType: "DESK_PHONE",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.User("example",
 *     instance_id=example_aws_connect_instance["id"],
 *     name="example",
 *     password="Password123",
 *     routing_profile_id=example_aws_connect_routing_profile["routingProfileId"],
 *     security_profile_ids=[
 *         example_aws_connect_security_profile["securityProfileId"],
 *         example2["securityProfileId"],
 *     ],
 *     phone_config={
 *         "after_contact_work_time_limit": 0,
 *         "auto_accept": False,
 *         "desk_phone_number": "+112345678912",
 *         "phone_type": "DESK_PHONE",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.User("example", new()
 *     {
 *         InstanceId = exampleAwsConnectInstance.Id,
 *         Name = "example",
 *         Password = "Password123",
 *         RoutingProfileId = exampleAwsConnectRoutingProfile.RoutingProfileId,
 *         SecurityProfileIds = new[]
 *         {
 *             exampleAwsConnectSecurityProfile.SecurityProfileId,
 *             example2.SecurityProfileId,
 *         },
 *         PhoneConfig = new Aws.Connect.Inputs.UserPhoneConfigArgs
 *         {
 *             AfterContactWorkTimeLimit = 0,
 *             AutoAccept = false,
 *             DeskPhoneNumber = "+112345678912",
 *             PhoneType = "DESK_PHONE",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewUser(ctx, "example", &connect.UserArgs{
 * 			InstanceId:       pulumi.Any(exampleAwsConnectInstance.Id),
 * 			Name:             pulumi.String("example"),
 * 			Password:         pulumi.String("Password123"),
 * 			RoutingProfileId: pulumi.Any(exampleAwsConnectRoutingProfile.RoutingProfileId),
 * 			SecurityProfileIds: pulumi.StringArray{
 * 				exampleAwsConnectSecurityProfile.SecurityProfileId,
 * 				example2.SecurityProfileId,
 * 			},
 * 			PhoneConfig: &connect.UserPhoneConfigArgs{
 * 				AfterContactWorkTimeLimit: pulumi.Int(0),
 * 				AutoAccept:                pulumi.Bool(false),
 * 				DeskPhoneNumber:           pulumi.String("+112345678912"),
 * 				PhoneType:                 pulumi.String("DESK_PHONE"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.User;
 * import com.pulumi.aws.connect.UserArgs;
 * import com.pulumi.aws.connect.inputs.UserPhoneConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new User("example", UserArgs.builder()
 *             .instanceId(exampleAwsConnectInstance.id())
 *             .name("example")
 *             .password("Password123")
 *             .routingProfileId(exampleAwsConnectRoutingProfile.routingProfileId())
 *             .securityProfileIds(
 *                 exampleAwsConnectSecurityProfile.securityProfileId(),
 *                 example2.securityProfileId())
 *             .phoneConfig(UserPhoneConfigArgs.builder()
 *                 .afterContactWorkTimeLimit(0)
 *                 .autoAccept(false)
 *                 .deskPhoneNumber("+112345678912")
 *                 .phoneType("DESK_PHONE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:User
 *     properties:
 *       instanceId: ${exampleAwsConnectInstance.id}
 *       name: example
 *       password: Password123
 *       routingProfileId: ${exampleAwsConnectRoutingProfile.routingProfileId}
 *       securityProfileIds:
 *         - ${exampleAwsConnectSecurityProfile.securityProfileId}
 *         - ${example2.securityProfileId}
 *       phoneConfig:
 *         afterContactWorkTimeLimit: 0
 *         autoAccept: false
 *         deskPhoneNumber: '+112345678912'
 *         phoneType: DESK_PHONE
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amazon Connect Users using the `instance_id` and `user_id` separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:connect/user:User example f1288a1f-6193-445a-b47e-af739b2:c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5
 * ```
 * @property directoryUserId The identifier of the user account in the directory used for identity management. If Amazon Connect cannot access the directory, you can specify this identifier to authenticate users. If you include the identifier, we assume that Amazon Connect cannot access the directory. Otherwise, the identity information is used to authenticate users from your directory. This parameter is required if you are using an existing directory for identity management in Amazon Connect when Amazon Connect cannot access your directory to authenticate users. If you are using SAML for identity management and include this parameter, an error is returned.
 * @property hierarchyGroupId The identifier of the hierarchy group for the user.
 * @property identityInfo A block that contains information about the identity of the user. Documented below.
 * @property instanceId Specifies the identifier of the hosting Amazon Connect Instance.
 * @property name The user name for the account. For instances not using SAML for identity management, the user name can include up to 20 characters. If you are using SAML for identity management, the user name can include up to 64 characters from `[a-zA-Z0-9_-&#46;\@]+`.
 * @property password The password for the user account. A password is required if you are using Amazon Connect for identity management. Otherwise, it is an error to include a password.
 * @property phoneConfig A block that contains information about the phone settings for the user. Documented below.
 * @property routingProfileId The identifier of the routing profile for the user.
 * @property securityProfileIds A list of identifiers for the security profiles for the user. Specify a minimum of 1 and maximum of 10 security profile ids. For more information, see [Best Practices for Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html) in the Amazon Connect Administrator Guide.
 * @property tags Tags to apply to the user. If configured with a provider
 * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class UserArgs(
    public val directoryUserId: Output<String>? = null,
    public val hierarchyGroupId: Output<String>? = null,
    public val identityInfo: Output<UserIdentityInfoArgs>? = null,
    public val instanceId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val password: Output<String>? = null,
    public val phoneConfig: Output<UserPhoneConfigArgs>? = null,
    public val routingProfileId: Output<String>? = null,
    public val securityProfileIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.UserArgs> {
    override fun toJava(): com.pulumi.aws.connect.UserArgs = com.pulumi.aws.connect.UserArgs.builder()
        .directoryUserId(directoryUserId?.applyValue({ args0 -> args0 }))
        .hierarchyGroupId(hierarchyGroupId?.applyValue({ args0 -> args0 }))
        .identityInfo(identityInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .instanceId(instanceId?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .password(password?.applyValue({ args0 -> args0 }))
        .phoneConfig(phoneConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .routingProfileId(routingProfileId?.applyValue({ args0 -> args0 }))
        .securityProfileIds(securityProfileIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [UserArgs].
 */
@PulumiTagMarker
public class UserArgsBuilder internal constructor() {
    private var directoryUserId: Output<String>? = null

    private var hierarchyGroupId: Output<String>? = null

    private var identityInfo: Output<UserIdentityInfoArgs>? = null

    private var instanceId: Output<String>? = null

    private var name: Output<String>? = null

    private var password: Output<String>? = null

    private var phoneConfig: Output<UserPhoneConfigArgs>? = null

    private var routingProfileId: Output<String>? = null

    private var securityProfileIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The identifier of the user account in the directory used for identity management. If Amazon Connect cannot access the directory, you can specify this identifier to authenticate users. If you include the identifier, we assume that Amazon Connect cannot access the directory. Otherwise, the identity information is used to authenticate users from your directory. This parameter is required if you are using an existing directory for identity management in Amazon Connect when Amazon Connect cannot access your directory to authenticate users. If you are using SAML for identity management and include this parameter, an error is returned.
     */
    @JvmName("wkwhkphodxcchgap")
    public suspend fun directoryUserId(`value`: Output<String>) {
        this.directoryUserId = value
    }

    /**
     * @param value The identifier of the hierarchy group for the user.
     */
    @JvmName("rmsmqreokbmtumpw")
    public suspend fun hierarchyGroupId(`value`: Output<String>) {
        this.hierarchyGroupId = value
    }

    /**
     * @param value A block that contains information about the identity of the user. Documented below.
     */
    @JvmName("ionopusnqpgcdxxs")
    public suspend fun identityInfo(`value`: Output<UserIdentityInfoArgs>) {
        this.identityInfo = value
    }

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("lishmaycxjuoxvxm")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The user name for the account. For instances not using SAML for identity management, the user name can include up to 20 characters. If you are using SAML for identity management, the user name can include up to 64 characters from `[a-zA-Z0-9_-&#46;\@]+`.
     */
    @JvmName("cmnrdrjarhexliag")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The password for the user account. A password is required if you are using Amazon Connect for identity management. Otherwise, it is an error to include a password.
     */
    @JvmName("xydihonrbmthtdge")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value A block that contains information about the phone settings for the user. Documented below.
     */
    @JvmName("ggpahcwdvirgxnsc")
    public suspend fun phoneConfig(`value`: Output<UserPhoneConfigArgs>) {
        this.phoneConfig = value
    }

    /**
     * @param value The identifier of the routing profile for the user.
     */
    @JvmName("dhjtwxdwmemwrgmb")
    public suspend fun routingProfileId(`value`: Output<String>) {
        this.routingProfileId = value
    }

    /**
     * @param value A list of identifiers for the security profiles for the user. Specify a minimum of 1 and maximum of 10 security profile ids. For more information, see [Best Practices for Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html) in the Amazon Connect Administrator Guide.
     */
    @JvmName("eotmrnjbyspggdfg")
    public suspend fun securityProfileIds(`value`: Output<List<String>>) {
        this.securityProfileIds = value
    }

    @JvmName("pinkwpxvnufttaxb")
    public suspend fun securityProfileIds(vararg values: Output<String>) {
        this.securityProfileIds = Output.all(values.asList())
    }

    /**
     * @param values A list of identifiers for the security profiles for the user. Specify a minimum of 1 and maximum of 10 security profile ids. For more information, see [Best Practices for Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html) in the Amazon Connect Administrator Guide.
     */
    @JvmName("xhvbocplolxxpned")
    public suspend fun securityProfileIds(values: List<Output<String>>) {
        this.securityProfileIds = Output.all(values)
    }

    /**
     * @param value Tags to apply to the user. If configured with a provider
     * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ystuigwsiqfrevwm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The identifier of the user account in the directory used for identity management. If Amazon Connect cannot access the directory, you can specify this identifier to authenticate users. If you include the identifier, we assume that Amazon Connect cannot access the directory. Otherwise, the identity information is used to authenticate users from your directory. This parameter is required if you are using an existing directory for identity management in Amazon Connect when Amazon Connect cannot access your directory to authenticate users. If you are using SAML for identity management and include this parameter, an error is returned.
     */
    @JvmName("ijqqjpwiwpndsgmw")
    public suspend fun directoryUserId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryUserId = mapped
    }

    /**
     * @param value The identifier of the hierarchy group for the user.
     */
    @JvmName("vquwnqypepsmluvj")
    public suspend fun hierarchyGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hierarchyGroupId = mapped
    }

    /**
     * @param value A block that contains information about the identity of the user. Documented below.
     */
    @JvmName("ngdqpgvruxanpuhe")
    public suspend fun identityInfo(`value`: UserIdentityInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityInfo = mapped
    }

    /**
     * @param argument A block that contains information about the identity of the user. Documented below.
     */
    @JvmName("wanquchosusstbcb")
    public suspend fun identityInfo(argument: suspend UserIdentityInfoArgsBuilder.() -> Unit) {
        val toBeMapped = UserIdentityInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identityInfo = mapped
    }

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("knhxcfrlrlamrpas")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The user name for the account. For instances not using SAML for identity management, the user name can include up to 20 characters. If you are using SAML for identity management, the user name can include up to 64 characters from `[a-zA-Z0-9_-&#46;\@]+`.
     */
    @JvmName("vweloaxrqxygnbdf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The password for the user account. A password is required if you are using Amazon Connect for identity management. Otherwise, it is an error to include a password.
     */
    @JvmName("elhifehunuygupdn")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value A block that contains information about the phone settings for the user. Documented below.
     */
    @JvmName("kdhqpdspvmjfuwrv")
    public suspend fun phoneConfig(`value`: UserPhoneConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phoneConfig = mapped
    }

    /**
     * @param argument A block that contains information about the phone settings for the user. Documented below.
     */
    @JvmName("axxjvohpckigytti")
    public suspend fun phoneConfig(argument: suspend UserPhoneConfigArgsBuilder.() -> Unit) {
        val toBeMapped = UserPhoneConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.phoneConfig = mapped
    }

    /**
     * @param value The identifier of the routing profile for the user.
     */
    @JvmName("qmeuoseqrlcmqccv")
    public suspend fun routingProfileId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingProfileId = mapped
    }

    /**
     * @param value A list of identifiers for the security profiles for the user. Specify a minimum of 1 and maximum of 10 security profile ids. For more information, see [Best Practices for Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html) in the Amazon Connect Administrator Guide.
     */
    @JvmName("kvmiwpqknugxvntt")
    public suspend fun securityProfileIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityProfileIds = mapped
    }

    /**
     * @param values A list of identifiers for the security profiles for the user. Specify a minimum of 1 and maximum of 10 security profile ids. For more information, see [Best Practices for Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html) in the Amazon Connect Administrator Guide.
     */
    @JvmName("iomoqllbtutwsqsl")
    public suspend fun securityProfileIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityProfileIds = mapped
    }

    /**
     * @param value Tags to apply to the user. If configured with a provider
     * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uqudglwfvxnwapgg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to apply to the user. If configured with a provider
     * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qmhpctynyymklemj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): UserArgs = UserArgs(
        directoryUserId = directoryUserId,
        hierarchyGroupId = hierarchyGroupId,
        identityInfo = identityInfo,
        instanceId = instanceId,
        name = name,
        password = password,
        phoneConfig = phoneConfig,
        routingProfileId = routingProfileId,
        securityProfileIds = securityProfileIds,
        tags = tags,
    )
}
