@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.kotlin.outputs.UserHierarchyStructureHierarchyStructure
import com.pulumi.aws.connect.kotlin.outputs.UserHierarchyStructureHierarchyStructure.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [UserHierarchyStructure].
 */
@PulumiTagMarker
public class UserHierarchyStructureResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserHierarchyStructureArgs = UserHierarchyStructureArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserHierarchyStructureArgsBuilder.() -> Unit) {
        val builder = UserHierarchyStructureArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): UserHierarchyStructure {
        val builtJavaResource = com.pulumi.aws.connect.UserHierarchyStructure(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserHierarchyStructure(builtJavaResource)
    }
}

/**
 * Provides an Amazon Connect User Hierarchy Structure resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.UserHierarchyStructure("example", {
 *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     hierarchyStructure: {
 *         levelOne: {
 *             name: "levelone",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.UserHierarchyStructure("example",
 *     instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     hierarchy_structure={
 *         "level_one": {
 *             "name": "levelone",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.UserHierarchyStructure("example", new()
 *     {
 *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *         HierarchyStructure = new Aws.Connect.Inputs.UserHierarchyStructureHierarchyStructureArgs
 *         {
 *             LevelOne = new Aws.Connect.Inputs.UserHierarchyStructureHierarchyStructureLevelOneArgs
 *             {
 *                 Name = "levelone",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewUserHierarchyStructure(ctx, "example", &connect.UserHierarchyStructureArgs{
 * 			InstanceId: pulumi.String("aaaaaaaa-bbbb-cccc-dddd-111111111111"),
 * 			HierarchyStructure: &connect.UserHierarchyStructureHierarchyStructureArgs{
 * 				LevelOne: &connect.UserHierarchyStructureHierarchyStructureLevelOneArgs{
 * 					Name: pulumi.String("levelone"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.UserHierarchyStructure;
 * import com.pulumi.aws.connect.UserHierarchyStructureArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelOneArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new UserHierarchyStructure("example", UserHierarchyStructureArgs.builder()
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .hierarchyStructure(UserHierarchyStructureHierarchyStructureArgs.builder()
 *                 .levelOne(UserHierarchyStructureHierarchyStructureLevelOneArgs.builder()
 *                     .name("levelone")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:UserHierarchyStructure
 *     properties:
 *       instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
 *       hierarchyStructure:
 *         levelOne:
 *           name: levelone
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Five Levels
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.UserHierarchyStructure("example", {
 *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     hierarchyStructure: {
 *         levelOne: {
 *             name: "levelone",
 *         },
 *         levelTwo: {
 *             name: "leveltwo",
 *         },
 *         levelThree: {
 *             name: "levelthree",
 *         },
 *         levelFour: {
 *             name: "levelfour",
 *         },
 *         levelFive: {
 *             name: "levelfive",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.UserHierarchyStructure("example",
 *     instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     hierarchy_structure={
 *         "level_one": {
 *             "name": "levelone",
 *         },
 *         "level_two": {
 *             "name": "leveltwo",
 *         },
 *         "level_three": {
 *             "name": "levelthree",
 *         },
 *         "level_four": {
 *             "name": "levelfour",
 *         },
 *         "level_five": {
 *             "name": "levelfive",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.UserHierarchyStructure("example", new()
 *     {
 *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *         HierarchyStructure = new Aws.Connect.Inputs.UserHierarchyStructureHierarchyStructureArgs
 *         {
 *             LevelOne = new Aws.Connect.Inputs.UserHierarchyStructureHierarchyStructureLevelOneArgs
 *             {
 *                 Name = "levelone",
 *             },
 *             LevelTwo = new Aws.Connect.Inputs.UserHierarchyStructureHierarchyStructureLevelTwoArgs
 *             {
 *                 Name = "leveltwo",
 *             },
 *             LevelThree = new Aws.Connect.Inputs.UserHierarchyStructureHierarchyStructureLevelThreeArgs
 *             {
 *                 Name = "levelthree",
 *             },
 *             LevelFour = new Aws.Connect.Inputs.UserHierarchyStructureHierarchyStructureLevelFourArgs
 *             {
 *                 Name = "levelfour",
 *             },
 *             LevelFive = new Aws.Connect.Inputs.UserHierarchyStructureHierarchyStructureLevelFiveArgs
 *             {
 *                 Name = "levelfive",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewUserHierarchyStructure(ctx, "example", &connect.UserHierarchyStructureArgs{
 * 			InstanceId: pulumi.String("aaaaaaaa-bbbb-cccc-dddd-111111111111"),
 * 			HierarchyStructure: &connect.UserHierarchyStructureHierarchyStructureArgs{
 * 				LevelOne: &connect.UserHierarchyStructureHierarchyStructureLevelOneArgs{
 * 					Name: pulumi.String("levelone"),
 * 				},
 * 				LevelTwo: &connect.UserHierarchyStructureHierarchyStructureLevelTwoArgs{
 * 					Name: pulumi.String("leveltwo"),
 * 				},
 * 				LevelThree: &connect.UserHierarchyStructureHierarchyStructureLevelThreeArgs{
 * 					Name: pulumi.String("levelthree"),
 * 				},
 * 				LevelFour: &connect.UserHierarchyStructureHierarchyStructureLevelFourArgs{
 * 					Name: pulumi.String("levelfour"),
 * 				},
 * 				LevelFive: &connect.UserHierarchyStructureHierarchyStructureLevelFiveArgs{
 * 					Name: pulumi.String("levelfive"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.UserHierarchyStructure;
 * import com.pulumi.aws.connect.UserHierarchyStructureArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelOneArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelTwoArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelThreeArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelFourArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelFiveArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new UserHierarchyStructure("example", UserHierarchyStructureArgs.builder()
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .hierarchyStructure(UserHierarchyStructureHierarchyStructureArgs.builder()
 *                 .levelOne(UserHierarchyStructureHierarchyStructureLevelOneArgs.builder()
 *                     .name("levelone")
 *                     .build())
 *                 .levelTwo(UserHierarchyStructureHierarchyStructureLevelTwoArgs.builder()
 *                     .name("leveltwo")
 *                     .build())
 *                 .levelThree(UserHierarchyStructureHierarchyStructureLevelThreeArgs.builder()
 *                     .name("levelthree")
 *                     .build())
 *                 .levelFour(UserHierarchyStructureHierarchyStructureLevelFourArgs.builder()
 *                     .name("levelfour")
 *                     .build())
 *                 .levelFive(UserHierarchyStructureHierarchyStructureLevelFiveArgs.builder()
 *                     .name("levelfive")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:UserHierarchyStructure
 *     properties:
 *       instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
 *       hierarchyStructure:
 *         levelOne:
 *           name: levelone
 *         levelTwo:
 *           name: leveltwo
 *         levelThree:
 *           name: levelthree
 *         levelFour:
 *           name: levelfour
 *         levelFive:
 *           name: levelfive
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amazon Connect User Hierarchy Structures using the `instance_id`. For example:
 * ```sh
 * $ pulumi import aws:connect/userHierarchyStructure:UserHierarchyStructure example f1288a1f-6193-445a-b47e-af739b2
 * ```
 */
public class UserHierarchyStructure internal constructor(
    override val javaResource: com.pulumi.aws.connect.UserHierarchyStructure,
) : KotlinCustomResource(javaResource, UserHierarchyStructureMapper) {
    /**
     * A block that defines the hierarchy structure's levels. The `hierarchy_structure` block is documented below.
     */
    public val hierarchyStructure: Output<UserHierarchyStructureHierarchyStructure>
        get() = javaResource.hierarchyStructure().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Specifies the identifier of the hosting Amazon Connect Instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })
}

public object UserHierarchyStructureMapper : ResourceMapper<UserHierarchyStructure> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.connect.UserHierarchyStructure::class == javaResource::class

    override fun map(javaResource: Resource): UserHierarchyStructure =
        UserHierarchyStructure(javaResource as com.pulumi.aws.connect.UserHierarchyStructure)
}

/**
 * @see [UserHierarchyStructure].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserHierarchyStructure].
 */
public suspend fun userHierarchyStructure(
    name: String,
    block: suspend UserHierarchyStructureResourceBuilder.() -> Unit,
): UserHierarchyStructure {
    val builder = UserHierarchyStructureResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserHierarchyStructure].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userHierarchyStructure(name: String): UserHierarchyStructure {
    val builder = UserHierarchyStructureResourceBuilder()
    builder.name(name)
    return builder.build()
}
