@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.UserHierarchyStructureArgs.builder
import com.pulumi.aws.connect.kotlin.inputs.UserHierarchyStructureHierarchyStructureArgs
import com.pulumi.aws.connect.kotlin.inputs.UserHierarchyStructureHierarchyStructureArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Connect User Hierarchy Structure resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.UserHierarchyStructure("example", {
 *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     hierarchyStructure: {
 *         levelOne: {
 *             name: "levelone",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.UserHierarchyStructure("example",
 *     instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     hierarchy_structure={
 *         "level_one": {
 *             "name": "levelone",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.UserHierarchyStructure("example", new()
 *     {
 *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *         HierarchyStructure = new Aws.Connect.Inputs.UserHierarchyStructureHierarchyStructureArgs
 *         {
 *             LevelOne = new Aws.Connect.Inputs.UserHierarchyStructureHierarchyStructureLevelOneArgs
 *             {
 *                 Name = "levelone",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewUserHierarchyStructure(ctx, "example", &connect.UserHierarchyStructureArgs{
 * 			InstanceId: pulumi.String("aaaaaaaa-bbbb-cccc-dddd-111111111111"),
 * 			HierarchyStructure: &connect.UserHierarchyStructureHierarchyStructureArgs{
 * 				LevelOne: &connect.UserHierarchyStructureHierarchyStructureLevelOneArgs{
 * 					Name: pulumi.String("levelone"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.UserHierarchyStructure;
 * import com.pulumi.aws.connect.UserHierarchyStructureArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelOneArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new UserHierarchyStructure("example", UserHierarchyStructureArgs.builder()
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .hierarchyStructure(UserHierarchyStructureHierarchyStructureArgs.builder()
 *                 .levelOne(UserHierarchyStructureHierarchyStructureLevelOneArgs.builder()
 *                     .name("levelone")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:UserHierarchyStructure
 *     properties:
 *       instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
 *       hierarchyStructure:
 *         levelOne:
 *           name: levelone
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Five Levels
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.UserHierarchyStructure("example", {
 *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     hierarchyStructure: {
 *         levelOne: {
 *             name: "levelone",
 *         },
 *         levelTwo: {
 *             name: "leveltwo",
 *         },
 *         levelThree: {
 *             name: "levelthree",
 *         },
 *         levelFour: {
 *             name: "levelfour",
 *         },
 *         levelFive: {
 *             name: "levelfive",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.UserHierarchyStructure("example",
 *     instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     hierarchy_structure={
 *         "level_one": {
 *             "name": "levelone",
 *         },
 *         "level_two": {
 *             "name": "leveltwo",
 *         },
 *         "level_three": {
 *             "name": "levelthree",
 *         },
 *         "level_four": {
 *             "name": "levelfour",
 *         },
 *         "level_five": {
 *             "name": "levelfive",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.UserHierarchyStructure("example", new()
 *     {
 *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *         HierarchyStructure = new Aws.Connect.Inputs.UserHierarchyStructureHierarchyStructureArgs
 *         {
 *             LevelOne = new Aws.Connect.Inputs.UserHierarchyStructureHierarchyStructureLevelOneArgs
 *             {
 *                 Name = "levelone",
 *             },
 *             LevelTwo = new Aws.Connect.Inputs.UserHierarchyStructureHierarchyStructureLevelTwoArgs
 *             {
 *                 Name = "leveltwo",
 *             },
 *             LevelThree = new Aws.Connect.Inputs.UserHierarchyStructureHierarchyStructureLevelThreeArgs
 *             {
 *                 Name = "levelthree",
 *             },
 *             LevelFour = new Aws.Connect.Inputs.UserHierarchyStructureHierarchyStructureLevelFourArgs
 *             {
 *                 Name = "levelfour",
 *             },
 *             LevelFive = new Aws.Connect.Inputs.UserHierarchyStructureHierarchyStructureLevelFiveArgs
 *             {
 *                 Name = "levelfive",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewUserHierarchyStructure(ctx, "example", &connect.UserHierarchyStructureArgs{
 * 			InstanceId: pulumi.String("aaaaaaaa-bbbb-cccc-dddd-111111111111"),
 * 			HierarchyStructure: &connect.UserHierarchyStructureHierarchyStructureArgs{
 * 				LevelOne: &connect.UserHierarchyStructureHierarchyStructureLevelOneArgs{
 * 					Name: pulumi.String("levelone"),
 * 				},
 * 				LevelTwo: &connect.UserHierarchyStructureHierarchyStructureLevelTwoArgs{
 * 					Name: pulumi.String("leveltwo"),
 * 				},
 * 				LevelThree: &connect.UserHierarchyStructureHierarchyStructureLevelThreeArgs{
 * 					Name: pulumi.String("levelthree"),
 * 				},
 * 				LevelFour: &connect.UserHierarchyStructureHierarchyStructureLevelFourArgs{
 * 					Name: pulumi.String("levelfour"),
 * 				},
 * 				LevelFive: &connect.UserHierarchyStructureHierarchyStructureLevelFiveArgs{
 * 					Name: pulumi.String("levelfive"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.UserHierarchyStructure;
 * import com.pulumi.aws.connect.UserHierarchyStructureArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelOneArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelTwoArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelThreeArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelFourArgs;
 * import com.pulumi.aws.connect.inputs.UserHierarchyStructureHierarchyStructureLevelFiveArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new UserHierarchyStructure("example", UserHierarchyStructureArgs.builder()
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .hierarchyStructure(UserHierarchyStructureHierarchyStructureArgs.builder()
 *                 .levelOne(UserHierarchyStructureHierarchyStructureLevelOneArgs.builder()
 *                     .name("levelone")
 *                     .build())
 *                 .levelTwo(UserHierarchyStructureHierarchyStructureLevelTwoArgs.builder()
 *                     .name("leveltwo")
 *                     .build())
 *                 .levelThree(UserHierarchyStructureHierarchyStructureLevelThreeArgs.builder()
 *                     .name("levelthree")
 *                     .build())
 *                 .levelFour(UserHierarchyStructureHierarchyStructureLevelFourArgs.builder()
 *                     .name("levelfour")
 *                     .build())
 *                 .levelFive(UserHierarchyStructureHierarchyStructureLevelFiveArgs.builder()
 *                     .name("levelfive")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:UserHierarchyStructure
 *     properties:
 *       instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
 *       hierarchyStructure:
 *         levelOne:
 *           name: levelone
 *         levelTwo:
 *           name: leveltwo
 *         levelThree:
 *           name: levelthree
 *         levelFour:
 *           name: levelfour
 *         levelFive:
 *           name: levelfive
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amazon Connect User Hierarchy Structures using the `instance_id`. For example:
 * ```sh
 * $ pulumi import aws:connect/userHierarchyStructure:UserHierarchyStructure example f1288a1f-6193-445a-b47e-af739b2
 * ```
 * @property hierarchyStructure A block that defines the hierarchy structure's levels. The `hierarchy_structure` block is documented below.
 * @property instanceId Specifies the identifier of the hosting Amazon Connect Instance.
 */
public data class UserHierarchyStructureArgs(
    public val hierarchyStructure: Output<UserHierarchyStructureHierarchyStructureArgs>? = null,
    public val instanceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.UserHierarchyStructureArgs> {
    override fun toJava(): com.pulumi.aws.connect.UserHierarchyStructureArgs =
        com.pulumi.aws.connect.UserHierarchyStructureArgs.builder()
            .hierarchyStructure(
                hierarchyStructure?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .instanceId(instanceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserHierarchyStructureArgs].
 */
@PulumiTagMarker
public class UserHierarchyStructureArgsBuilder internal constructor() {
    private var hierarchyStructure: Output<UserHierarchyStructureHierarchyStructureArgs>? = null

    private var instanceId: Output<String>? = null

    /**
     * @param value A block that defines the hierarchy structure's levels. The `hierarchy_structure` block is documented below.
     */
    @JvmName("dfmeynnvqolpjgfr")
    public suspend fun hierarchyStructure(`value`: Output<UserHierarchyStructureHierarchyStructureArgs>) {
        this.hierarchyStructure = value
    }

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("erhqpddqffkohlmy")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value A block that defines the hierarchy structure's levels. The `hierarchy_structure` block is documented below.
     */
    @JvmName("krsvwgldplllxljd")
    public suspend fun hierarchyStructure(`value`: UserHierarchyStructureHierarchyStructureArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hierarchyStructure = mapped
    }

    /**
     * @param argument A block that defines the hierarchy structure's levels. The `hierarchy_structure` block is documented below.
     */
    @JvmName("kigcdmwovunbhdwt")
    public suspend fun hierarchyStructure(argument: suspend UserHierarchyStructureHierarchyStructureArgsBuilder.() -> Unit) {
        val toBeMapped = UserHierarchyStructureHierarchyStructureArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.hierarchyStructure = mapped
    }

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("nhjjwxhkgpwmwxcm")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    internal fun build(): UserHierarchyStructureArgs = UserHierarchyStructureArgs(
        hierarchyStructure = hierarchyStructure,
        instanceId = instanceId,
    )
}
