@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Vocabulary].
 */
@PulumiTagMarker
public class VocabularyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VocabularyArgs = VocabularyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VocabularyArgsBuilder.() -> Unit) {
        val builder = VocabularyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Vocabulary {
        val builtJavaResource = com.pulumi.aws.connect.Vocabulary(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Vocabulary(builtJavaResource)
    }
}

/**
 * Provides an Amazon Connect Vocabulary resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.connect.Vocabulary("example", {
 *     instanceId: "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name: "example",
 *     content: `Phrase\x09IPA\x09SoundsLike\x09DisplayAs
 * Los-Angeles\x09\x09\x09Los Angeles
 * F.B.I.\x09ɛ f b i aɪ\x09\x09FBI
 * Etienne\x09\x09eh-tee-en\x09`,
 *     languageCode: "en-US",
 *     tags: {
 *         Key1: "Value1",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.connect.Vocabulary("example",
 *     instance_id="aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *     name="example",
 *     content="""Phrase\x09IPA\x09SoundsLike\x09DisplayAs
 * Los-Angeles\x09\x09\x09Los Angeles
 * F.B.I.\x09ɛ f b i aɪ\x09\x09FBI
 * Etienne\x09\x09eh-tee-en\x09""",
 *     language_code="en-US",
 *     tags={
 *         "Key1": "Value1",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Connect.Vocabulary("example", new()
 *     {
 *         InstanceId = "aaaaaaaa-bbbb-cccc-dddd-111111111111",
 *         Name = "example",
 *         Content = @"Phrase	IPA	SoundsLike	DisplayAs
 * Los-Angeles			Los Angeles
 * F.B.I.	ɛ f b i aɪ		FBI
 * Etienne		eh-tee-en	",
 *         LanguageCode = "en-US",
 *         Tags =
 *         {
 *             { "Key1", "Value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/connect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := connect.NewVocabulary(ctx, "example", &connect.VocabularyArgs{
 * 			InstanceId:   pulumi.String("aaaaaaaa-bbbb-cccc-dddd-111111111111"),
 * 			Name:         pulumi.String("example"),
 * 			Content:      pulumi.String("Phrase	IPA	SoundsLike	DisplayAs\nLos-Angeles			Los Angeles\nF.B.I.	ɛ f b i aɪ		FBI\nEtienne		eh-tee-en	"),
 * 			LanguageCode: pulumi.String("en-US"),
 * 			Tags: pulumi.StringMap{
 * 				"Key1": pulumi.String("Value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.Vocabulary;
 * import com.pulumi.aws.connect.VocabularyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Vocabulary("example", VocabularyArgs.builder()
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .name("example")
 *             .content("""
 * Phrase	IPA	SoundsLike	DisplayAs
 * Los-Angeles			Los Angeles
 * F.B.I.	ɛ f b i aɪ		FBI
 * Etienne		eh-tee-en	            """)
 *             .languageCode("en-US")
 *             .tags(Map.of("Key1", "Value1"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:connect:Vocabulary
 *     properties:
 *       instanceId: aaaaaaaa-bbbb-cccc-dddd-111111111111
 *       name: example
 *       content: |-
 *         Phrase	IPA	SoundsLike	DisplayAs
 *         Los-Angeles			Los Angeles
 *         F.B.I.	ɛ f b i aɪ		FBI
 *         Etienne		eh-tee-en
 *       languageCode: en-US
 *       tags:
 *         Key1: Value1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amazon Connect Vocabularies using the `instance_id` and `vocabulary_id` separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:connect/vocabulary:Vocabulary example f1288a1f-6193-445a-b47e-af739b2:c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5
 * ```
 */
public class Vocabulary internal constructor(
    override val javaResource: com.pulumi.aws.connect.Vocabulary,
) : KotlinCustomResource(javaResource, VocabularyMapper) {
    /**
     * The Amazon Resource Name (ARN) of the vocabulary.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The content of the custom vocabulary in plain-text format with a table of values. Each row in the table represents a word or a phrase, described with Phrase, IPA, SoundsLike, and DisplayAs fields. Separate the fields with TAB characters. For more information, see [Create a custom vocabulary using a table](https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html#create-vocabulary-table). Minimum length of `1`. Maximum length of `60000`.
     */
    public val content: Output<String>
        get() = javaResource.content().applyValue({ args0 -> args0 })

    /**
     * The reason why the custom vocabulary was not created.
     */
    public val failureReason: Output<String>
        get() = javaResource.failureReason().applyValue({ args0 -> args0 })

    /**
     * Specifies the identifier of the hosting Amazon Connect Instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see [What is Amazon Transcribe?](https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html). Valid Values are `ar-AE`, `de-CH`, `de-DE`, `en-AB`, `en-AU`, `en-GB`, `en-IE`, `en-IN`, `en-US`, `en-WL`, `es-ES`, `es-US`, `fr-CA`, `fr-FR`, `hi-IN`, `it-IT`, `ja-JP`, `ko-KR`, `pt-BR`, `pt-PT`, `zh-CN`.
     */
    public val languageCode: Output<String>
        get() = javaResource.languageCode().applyValue({ args0 -> args0 })

    /**
     * The timestamp when the custom vocabulary was last modified.
     */
    public val lastModifiedTime: Output<String>
        get() = javaResource.lastModifiedTime().applyValue({ args0 -> args0 })

    /**
     * A unique name of the custom vocabulary. Must not be more than 140 characters.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The current state of the custom vocabulary. Valid values are `CREATION_IN_PROGRESS`, `ACTIVE`, `CREATION_FAILED`, `DELETE_IN_PROGRESS`.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Tags to apply to the vocabulary. If configured with a provider
     * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The identifier of the custom vocabulary.
     */
    public val vocabularyId: Output<String>
        get() = javaResource.vocabularyId().applyValue({ args0 -> args0 })
}

public object VocabularyMapper : ResourceMapper<Vocabulary> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.connect.Vocabulary::class == javaResource::class

    override fun map(javaResource: Resource): Vocabulary = Vocabulary(
        javaResource as
            com.pulumi.aws.connect.Vocabulary,
    )
}

/**
 * @see [Vocabulary].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Vocabulary].
 */
public suspend fun vocabulary(name: String, block: suspend VocabularyResourceBuilder.() -> Unit): Vocabulary {
    val builder = VocabularyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Vocabulary].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vocabulary(name: String): Vocabulary {
    val builder = VocabularyResourceBuilder()
    builder.name(name)
    return builder.build()
}
