@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.BotAssociationLexBotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property lexRegion The Region that the Amazon Lex (V1) bot was created in. Defaults to current region.
 * @property name The name of the Amazon Lex (V1) bot.
 */
public data class BotAssociationLexBotArgs(
    public val lexRegion: Output<String>? = null,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.BotAssociationLexBotArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.BotAssociationLexBotArgs =
        com.pulumi.aws.connect.inputs.BotAssociationLexBotArgs.builder()
            .lexRegion(lexRegion?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BotAssociationLexBotArgs].
 */
@PulumiTagMarker
public class BotAssociationLexBotArgsBuilder internal constructor() {
    private var lexRegion: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The Region that the Amazon Lex (V1) bot was created in. Defaults to current region.
     */
    @JvmName("jlmpgayjlahbgnei")
    public suspend fun lexRegion(`value`: Output<String>) {
        this.lexRegion = value
    }

    /**
     * @param value The name of the Amazon Lex (V1) bot.
     */
    @JvmName("tdoqfiuumhvliosq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Region that the Amazon Lex (V1) bot was created in. Defaults to current region.
     */
    @JvmName("dmjrowferuxsoidq")
    public suspend fun lexRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lexRegion = mapped
    }

    /**
     * @param value The name of the Amazon Lex (V1) bot.
     */
    @JvmName("dnnxgiaauyndfgxe")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): BotAssociationLexBotArgs = BotAssociationLexBotArgs(
        lexRegion = lexRegion,
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
