@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.GetBotAssociationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBotAssociation.
 * @property instanceId Identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
 * @property lexBot Configuration information of an Amazon Lex (V1) bot. Detailed below.
 */
public data class GetBotAssociationPlainArgs(
    public val instanceId: String,
    public val lexBot: GetBotAssociationLexBot,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.GetBotAssociationPlainArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.GetBotAssociationPlainArgs =
        com.pulumi.aws.connect.inputs.GetBotAssociationPlainArgs.builder()
            .instanceId(instanceId.let({ args0 -> args0 }))
            .lexBot(lexBot.let({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GetBotAssociationPlainArgs].
 */
@PulumiTagMarker
public class GetBotAssociationPlainArgsBuilder internal constructor() {
    private var instanceId: String? = null

    private var lexBot: GetBotAssociationLexBot? = null

    /**
     * @param value Identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    @JvmName("lrycpblxlgjaixyt")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value Configuration information of an Amazon Lex (V1) bot. Detailed below.
     */
    @JvmName("anyalxpvimugdjny")
    public suspend fun lexBot(`value`: GetBotAssociationLexBot) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.lexBot = mapped
    }

    /**
     * @param argument Configuration information of an Amazon Lex (V1) bot. Detailed below.
     */
    @JvmName("nsiudidipycglugf")
    public suspend fun lexBot(argument: suspend GetBotAssociationLexBotBuilder.() -> Unit) {
        val toBeMapped = GetBotAssociationLexBotBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.lexBot = mapped
    }

    internal fun build(): GetBotAssociationPlainArgs = GetBotAssociationPlainArgs(
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        lexBot = lexBot ?: throw PulumiNullFieldException("lexBot"),
    )
}
