@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.GetLambdaFunctionAssociationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLambdaFunctionAssociation.
 * @property functionArn ARN of the Lambda Function, omitting any version or alias qualifier.
 * @property instanceId Identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
 */
public data class GetLambdaFunctionAssociationPlainArgs(
    public val functionArn: String,
    public val instanceId: String,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.GetLambdaFunctionAssociationPlainArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.GetLambdaFunctionAssociationPlainArgs =
        com.pulumi.aws.connect.inputs.GetLambdaFunctionAssociationPlainArgs.builder()
            .functionArn(functionArn.let({ args0 -> args0 }))
            .instanceId(instanceId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLambdaFunctionAssociationPlainArgs].
 */
@PulumiTagMarker
public class GetLambdaFunctionAssociationPlainArgsBuilder internal constructor() {
    private var functionArn: String? = null

    private var instanceId: String? = null

    /**
     * @param value ARN of the Lambda Function, omitting any version or alias qualifier.
     */
    @JvmName("mkfluthrtdooipeh")
    public suspend fun functionArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.functionArn = mapped
    }

    /**
     * @param value Identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    @JvmName("rdfyhfigsqkksrhn")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    internal fun build(): GetLambdaFunctionAssociationPlainArgs =
        GetLambdaFunctionAssociationPlainArgs(
            functionArn = functionArn ?: throw PulumiNullFieldException("functionArn"),
            instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        )
}
