@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.GetPromptPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPrompt.
 * @property instanceId Reference to the hosting Amazon Connect Instance
 * @property name Returns information on a specific Prompt by name
 */
public data class GetPromptPlainArgs(
    public val instanceId: String,
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.GetPromptPlainArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.GetPromptPlainArgs =
        com.pulumi.aws.connect.inputs.GetPromptPlainArgs.builder()
            .instanceId(instanceId.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPromptPlainArgs].
 */
@PulumiTagMarker
public class GetPromptPlainArgsBuilder internal constructor() {
    private var instanceId: String? = null

    private var name: String? = null

    /**
     * @param value Reference to the hosting Amazon Connect Instance
     */
    @JvmName("qnecwfjlokndddsb")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value Returns information on a specific Prompt by name
     */
    @JvmName("jntpcrfalurswvdd")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetPromptPlainArgs = GetPromptPlainArgs(
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
