@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.GetQueuePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getQueue.
 * @property instanceId Reference to the hosting Amazon Connect Instance
 * @property name Returns information on a specific Queue by name
 * @property queueId Returns information on a specific Queue by Queue id
 * @property tags Map of tags assigned to the Queue.
 */
public data class GetQueuePlainArgs(
    public val instanceId: String,
    public val name: String? = null,
    public val queueId: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.GetQueuePlainArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.GetQueuePlainArgs =
        com.pulumi.aws.connect.inputs.GetQueuePlainArgs.builder()
            .instanceId(instanceId.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .queueId(queueId?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetQueuePlainArgs].
 */
@PulumiTagMarker
public class GetQueuePlainArgsBuilder internal constructor() {
    private var instanceId: String? = null

    private var name: String? = null

    private var queueId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Reference to the hosting Amazon Connect Instance
     */
    @JvmName("hqcsguokuiykpubj")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value Returns information on a specific Queue by name
     */
    @JvmName("vhdddlbterpmyxnn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Returns information on a specific Queue by Queue id
     */
    @JvmName("schcyiekkewwmoxg")
    public suspend fun queueId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.queueId = mapped
    }

    /**
     * @param value Map of tags assigned to the Queue.
     */
    @JvmName("kffpxkhujbhljrku")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags assigned to the Queue.
     */
    @JvmName("xrhbgggeekvytbyw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetQueuePlainArgs = GetQueuePlainArgs(
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        name = name,
        queueId = queueId,
        tags = tags,
    )
}
