@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.GetUserHierarchyStructurePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getUserHierarchyStructure.
 * @property instanceId Reference to the hosting Amazon Connect Instance
 */
public data class GetUserHierarchyStructurePlainArgs(
    public val instanceId: String,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.GetUserHierarchyStructurePlainArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.GetUserHierarchyStructurePlainArgs =
        com.pulumi.aws.connect.inputs.GetUserHierarchyStructurePlainArgs.builder()
            .instanceId(instanceId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUserHierarchyStructurePlainArgs].
 */
@PulumiTagMarker
public class GetUserHierarchyStructurePlainArgsBuilder internal constructor() {
    private var instanceId: String? = null

    /**
     * @param value Reference to the hosting Amazon Connect Instance
     */
    @JvmName("scurwmiaslhuxilm")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    internal fun build(): GetUserHierarchyStructurePlainArgs = GetUserHierarchyStructurePlainArgs(
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
    )
}
