@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisStreamConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property streamArn The Amazon Resource Name (ARN) of the data stream.
 */
public data class InstanceStorageConfigStorageConfigKinesisStreamConfigArgs(
    public val streamArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisStreamConfigArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisStreamConfigArgs =
        com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisStreamConfigArgs.builder()
            .streamArn(streamArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceStorageConfigStorageConfigKinesisStreamConfigArgs].
 */
@PulumiTagMarker
public class InstanceStorageConfigStorageConfigKinesisStreamConfigArgsBuilder internal constructor() {
    private var streamArn: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the data stream.
     */
    @JvmName("xnotflkyvuqexxgd")
    public suspend fun streamArn(`value`: Output<String>) {
        this.streamArn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the data stream.
     */
    @JvmName("kjhplopowbpnquak")
    public suspend fun streamArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streamArn = mapped
    }

    internal fun build(): InstanceStorageConfigStorageConfigKinesisStreamConfigArgs =
        InstanceStorageConfigStorageConfigKinesisStreamConfigArgs(
            streamArn = streamArn ?: throw PulumiNullFieldException("streamArn"),
        )
}
