@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.QuickConnectQuickConnectConfigUserConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property contactFlowId Specifies the identifier of the contact flow.
 * @property userId Specifies the identifier for the user.
 */
public data class QuickConnectQuickConnectConfigUserConfigArgs(
    public val contactFlowId: Output<String>,
    public val userId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.QuickConnectQuickConnectConfigUserConfigArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.QuickConnectQuickConnectConfigUserConfigArgs = com.pulumi.aws.connect.inputs.QuickConnectQuickConnectConfigUserConfigArgs.builder()
        .contactFlowId(contactFlowId.applyValue({ args0 -> args0 }))
        .userId(userId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QuickConnectQuickConnectConfigUserConfigArgs].
 */
@PulumiTagMarker
public class QuickConnectQuickConnectConfigUserConfigArgsBuilder internal constructor() {
    private var contactFlowId: Output<String>? = null

    private var userId: Output<String>? = null

    /**
     * @param value Specifies the identifier of the contact flow.
     */
    @JvmName("efeidquqbchlhpqo")
    public suspend fun contactFlowId(`value`: Output<String>) {
        this.contactFlowId = value
    }

    /**
     * @param value Specifies the identifier for the user.
     */
    @JvmName("ungbcyaceyvqpfit")
    public suspend fun userId(`value`: Output<String>) {
        this.userId = value
    }

    /**
     * @param value Specifies the identifier of the contact flow.
     */
    @JvmName("nnvfbcqdorwvqaug")
    public suspend fun contactFlowId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contactFlowId = mapped
    }

    /**
     * @param value Specifies the identifier for the user.
     */
    @JvmName("cphuwscshuygnbvh")
    public suspend fun userId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userId = mapped
    }

    internal fun build(): QuickConnectQuickConnectConfigUserConfigArgs =
        QuickConnectQuickConnectConfigUserConfigArgs(
            contactFlowId = contactFlowId ?: throw PulumiNullFieldException("contactFlowId"),
            userId = userId ?: throw PulumiNullFieldException("userId"),
        )
}
