@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin.inputs

import com.pulumi.aws.connect.inputs.RoutingProfileQueueConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property channel Specifies the channels agents can handle in the Contact Control Panel (CCP) for this routing profile. Valid values are `VOICE`, `CHAT`, `TASK`.
 * @property delay Specifies the delay, in seconds, that a contact should be in the queue before they are routed to an available agent
 * @property priority Specifies the order in which contacts are to be handled for the queue.
 * @property queueArn ARN for the queue.
 * @property queueId Specifies the identifier for the queue.
 * @property queueName Name for the queue.
 */
public data class RoutingProfileQueueConfigArgs(
    public val channel: Output<String>,
    public val delay: Output<Int>,
    public val priority: Output<Int>,
    public val queueArn: Output<String>? = null,
    public val queueId: Output<String>,
    public val queueName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.inputs.RoutingProfileQueueConfigArgs> {
    override fun toJava(): com.pulumi.aws.connect.inputs.RoutingProfileQueueConfigArgs =
        com.pulumi.aws.connect.inputs.RoutingProfileQueueConfigArgs.builder()
            .channel(channel.applyValue({ args0 -> args0 }))
            .delay(delay.applyValue({ args0 -> args0 }))
            .priority(priority.applyValue({ args0 -> args0 }))
            .queueArn(queueArn?.applyValue({ args0 -> args0 }))
            .queueId(queueId.applyValue({ args0 -> args0 }))
            .queueName(queueName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RoutingProfileQueueConfigArgs].
 */
@PulumiTagMarker
public class RoutingProfileQueueConfigArgsBuilder internal constructor() {
    private var channel: Output<String>? = null

    private var delay: Output<Int>? = null

    private var priority: Output<Int>? = null

    private var queueArn: Output<String>? = null

    private var queueId: Output<String>? = null

    private var queueName: Output<String>? = null

    /**
     * @param value Specifies the channels agents can handle in the Contact Control Panel (CCP) for this routing profile. Valid values are `VOICE`, `CHAT`, `TASK`.
     */
    @JvmName("ehtesffmobxycmrl")
    public suspend fun channel(`value`: Output<String>) {
        this.channel = value
    }

    /**
     * @param value Specifies the delay, in seconds, that a contact should be in the queue before they are routed to an available agent
     */
    @JvmName("rlvtgpneyojjnskj")
    public suspend fun delay(`value`: Output<Int>) {
        this.delay = value
    }

    /**
     * @param value Specifies the order in which contacts are to be handled for the queue.
     */
    @JvmName("cyguseyhlqswqxjx")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value ARN for the queue.
     */
    @JvmName("ikyfuotettrnudqs")
    public suspend fun queueArn(`value`: Output<String>) {
        this.queueArn = value
    }

    /**
     * @param value Specifies the identifier for the queue.
     */
    @JvmName("dqomkfcsmtvaavse")
    public suspend fun queueId(`value`: Output<String>) {
        this.queueId = value
    }

    /**
     * @param value Name for the queue.
     */
    @JvmName("vajobbtlgqoupxnh")
    public suspend fun queueName(`value`: Output<String>) {
        this.queueName = value
    }

    /**
     * @param value Specifies the channels agents can handle in the Contact Control Panel (CCP) for this routing profile. Valid values are `VOICE`, `CHAT`, `TASK`.
     */
    @JvmName("wgxufdsydicighop")
    public suspend fun channel(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channel = mapped
    }

    /**
     * @param value Specifies the delay, in seconds, that a contact should be in the queue before they are routed to an available agent
     */
    @JvmName("ritpmeabjxhhudhr")
    public suspend fun delay(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.delay = mapped
    }

    /**
     * @param value Specifies the order in which contacts are to be handled for the queue.
     */
    @JvmName("ftusocgqtcjkrsxo")
    public suspend fun priority(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value ARN for the queue.
     */
    @JvmName("iaggnliikbgwthbo")
    public suspend fun queueArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queueArn = mapped
    }

    /**
     * @param value Specifies the identifier for the queue.
     */
    @JvmName("yjodosvngggqksqx")
    public suspend fun queueId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queueId = mapped
    }

    /**
     * @param value Name for the queue.
     */
    @JvmName("tjdukstnlakfqxfp")
    public suspend fun queueName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queueName = mapped
    }

    internal fun build(): RoutingProfileQueueConfigArgs = RoutingProfileQueueConfigArgs(
        channel = channel ?: throw PulumiNullFieldException("channel"),
        delay = delay ?: throw PulumiNullFieldException("delay"),
        priority = priority ?: throw PulumiNullFieldException("priority"),
        queueArn = queueArn,
        queueId = queueId ?: throw PulumiNullFieldException("queueId"),
        queueName = queueName,
    )
}
